/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.rankingexpression.importer.operations;

import ai.vespa.rankingexpression.importer.DimensionRenamer;
import ai.vespa.rankingexpression.importer.OrderedTensorType;
import ai.vespa.rankingexpression.importer.operations.IntermediateOperation;
import com.yahoo.searchlib.rankingexpression.Reference;
import com.yahoo.tensor.TensorType;
import com.yahoo.tensor.functions.TensorFunction;
import java.util.List;

public class Rename
extends IntermediateOperation {
    private String from;
    private String to;

    public Rename(String modelName, String from, String to, IntermediateOperation input) {
        super(modelName, "rename", input != null ? List.of(input) : List.of());
        this.from = from;
        this.to = to;
    }

    @Override
    protected OrderedTensorType lazyGetType() {
        if (!this.allInputTypesPresent(1)) {
            return null;
        }
        OrderedTensorType inputType = ((IntermediateOperation)this.inputs.get(0)).type().orElse(null);
        if (inputType == null) {
            return null;
        }
        OrderedTensorType.Builder builder = new OrderedTensorType.Builder(inputType.type().valueType());
        for (TensorType.Dimension dimension : inputType.dimensions()) {
            builder.add(dimension.withName(dimension.name().equals(this.from) ? this.to : dimension.name()));
        }
        return builder.build();
    }

    @Override
    protected TensorFunction<Reference> lazyGetFunction() {
        if (!this.allInputFunctionsPresent(1)) {
            return null;
        }
        return new com.yahoo.tensor.functions.Rename((TensorFunction)((IntermediateOperation)this.inputs.get(0)).function().orElse(null), this.from, this.to);
    }

    @Override
    public void addDimensionNameConstraints(DimensionRenamer renamer) {
        renamer.addDimension(this.to);
    }

    @Override
    public void renameDimensions(DimensionRenamer renamer) {
        super.renameDimensions(renamer);
        this.from = renamer.dimensionNameOf(this.from).orElse(this.from);
        this.to = renamer.dimensionNameOf(this.to).orElse(this.to);
    }

    @Override
    public Rename withInputs(List<IntermediateOperation> inputs) {
        if (inputs.size() != 1) {
            throw new IllegalArgumentException("Rename require 1 input, not " + inputs.size());
        }
        return new Rename(this.modelName(), this.from, this.to, inputs.get(0));
    }

    @Override
    public String operationName() {
        return "Rename";
    }
}

