/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.models.evaluation;

import ai.vespa.modelintegration.evaluator.OnnxRuntime;
import ai.vespa.models.evaluation.FunctionEvaluator;
import ai.vespa.models.evaluation.Model;
import ai.vespa.models.evaluation.RankProfilesConfigImporter;
import com.yahoo.api.annotations.Beta;
import com.yahoo.component.AbstractComponent;
import com.yahoo.component.annotation.Inject;
import com.yahoo.filedistribution.fileacquirer.FileAcquirer;
import com.yahoo.vespa.config.search.RankProfilesConfig;
import com.yahoo.vespa.config.search.core.OnnxModelsConfig;
import com.yahoo.vespa.config.search.core.RankingConstantsConfig;
import com.yahoo.vespa.config.search.core.RankingExpressionsConfig;
import java.util.Collections;
import java.util.Map;

@Beta
public class ModelsEvaluator
extends AbstractComponent {
    private final Map<String, Model> models;

    @Inject
    public ModelsEvaluator(RankProfilesConfig config, RankingConstantsConfig constantsConfig, RankingExpressionsConfig expressionsConfig, OnnxModelsConfig onnxModelsConfig, FileAcquirer fileAcquirer, OnnxRuntime onnx) {
        this(new RankProfilesConfigImporter(fileAcquirer, onnx), config, constantsConfig, expressionsConfig, onnxModelsConfig);
    }

    public ModelsEvaluator(RankProfilesConfig config, RankingConstantsConfig constantsConfig, RankingExpressionsConfig expressionsConfig, OnnxModelsConfig onnxModelsConfig, FileAcquirer fileAcquirer) {
        this(config, constantsConfig, expressionsConfig, onnxModelsConfig, fileAcquirer, OnnxRuntime.testInstance());
    }

    public ModelsEvaluator(RankProfilesConfigImporter importer, RankProfilesConfig config, RankingConstantsConfig constantsConfig, RankingExpressionsConfig expressionsConfig, OnnxModelsConfig onnxModelsConfig) {
        this(importer.importFrom(config, constantsConfig, expressionsConfig, onnxModelsConfig));
    }

    public ModelsEvaluator(Map<String, Model> models) {
        this.models = Collections.unmodifiableMap(models);
    }

    public Map<String, Model> models() {
        return this.models;
    }

    public FunctionEvaluator evaluatorOf(String modelName, String ... names) {
        return this.requireModel(modelName).evaluatorOf(names);
    }

    public Model requireModel(String name) {
        Model model = this.models.get(name);
        if (model == null) {
            throw new IllegalArgumentException("No model named '" + name + "'. Available models: " + String.join((CharSequence)", ", this.models.keySet()));
        }
        return model;
    }

    public void deconstruct() {
        this.models.values().forEach(Model::close);
    }
}

