/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.models.evaluation;

import ai.vespa.models.evaluation.FunctionReference;
import ai.vespa.models.evaluation.Model;
import com.yahoo.searchlib.rankingexpression.evaluation.Context;
import com.yahoo.searchlib.rankingexpression.evaluation.Value;
import com.yahoo.searchlib.rankingexpression.rule.Function;
import com.yahoo.tensor.Tensor;
import com.yahoo.tensor.TensorType;

class LazyValue
extends Value {
    private final FunctionReference function;
    private final Context context;
    private final Model model;
    private Value computedValue = null;

    public LazyValue(FunctionReference function, Context context, Model model) {
        this.function = function;
        this.context = context;
        this.model = model;
    }

    private Value computedValue() {
        if (this.computedValue == null) {
            this.computedValue = this.model.requireReferencedFunction(this.function).getBody().evaluate(this.context);
        }
        return this.computedValue;
    }

    public TensorType type() {
        return (TensorType)this.model.requireReferencedFunction(this.function).returnType().get();
    }

    public double asDouble() {
        return this.computedValue().asDouble();
    }

    public Tensor asTensor() {
        return this.computedValue().asTensor();
    }

    public boolean hasDouble() {
        return this.type().rank() == 0;
    }

    public boolean asBoolean() {
        return this.computedValue().asBoolean();
    }

    public Value negate() {
        return this.computedValue().negate();
    }

    public Value not() {
        return this.computedValue().not();
    }

    public Value or(Value value) {
        return this.computedValue().or(value);
    }

    public Value and(Value value) {
        return this.computedValue().and(value);
    }

    public Value largerOrEqual(Value value) {
        return this.computedValue().largerOrEqual(value);
    }

    public Value larger(Value value) {
        return this.computedValue().larger(value);
    }

    public Value smallerOrEqual(Value value) {
        return this.computedValue().smallerOrEqual(value);
    }

    public Value smaller(Value value) {
        return this.computedValue().smaller(value);
    }

    public Value approxEqual(Value value) {
        return this.computedValue().approxEqual(value);
    }

    public Value notEqual(Value value) {
        return this.computedValue().notEqual(value);
    }

    public Value equal(Value value) {
        return this.computedValue().equal(value);
    }

    public Value add(Value value) {
        return this.computedValue().add(value);
    }

    public Value subtract(Value value) {
        return this.computedValue().subtract(value);
    }

    public Value multiply(Value value) {
        return this.computedValue().multiply(value);
    }

    public Value divide(Value value) {
        return this.computedValue().divide(value);
    }

    public Value modulo(Value value) {
        return this.computedValue().modulo(value);
    }

    public Value power(Value value) {
        return this.computedValue().power(value);
    }

    public Value function(Function function, Value value) {
        return this.computedValue().function(function, value);
    }

    public Value asMutable() {
        return this.computedValue().asMutable();
    }

    public String toString() {
        return "value of " + this.function;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Value)) {
            return false;
        }
        return this.computedValue().equals(other);
    }

    public int hashCode() {
        return this.computedValue().hashCode();
    }

    LazyValue copyFor(Context context) {
        return new LazyValue(this.function, context, this.model);
    }
}

