/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.metrics.docs;

import ai.vespa.metrics.Unit;
import java.io.FileWriter;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class UnitDocumentation {
    protected static void writeUnitDocumentation(String path, Unit[] units) {
        StringBuilder referenceBuilder = new StringBuilder();
        referenceBuilder.append(String.format("---\n# Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.\ntitle: \"Metric Units Reference\"\n---\n\n\n<table class=\"table\">\n  <thead>\n      <tr><th>Unit</th><th>Description</th></tr>\n  </thead>\n  <tbody>\n%s    </tbody>\n</table>\n", UnitDocumentation.htmlRows(units)));
        try (FileWriter fileWriter = new FileWriter(path + "/unit-metrics-reference.html");){
            fileWriter.write(referenceBuilder.toString());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static String htmlRows(Unit[] units) {
        return Stream.of(units).map(unit -> String.format("    <tr>\n      <td>%s</td>\n      <td>%s</td>\n    </tr>\n", unit.fullName(), unit.getDescription())).collect(Collectors.joining());
    }
}

