/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.metricsproxy.metric;

import ai.vespa.metricsproxy.core.ConfiguredMetric;
import ai.vespa.metricsproxy.core.MetricsConsumers;
import ai.vespa.metricsproxy.metric.model.DimensionId;
import ai.vespa.metricsproxy.metric.model.MetricId;
import ai.vespa.metricsproxy.metric.model.MetricsPacket;
import ai.vespa.metricsproxy.metric.model.ServiceId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class ExternalMetrics {
    private static final Logger log = Logger.getLogger(ExternalMetrics.class.getName());
    public static final ServiceId VESPA_NODE_SERVICE_ID = ServiceId.toServiceId("vespa.node");
    public static final DimensionId ROLE_DIMENSION = DimensionId.toDimensionId("role");
    public static final DimensionId STATE_DIMENSION = DimensionId.toDimensionId("state");
    public static final DimensionId ORCHESTRATOR_STATE_DIMENSION = DimensionId.toDimensionId("orchestratorState");
    private volatile List<MetricsPacket.Builder> metrics = new ArrayList<MetricsPacket.Builder>();
    private final MetricsConsumers consumers;

    public ExternalMetrics(MetricsConsumers consumers) {
        this.consumers = consumers;
    }

    public List<MetricsPacket.Builder> getMetrics() {
        return this.metrics;
    }

    public void setExtraMetrics(List<MetricsPacket.Builder> externalPackets) {
        log.log(Level.FINE, () -> "Setting new external metrics with " + externalPackets.size() + " metrics packets.");
        externalPackets.forEach(packet -> packet.addConsumers(this.consumers.getAllConsumers()).retainMetrics(this.metricsToRetain()).applyOutputNames(this.outputNamesById()));
        this.metrics = List.copyOf(externalPackets);
    }

    private Set<MetricId> metricsToRetain() {
        return this.consumers.getConsumersByMetric().keySet().stream().map(ConfiguredMetric::id).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private Map<MetricId, List<MetricId>> outputNamesById() {
        LinkedHashMap<MetricId, List<MetricId>> outputNamesById = new LinkedHashMap<MetricId, List<MetricId>>();
        for (ConfiguredMetric metric : this.consumers.getConsumersByMetric().keySet()) {
            outputNamesById.computeIfAbsent(metric.id(), unused -> new ArrayList()).add(metric.outputname());
        }
        return outputNamesById;
    }

    public static Map<DimensionId, String> extractConfigserverDimensions(Collection<MetricsPacket.Builder> packets) {
        HashMap<DimensionId, String> dimensions = new HashMap<DimensionId, String>();
        for (MetricsPacket.Builder packet : packets) {
            dimensions.putAll(packet.build().dimensions());
        }
        dimensions.keySet().retainAll(Set.of(ROLE_DIMENSION, STATE_DIMENSION, ORCHESTRATOR_STATE_DIMENSION));
        return dimensions;
    }
}

