/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.metricsproxy.http.metrics;

import ai.vespa.metricsproxy.core.MetricsConsumers;
import ai.vespa.metricsproxy.core.MetricsManager;
import ai.vespa.metricsproxy.http.ValuesFetcher;
import ai.vespa.metricsproxy.metric.model.MetricsPacket;
import ai.vespa.metricsproxy.metric.model.json.GenericJsonUtil;
import ai.vespa.metricsproxy.service.VespaServices;
import com.yahoo.component.annotation.Inject;
import com.yahoo.container.handler.metrics.ErrorResponse;
import com.yahoo.container.handler.metrics.HttpHandlerBase;
import com.yahoo.container.handler.metrics.JsonResponse;
import com.yahoo.container.jdisc.HttpResponse;
import com.yahoo.restapi.Path;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.logging.Level;

public class MetricsV1Handler
extends HttpHandlerBase {
    public static final String V1_PATH = "/metrics/v1";
    public static final String VALUES_PATH = "/metrics/v1/values";
    private final ValuesFetcher valuesFetcher;

    @Inject
    public MetricsV1Handler(Executor executor, MetricsManager metricsManager, VespaServices vespaServices, MetricsConsumers metricsConsumers) {
        super(executor);
        this.valuesFetcher = new ValuesFetcher(metricsManager, vespaServices, metricsConsumers);
    }

    public Optional<HttpResponse> doHandle(URI requestUri, Path apiPath, String consumer) {
        if (apiPath.matches(V1_PATH)) {
            return Optional.of(this.resourceListResponse(requestUri, List.of(VALUES_PATH)));
        }
        if (apiPath.matches(VALUES_PATH)) {
            return Optional.of(this.valuesResponse(consumer));
        }
        return Optional.empty();
    }

    private JsonResponse valuesResponse(String consumer) {
        try {
            List<MetricsPacket> metrics = this.valuesFetcher.fetch(consumer);
            return new JsonResponse(200, GenericJsonUtil.toGenericJsonModel(metrics).serialize());
        }
        catch (Exception e) {
            this.log.log(Level.WARNING, "Got exception when rendering metrics:", e);
            return new ErrorResponse(500, e.getMessage());
        }
    }
}

