/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.messagebus.routing;

import com.yahoo.messagebus.routing.ApplicationSpec;
import com.yahoo.messagebus.routing.HopSpec;
import com.yahoo.messagebus.routing.RoutingSpec;
import com.yahoo.messagebus.routing.RoutingTableSpec;
import java.util.ArrayList;
import java.util.List;

public class RouteSpec {
    private final String name;
    private final List<String> hops = new ArrayList<String>();
    private final boolean verify;

    public RouteSpec(String name) {
        this(name, true);
    }

    public RouteSpec(String name, boolean verify) {
        this.name = name;
        this.verify = verify;
    }

    public RouteSpec(RouteSpec obj) {
        this.name = obj.name;
        this.verify = obj.verify;
        for (String hop : obj.hops) {
            this.hops.add(hop);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getHop(int i) {
        return this.hops.get(i);
    }

    public boolean hasHops() {
        return !this.hops.isEmpty();
    }

    public int getNumHops() {
        return this.hops.size();
    }

    public RouteSpec addHop(String hop) {
        this.hops.add(hop);
        return this;
    }

    public RouteSpec addHops(List<String> hops) {
        this.hops.addAll(hops);
        return this;
    }

    public RouteSpec setHop(int i, String hop) {
        this.hops.set(i, hop);
        return this;
    }

    public String removeHop(int i) {
        return this.hops.remove(i);
    }

    public RouteSpec clearHops() {
        this.hops.clear();
        return this;
    }

    public boolean verify(ApplicationSpec app, RoutingTableSpec table, List<String> errors) {
        if (this.verify) {
            String protocol = table.getProtocol();
            int numHops = this.hops.size();
            if (numHops == 0) {
                errors.add("Route '" + this.name + "' in routing table '" + protocol + "' has no hops.");
            } else {
                for (int i = 0; i < numHops; ++i) {
                    HopSpec.verify(app, table, null, null, this.hops.get(i), errors, "hop " + (i + 1) + " in route '" + this.name + "' in routing table '" + protocol + "'");
                }
            }
        }
        return errors.isEmpty();
    }

    public void toConfig(StringBuilder cfg, String prefix) {
        cfg.append(prefix).append("name ").append(RoutingSpec.toConfigString(this.name)).append("\n");
        int numHops = this.hops.size();
        if (numHops > 0) {
            cfg.append(prefix).append("hop[").append(numHops).append("]\n");
            for (int i = 0; i < numHops; ++i) {
                cfg.append(prefix).append("hop[").append(i).append("] ");
                cfg.append(RoutingSpec.toConfigString(this.hops.get(i))).append("\n");
            }
        }
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        this.toConfig(ret, "");
        return ret.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RouteSpec)) {
            return false;
        }
        RouteSpec rhs = (RouteSpec)obj;
        if (!this.name.equals(rhs.name)) {
            return false;
        }
        return this.hops.equals(rhs.hops);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.hops != null ? this.hops.hashCode() : 0);
        result = 31 * result + (this.verify ? 1 : 0);
        return result;
    }
}

