/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.messagebus.routing.test;

import com.yahoo.messagebus.EmptyReply;
import com.yahoo.messagebus.Reply;
import com.yahoo.messagebus.routing.Route;
import com.yahoo.messagebus.routing.RoutingContext;
import com.yahoo.messagebus.routing.RoutingNodeIterator;
import com.yahoo.messagebus.routing.RoutingPolicy;
import java.util.ArrayList;
import java.util.List;

public class CustomPolicy
implements RoutingPolicy {
    private boolean selectOnRetry;
    private final List<Integer> consumableErrors = new ArrayList<Integer>();
    private final List<Route> routes = new ArrayList<Route>();

    public CustomPolicy(boolean selectOnRetry, List<Integer> consumableErrors, List<Route> routes) {
        this.selectOnRetry = selectOnRetry;
        this.consumableErrors.addAll(consumableErrors);
        this.routes.addAll(routes);
    }

    @Override
    public void select(RoutingContext context) {
        context.trace(1, "Selecting " + this.routes + ".");
        context.setSelectOnRetry(this.selectOnRetry);
        for (int e : this.consumableErrors) {
            context.addConsumableError(e);
        }
        context.addChildren(this.routes);
    }

    @Override
    public void merge(RoutingContext context) {
        ArrayList<String> lst = new ArrayList<String>();
        EmptyReply ret = new EmptyReply();
        RoutingNodeIterator it = context.getChildIterator();
        while (it.isValid()) {
            lst.add(it.getRoute().toString());
            Reply reply = it.getReplyRef();
            for (int i = 0; i < reply.getNumErrors(); ++i) {
                ret.addError(reply.getError(i));
            }
            it.next();
        }
        context.setReply(ret);
        context.trace(1, "Merged " + lst + ".");
    }

    @Override
    public void destroy() {
    }
}

