/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.messagebus;

import com.yahoo.messagebus.Message;
import com.yahoo.messagebus.MessageHandler;
import com.yahoo.messagebus.Messenger;
import com.yahoo.messagebus.Reply;
import com.yahoo.messagebus.ReplyHandler;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicBoolean;

public class Sequencer
implements MessageHandler,
ReplyHandler {
    private final AtomicBoolean destroyed = new AtomicBoolean(false);
    private final MessageHandler sender;
    private final Map<Long, Queue<Message>> seqMap = new HashMap<Long, Queue<Message>>();
    private final Messenger msn;
    private static final ThreadLocal<Boolean> isSending = ThreadLocal.withInitial(() -> Boolean.FALSE);

    public Sequencer(MessageHandler sender, Messenger msn) {
        this.sender = sender;
        this.msn = msn;
    }

    public Sequencer(MessageHandler sender) {
        this(sender, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean destroy() {
        if (!this.destroyed.getAndSet(true)) {
            Sequencer sequencer = this;
            synchronized (sequencer) {
                for (Queue<Message> queue : this.seqMap.values()) {
                    if (queue == null) continue;
                    for (Message msg : queue) {
                        msg.discard();
                    }
                }
                this.seqMap.clear();
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean filter(Message msg) {
        long seqId = msg.getSequenceId();
        msg.setContext(seqId);
        Sequencer sequencer = this;
        synchronized (sequencer) {
            if (this.seqMap.containsKey(seqId)) {
                Queue queue = this.seqMap.computeIfAbsent(seqId, k -> new LinkedList());
                if (msg.getTrace().shouldTrace(6)) {
                    msg.getTrace().trace(6, "Sequencer queued message with sequence id '" + seqId + "'.");
                }
                queue.add(msg);
                return false;
            }
            this.seqMap.put(seqId, null);
        }
        return true;
    }

    private void sequencedSend(Message msg) {
        if (msg.getTrace().shouldTrace(6)) {
            msg.getTrace().trace(6, "Sequencer sending message with sequence id '" + msg.getContext() + "'.");
        }
        msg.pushHandler(this);
        this.sender.handleMessage(msg);
    }

    @Override
    public void handleMessage(Message msg) {
        if (this.destroyed.get()) {
            msg.discard();
            return;
        }
        if (msg.hasSequenceId()) {
            if (this.filter(msg)) {
                this.sequencedSend(msg);
            }
        } else {
            this.sender.handleMessage(msg);
        }
    }

    @Override
    public void handleReply(Reply reply) {
        if (this.destroyed.get()) {
            reply.discard();
            return;
        }
        long seqId = (Long)reply.getContext();
        if (reply.getTrace().shouldTrace(6)) {
            reply.getTrace().trace(6, "Sequencer received reply with sequence id '" + seqId + "'.");
        }
        this.sendNextInSequence(seqId);
        ReplyHandler handler = reply.popHandler();
        handler.handleReply(reply);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendNextInSequence(long seqId) {
        Message msg = null;
        Sequencer sequencer = this;
        synchronized (sequencer) {
            Queue<Message> queue = this.seqMap.get(seqId);
            if (queue == null || queue.isEmpty()) {
                this.seqMap.remove(seqId);
            } else {
                msg = queue.remove();
            }
        }
        if (msg != null) {
            Boolean alreadySending = isSending.get();
            if (alreadySending.booleanValue() && this.msn != null) {
                this.msn.enqueue(new SequencedSendTask(msg));
            } else {
                isSending.set(Boolean.TRUE);
                this.sequencedSend(msg);
            }
            isSending.set(Boolean.FALSE);
        }
    }

    private class SequencedSendTask
    implements Messenger.Task {
        private Message msg;

        SequencedSendTask(Message msg) {
            this.msg = msg;
        }

        @Override
        public void run() {
            Sequencer.this.sequencedSend(this.msg);
            this.msg = null;
        }

        @Override
        public void destroy() {
            if (this.msg != null) {
                this.msg.discard();
            }
        }
    }
}

