/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.language.lucene;

import com.google.inject.Inject;
import com.yahoo.component.provider.ComponentRegistry;
import com.yahoo.language.Linguistics;
import com.yahoo.language.lucene.LuceneAnalysisConfig;
import com.yahoo.language.lucene.LuceneTokenizer;
import com.yahoo.language.process.Tokenizer;
import com.yahoo.language.simple.SimpleLinguistics;
import java.util.logging.Logger;
import org.apache.lucene.analysis.Analyzer;

public class LuceneLinguistics
extends SimpleLinguistics {
    private static final Logger log = Logger.getLogger(LuceneLinguistics.class.getName());
    private final LuceneTokenizer tokenizer;
    private final LuceneAnalysisConfig config;

    @Inject
    public LuceneLinguistics(LuceneAnalysisConfig config, ComponentRegistry<Analyzer> analyzers) {
        log.config("Creating LuceneLinguistics with: " + String.valueOf((Object)config));
        this.config = config;
        this.tokenizer = new LuceneTokenizer(config, analyzers);
    }

    public Tokenizer getTokenizer() {
        return this.tokenizer;
    }

    public boolean equals(Linguistics other) {
        return other instanceof LuceneLinguistics && this.config.equals((Object)((LuceneLinguistics)other).config);
    }

    public String toString() {
        return "LuceneLinguistics";
    }
}

