/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.language.simple;

import com.yahoo.language.LinguisticsCase;
import com.yahoo.language.process.LinguisticsParameters;
import com.yahoo.language.process.Normalizer;
import com.yahoo.language.process.SpecialTokenRegistry;
import com.yahoo.language.process.StemMode;
import com.yahoo.language.process.Token;
import com.yahoo.language.process.TokenScript;
import com.yahoo.language.process.TokenType;
import com.yahoo.language.process.Tokenizer;
import com.yahoo.language.process.Transformer;
import com.yahoo.language.simple.SimpleNormalizer;
import com.yahoo.language.simple.SimpleToken;
import com.yahoo.language.simple.SimpleTokenScript;
import com.yahoo.language.simple.SimpleTokenType;
import com.yahoo.language.simple.SimpleTransformer;
import com.yahoo.language.simple.kstem.KStemmer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SimpleTokenizer
implements Tokenizer {
    private static final Logger log = Logger.getLogger(SimpleTokenizer.class.getName());
    private static final int SPACE_CODE = 32;
    private final Normalizer normalizer;
    private final Transformer transformer;
    private final KStemmer stemmer = new KStemmer();
    private final SpecialTokenRegistry specialTokenRegistry;

    public SimpleTokenizer() {
        this(new SimpleNormalizer(), new SimpleTransformer());
    }

    public SimpleTokenizer(Normalizer normalizer) {
        this(normalizer, new SimpleTransformer());
    }

    public SimpleTokenizer(Normalizer normalizer, Transformer transformer) {
        this(normalizer, transformer, new SpecialTokenRegistry(List.of()));
    }

    public SimpleTokenizer(Normalizer normalizer, Transformer transformer, SpecialTokenRegistry specialTokenRegistry) {
        this.normalizer = normalizer;
        this.transformer = transformer;
        this.specialTokenRegistry = specialTokenRegistry;
    }

    @Override
    public Iterable<Token> tokenize(String input, LinguisticsParameters parameters) {
        return this.tokenize(input, (String token) -> this.processToken((String)token, parameters));
    }

    public Iterable<Token> tokenize(String input, Function<String, String> tokenProcessor) {
        TokenScript prevScript;
        TokenType prevType;
        if (input.isEmpty()) {
            return List.of();
        }
        ArrayList<Token> tokens = new ArrayList<Token>();
        int nextCode = input.codePointAt(0);
        TokenType tokenType = prevType = SimpleTokenType.valueOf(nextCode);
        TokenScript tokenScript = prevScript = SimpleTokenScript.valueOf(nextCode);
        int prev = 0;
        for (int next = Character.charCount(nextCode); next <= input.length(); next += Character.charCount(nextCode)) {
            nextCode = next < input.length() ? input.codePointAt(next) : 32;
            TokenType nextType = SimpleTokenType.valueOf(nextCode);
            TokenScript nextScript = SimpleTokenScript.valueOf(nextCode);
            if (this.isAtTokenBoundary(prevType, nextType)) {
                String original = input.substring(prev, next);
                tokens.add(new SimpleToken(original).setOffset(prev).setType(tokenType).setTokenString(tokenProcessor.apply(original)).setScript(tokenScript));
                prev = next;
                prevType = nextType;
                prevScript = nextScript;
                tokenType = prevType;
                tokenScript = prevScript;
                continue;
            }
            tokenType = this.determineType(tokenType, nextType);
            tokenScript = this.determineScript(tokenScript, nextScript);
        }
        return tokens;
    }

    private boolean isAtTokenBoundary(TokenType prevType, TokenType nextType) {
        if (prevType == TokenType.INDEXABLE_SYMBOL || nextType == TokenType.INDEXABLE_SYMBOL) {
            return true;
        }
        return !prevType.isIndexable() || !nextType.isIndexable();
    }

    private TokenType determineType(TokenType tokenType, TokenType characterType) {
        if (characterType == TokenType.ALPHABETIC) {
            return TokenType.ALPHABETIC;
        }
        return tokenType;
    }

    private TokenScript determineScript(TokenScript tokenScript, TokenScript characterScript) {
        if (characterScript == TokenScript.LATIN) {
            return TokenScript.LATIN;
        }
        return tokenScript;
    }

    private String processToken(String token, LinguisticsParameters parameters) {
        String original = token;
        log.log(Level.FINEST, () -> "processToken '" + original + "'");
        token = this.normalizer.normalize(token);
        if (parameters.lowercase()) {
            token = LinguisticsCase.toLowerCase(token);
        }
        if (parameters.removeAccents()) {
            token = this.transformer.accentDrop(token, parameters.language());
        }
        if (parameters.stemMode() != StemMode.NONE) {
            String oldToken = token;
            String newToken = token = this.stemmer.stem(token);
            log.log(Level.FINEST, () -> "stem '" + oldToken + "' to '" + newToken + "'");
        }
        String result = token;
        log.log(Level.FINEST, () -> "processed token is: " + result);
        return result;
    }
}

