/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.language.significance.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.yahoo.language.significance.DocumentFrequency;
import com.yahoo.language.significance.SignificanceModel;
import com.yahoo.language.significance.impl.DocumentFrequencyFile;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;

public class DefaultSignificanceModel
implements SignificanceModel {
    private final long corpusSize;
    private final Map<String, Long> frequencies;
    private String id;

    public DefaultSignificanceModel(DocumentFrequencyFile file, String id) {
        this.frequencies = file.frequencies();
        this.corpusSize = file.documentCount();
        this.id = id;
    }

    public DefaultSignificanceModel(Path path) {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            DocumentFrequencyFile file = (DocumentFrequencyFile)objectMapper.readValue(path.toFile(), DocumentFrequencyFile.class);
            this.frequencies = file.frequencies();
            this.corpusSize = file.documentCount();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load model from " + String.valueOf(path), e);
        }
    }

    @Override
    public DocumentFrequency documentFrequency(String word) {
        if (this.frequencies.containsKey(word)) {
            return new DocumentFrequency(this.frequencies.get(word), this.corpusSize);
        }
        return new DocumentFrequency(1L, this.corpusSize);
    }

    @Override
    public String getId() {
        return this.id;
    }
}

