/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.language.process;

import com.yahoo.language.Language;
import com.yahoo.language.process.LinguisticsParameters;
import com.yahoo.language.process.Segmenter;
import com.yahoo.language.process.StemMode;
import com.yahoo.language.process.Token;
import com.yahoo.language.process.Tokenizer;
import java.util.ArrayList;
import java.util.List;

public class SegmenterImpl
implements Segmenter {
    private final Tokenizer tokenizer;

    public SegmenterImpl(Tokenizer tokenizer) {
        this.tokenizer = tokenizer;
    }

    @Override
    public List<String> segment(String input, Language language) {
        LinguisticsParameters parameters = new LinguisticsParameters(language, StemMode.NONE, false, false);
        ArrayList<String> segments = new ArrayList<String>();
        for (Token token : this.tokenizer.tokenize(input, parameters)) {
            this.findSegments(token, segments);
        }
        if (segments.isEmpty()) {
            segments.add(input);
        }
        return segments;
    }

    private void findSegments(Token token, List<String> out) {
        int len;
        if (token.isSpecialToken() || (len = token.getNumComponents()) == 0) {
            String orig;
            if (token.isIndexable() && !(orig = token.getOrig()).isEmpty()) {
                out.add(orig);
            }
        } else {
            for (int i = 0; i < len; ++i) {
                this.findSegments(token.getComponent(i), out);
            }
        }
    }
}

