/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.language.process;

import ai.vespa.llm.completion.Prompt;
import com.yahoo.collections.LazyMap;
import com.yahoo.language.Language;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;

public interface TextGenerator {
    public static final String defaultGeneratorId = "default";
    public static final TextGenerator throwsOnUse = new FailingTextGenerator();

    default public Map<String, TextGenerator> asMap() {
        return this.asMap(defaultGeneratorId);
    }

    default public Map<String, TextGenerator> asMap(String name) {
        return Map.of(name, this);
    }

    public String generate(Prompt var1, Context var2);

    public static class FailingTextGenerator
    implements TextGenerator {
        private final String message;

        public FailingTextGenerator() {
            this("No generator has been configured");
        }

        public FailingTextGenerator(String message) {
            this.message = message;
        }

        @Override
        public String generate(Prompt prompt, Context context) {
            throw new IllegalStateException(this.message);
        }
    }

    public static class Context {
        private Language language = Language.UNKNOWN;
        private String destination;
        private String generatorId = "unknown";
        private final Map<Object, Object> cache;

        public Context(String destination) {
            this(destination, (Map<Object, Object>)LazyMap.newHashMap());
        }

        public Context(String destination, Map<Object, Object> cache) {
            this.destination = destination;
            this.cache = Objects.requireNonNull(cache);
        }

        private Context(Context other) {
            this.language = other.language;
            this.destination = other.destination;
            this.generatorId = other.generatorId;
            this.cache = other.cache;
        }

        public Context copy() {
            return new Context(this);
        }

        public Language getLanguage() {
            return this.language;
        }

        public Context setLanguage(Language language) {
            this.language = language != null ? language : Language.UNKNOWN;
            return this;
        }

        public String getDestination() {
            return this.destination;
        }

        public Context setDestination(String destination) {
            this.destination = destination;
            return this;
        }

        public String getGeneratorId() {
            return this.generatorId;
        }

        public Context setGeneratorId(String generatorId) {
            this.generatorId = generatorId;
            return this;
        }

        public void putCachedValue(Object key, Object value) {
            this.cache.put(key, value);
        }

        public Object getCachedValue(Object key) {
            return this.cache.get(key);
        }

        public <T> T computeCachedValueIfAbsent(Object key, Supplier<? extends T> supplier) {
            return (T)this.cache.computeIfAbsent(key, __ -> supplier.get());
        }
    }
}

