/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jrt.slobrok.server;

import com.yahoo.jrt.Acceptor;
import com.yahoo.jrt.Int32Value;
import com.yahoo.jrt.ListenFailedException;
import com.yahoo.jrt.Method;
import com.yahoo.jrt.MethodHandler;
import com.yahoo.jrt.Request;
import com.yahoo.jrt.RequestWaiter;
import com.yahoo.jrt.Spec;
import com.yahoo.jrt.StringArray;
import com.yahoo.jrt.Supervisor;
import com.yahoo.jrt.Target;
import com.yahoo.jrt.TargetWatcher;
import com.yahoo.jrt.Task;
import com.yahoo.jrt.Transport;
import com.yahoo.security.tls.Capability;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Slobrok {
    Supervisor orb;
    Acceptor listener;
    private Map<String, String> services = new HashMap<String, String>();
    List<FetchMirror> pendingFetch = new ArrayList<FetchMirror>();
    Map<String, Target> targets = new HashMap<String, Target>();
    TargetMonitor monitor = new TargetMonitor();
    int gencnt = 1;

    public String lookup(String name) {
        return this.services.get(name);
    }

    public Slobrok(int port) throws ListenFailedException {
        this.orb = new Supervisor(new Transport("slobrok-" + port, 1)).setDropEmptyBuffers(true);
        this.registerMethods();
        try {
            this.listener = this.orb.listen(new Spec(port));
        }
        catch (ListenFailedException e) {
            this.orb.transport().shutdown().join();
            throw e;
        }
    }

    public Slobrok() throws ListenFailedException {
        this(0);
    }

    public int port() {
        return this.listener.port();
    }

    public void stop() {
        this.orb.transport().shutdown().join();
        this.listener.shutdown().join();
    }

    public String configId() {
        return "raw:slobrok[1]\nslobrok[0].connectionspec \"" + new Spec("localhost", this.listener.port()).toString() + "\"\n";
    }

    private void updated() {
        ++this.gencnt;
        if (this.gencnt == 0) {
            ++this.gencnt;
        }
        this.handleFetchMirrorFlush();
    }

    private void handleRegisterCallbackDone(Request req, String name, String spec, Target target) {
        String stored = this.services.get(name);
        if (stored != null) {
            if (!stored.equals(spec)) {
                req.setError(111, "service '" + name + "' registered with another spec");
            }
            req.returnRequest();
            target.close();
            return;
        }
        target.setContext(name);
        target.addWatcher(this.monitor);
        this.services.put(name, spec);
        this.targets.put(name, target);
        req.returnRequest();
        this.updated();
    }

    private void handleTargetDown(Target target) {
        String name = (String)target.getContext();
        this.targets.remove(name);
        this.services.remove(name);
        this.updated();
    }

    private void dumpServices(Request req) {
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<String> specs = new ArrayList<String>();
        for (Map.Entry<String, String> entry : this.services.entrySet()) {
            names.add(entry.getKey());
            specs.add(entry.getValue());
        }
        req.returnValues().add(new StringArray(names.toArray(new String[names.size()])));
        req.returnValues().add(new StringArray(specs.toArray(new String[specs.size()])));
        req.returnValues().add(new Int32Value(this.gencnt));
    }

    private void handleFetchMirrorTimeout(FetchMirror fetch) {
        this.pendingFetch.remove(fetch);
        fetch.req.returnValues().add(new StringArray(new String[0]));
        fetch.req.returnValues().add(new StringArray(new String[0]));
        fetch.req.returnValues().add(new Int32Value(this.gencnt));
        fetch.req.returnRequest();
    }

    private void handleFetchMirrorFlush() {
        for (FetchMirror fetch : this.pendingFetch) {
            fetch.task.kill();
            this.dumpServices(fetch.req);
            fetch.req.returnRequest();
        }
        this.pendingFetch.clear();
    }

    private void registerMethods() {
        this.orb.addMethod(new Method("slobrok.registerRpcServer", "ss", "", new MethodHandler(){

            @Override
            public void invoke(Request req) {
                Slobrok.this.rpc_register(req);
            }
        }).requireCapabilities(Capability.SLOBROK__API).methodDesc("Register a rpcserver").paramDesc(0, "name", "RpcServer name").paramDesc(1, "spec", "The connection specification"));
        this.orb.addMethod(new Method("slobrok.unregisterRpcServer", "ss", "", new MethodHandler(){

            @Override
            public void invoke(Request req) {
                Slobrok.this.rpc_unregister(req);
            }
        }).requireCapabilities(Capability.SLOBROK__API).methodDesc("Unregister a rpcserver").paramDesc(0, "name", "RpcServer name").paramDesc(1, "spec", "The connection specification"));
        this.orb.addMethod(new Method("slobrok.incremental.fetch", "ii", "iSSSi", new MethodHandler(){

            @Override
            public void invoke(Request req) {
                Slobrok.this.rpc_fetchIncremental(req);
            }
        }).requireCapabilities(Capability.SLOBROK__API).methodDesc("Fetch or update mirror of name to spec map").paramDesc(0, "gencnt", "generation already known by client").paramDesc(1, "timeout", "How many milliseconds to wait for changesbefore returning if nothing has changed (max=10000)").returnDesc(0, "oldgen", "diff from generation already known by client").returnDesc(1, "removed", "Array of RpcServer names to remove").returnDesc(2, "names", "Array of RpcServer names with new values").returnDesc(3, "specs", "Array of connection specifications (same order)").returnDesc(4, "newgen", "Generation count for new version of the map"));
    }

    private void rpc_register(Request req) {
        String name = req.parameters().get(0).asString();
        String spec = req.parameters().get(1).asString();
        String stored = this.services.get(name);
        if (stored == null) {
            new RegisterCallback(req, name, spec);
        } else if (!stored.equals(spec)) {
            req.setError(111, "service '" + name + "' registered with another spec");
        }
    }

    private void rpc_unregister(Request req) {
        String name = req.parameters().get(0).asString();
        String spec = req.parameters().get(1).asString();
        String stored = this.services.get(name);
        if (stored != null) {
            if (stored.equals(spec)) {
                Target target = this.targets.remove(name);
                target.removeWatcher(this.monitor);
                this.services.remove(name);
                target.close();
                this.updated();
            } else {
                req.setError(111, "service '" + name + "' registered with another spec");
            }
        }
    }

    private void rpc_fetchIncremental(Request req) {
        int gencnt = req.parameters().get(0).asInt32();
        int timeout = req.parameters().get(1).asInt32();
        req.returnValues().add(new Int32Value(0));
        req.returnValues().add(new StringArray(new String[0]));
        if (gencnt == this.gencnt) {
            this.pendingFetch.add(new FetchMirror(req, timeout));
        } else {
            this.dumpServices(req);
        }
    }

    private class TargetMonitor
    implements TargetWatcher {
        private TargetMonitor() {
        }

        @Override
        public void notifyTargetInvalid(Target target) {
            Slobrok.this.handleTargetDown(target);
        }
    }

    private class FetchMirror
    implements Runnable {
        public final Request req;
        public final Task task;

        public FetchMirror(Request req, int timeout) {
            req.detach();
            this.req = req;
            this.task = Slobrok.this.orb.transport().selectThread().createTask(this);
            this.task.schedule((double)timeout / 1000.0);
        }

        @Override
        public void run() {
            Slobrok.this.handleFetchMirrorTimeout(this);
        }
    }

    private class RegisterCallback
    implements RequestWaiter {
        Request registerReq;
        String name;
        String spec;
        Target target;

        public RegisterCallback(Request req, String name, String spec) {
            req.detach();
            this.registerReq = req;
            this.name = name;
            this.spec = spec;
            this.target = Slobrok.this.orb.connect(new Spec(spec));
            Request cbReq = new Request("slobrok.callback.listNamesServed");
            this.target.invokeAsync(cbReq, Duration.ofSeconds(5L), (RequestWaiter)this);
        }

        @Override
        public void handleRequestDone(Request req) {
            if (!req.checkReturnTypes("S")) {
                this.registerReq.setError(111, "error during register callback: " + req.errorMessage());
                this.registerReq.returnRequest();
                this.target.close();
                return;
            }
            String[] names = req.returnValues().get(0).asStringArray();
            boolean found = false;
            for (String n : names) {
                if (!n.equals(this.name)) continue;
                found = true;
            }
            if (!found) {
                this.registerReq.setError(111, "register failed: served names does not contain name");
                this.registerReq.returnRequest();
                this.target.close();
                return;
            }
            Slobrok.this.handleRegisterCallbackDone(this.registerReq, this.name, this.spec, this.target);
        }
    }
}

