/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jrt;

import com.yahoo.jrt.Packet;
import com.yahoo.jrt.StringValue;
import java.nio.ByteBuffer;

class ErrorPacket
extends Packet {
    private int errorCode;
    private StringValue errorMessage;

    public ErrorPacket(int flags, int reqId, int errorCode, String errorMessage) {
        super(flags, reqId);
        this.errorCode = errorCode;
        this.errorMessage = new StringValue(errorMessage);
    }

    public ErrorPacket(int flags, int reqId, ByteBuffer src) {
        super(flags, reqId);
        this.errorCode = src.getInt();
        this.errorMessage = new StringValue(src);
    }

    @Override
    public int bytes() {
        return 16 + this.errorMessage.bytes();
    }

    @Override
    public int packetCode() {
        return 102;
    }

    @Override
    public void encode(ByteBuffer dst) {
        dst.putInt(this.errorCode);
        this.errorMessage.encode(dst);
    }

    public int errorCode() {
        return this.errorCode;
    }

    public String errorMessage() {
        return this.errorMessage.asString();
    }
}

