/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage;

import com.yahoo.vespa.indexinglanguage.ExpressionConverter;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.StatementExpression;

public abstract class ValueTransformProvider
extends ExpressionConverter {
    private final Class<? extends Expression> transformClass;
    private boolean transformed = false;
    private boolean duplicate = false;

    public ValueTransformProvider(Class<? extends Expression> transformClass) {
        this.transformClass = transformClass;
    }

    @Override
    public final ExpressionConverter branch() {
        return this.clone();
    }

    @Override
    protected final boolean shouldConvert(Expression expression) {
        if (this.transformClass.isInstance((Object)expression)) {
            if (this.transformed) {
                this.duplicate = true;
                return true;
            }
            this.transformed = true;
            return false;
        }
        if (!this.requiresTransform(expression)) {
            return false;
        }
        return !this.transformed;
    }

    @Override
    protected final Expression doConvert(Expression exp) {
        if (this.duplicate) {
            this.duplicate = false;
            return null;
        }
        this.transformed = true;
        return new StatementExpression(this.newTransform(), exp);
    }

    protected abstract boolean requiresTransform(Expression var1);

    protected abstract Expression newTransform();
}

