/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.json.readers;

import com.fasterxml.jackson.core.JsonToken;
import com.google.common.base.Preconditions;
import com.yahoo.document.Document;
import com.yahoo.document.DocumentOperation;
import com.yahoo.document.DocumentPut;
import com.yahoo.document.DocumentRemove;
import com.yahoo.document.DocumentType;
import com.yahoo.document.DocumentUpdate;
import com.yahoo.document.Field;
import com.yahoo.document.datatypes.Array;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.fieldpathupdate.AddFieldPathUpdate;
import com.yahoo.document.fieldpathupdate.AssignFieldPathUpdate;
import com.yahoo.document.fieldpathupdate.FieldPathUpdate;
import com.yahoo.document.fieldpathupdate.RemoveFieldPathUpdate;
import com.yahoo.document.json.JsonReaderException;
import com.yahoo.document.json.ParsedDocumentOperation;
import com.yahoo.document.json.TokenBuffer;
import com.yahoo.document.json.readers.AddRemoveCreator;
import com.yahoo.document.json.readers.CompositeReader;
import com.yahoo.document.json.readers.DocumentParseInfo;
import com.yahoo.document.json.readers.JsonParserHelpers;
import com.yahoo.document.json.readers.MapReader;
import com.yahoo.document.json.readers.SingleValueReader;
import com.yahoo.document.json.readers.TensorAddUpdateReader;
import com.yahoo.document.json.readers.TensorModifyUpdateReader;
import com.yahoo.document.json.readers.TensorRemoveUpdateReader;
import com.yahoo.document.update.FieldUpdate;

public class VespaJsonDocumentReader {
    private static final String UPDATE_REMOVE = "remove";
    private static final String UPDATE_ADD = "add";
    private final boolean ignoreUndefinedFields;

    public VespaJsonDocumentReader(boolean ignoreUndefinedFields) {
        this.ignoreUndefinedFields = ignoreUndefinedFields;
    }

    public ParsedDocumentOperation createDocumentOperation(DocumentType documentType, DocumentParseInfo documentParseInfo) {
        DocumentOperation documentOperation;
        boolean fullyApplied = true;
        try {
            switch (documentParseInfo.operationType) {
                case PUT: {
                    documentOperation = new DocumentPut(new Document(documentType, documentParseInfo.documentId));
                    fullyApplied = this.readPut(documentParseInfo.fieldsBuffer, (DocumentPut)documentOperation);
                    VespaJsonDocumentReader.verifyEndState(documentParseInfo.fieldsBuffer, JsonToken.END_OBJECT);
                    break;
                }
                case REMOVE: {
                    documentOperation = new DocumentRemove(documentParseInfo.documentId);
                    break;
                }
                case UPDATE: {
                    documentOperation = new DocumentUpdate(documentType, documentParseInfo.documentId);
                    fullyApplied = this.readUpdate(documentParseInfo.fieldsBuffer, (DocumentUpdate)documentOperation);
                    VespaJsonDocumentReader.verifyEndState(documentParseInfo.fieldsBuffer, JsonToken.END_OBJECT);
                    break;
                }
                default: {
                    throw new IllegalStateException("Implementation out of sync with itself. This is a bug.");
                }
            }
        }
        catch (JsonReaderException e) {
            throw JsonReaderException.addDocId(e, documentParseInfo.documentId);
        }
        if (documentParseInfo.create.isPresent()) {
            if (documentOperation instanceof DocumentUpdate) {
                DocumentUpdate update = (DocumentUpdate)documentOperation;
                update.setCreateIfNonExistent(documentParseInfo.create.get());
            } else if (documentOperation instanceof DocumentPut) {
                DocumentPut put = (DocumentPut)documentOperation;
                put.setCreateIfNonExistent(documentParseInfo.create.get());
            } else {
                throw new IllegalArgumentException("Could not set create flag on operation.");
            }
        }
        return new ParsedDocumentOperation(documentOperation, fullyApplied);
    }

    public boolean readPut(TokenBuffer buffer, DocumentPut put) {
        try {
            if (buffer.isEmpty()) {
                throw new IllegalArgumentException(String.valueOf(put) + " is missing a 'fields' map");
            }
            return CompositeReader.populateComposite(buffer, put.getDocument(), this.ignoreUndefinedFields);
        }
        catch (JsonReaderException e) {
            throw JsonReaderException.addDocId(e, put.getId());
        }
    }

    public boolean readUpdate(TokenBuffer buffer, DocumentUpdate update) {
        if (buffer.isEmpty()) {
            throw new IllegalArgumentException("Update of document " + String.valueOf((Object)update.getId()) + " is missing a 'fields' map");
        }
        JsonParserHelpers.expectObjectStart(buffer.current());
        int localNesting = buffer.nesting();
        buffer.next();
        boolean fullyApplied = true;
        while (localNesting <= buffer.nesting()) {
            JsonParserHelpers.expectObjectStart(buffer.current());
            String fieldName = buffer.currentName();
            try {
                fullyApplied = VespaJsonDocumentReader.isFieldPath(fieldName) ? (fullyApplied &= this.addFieldPathUpdates(update, buffer, fieldName)) : (fullyApplied &= this.addFieldUpdates(update, buffer, fieldName));
                JsonParserHelpers.expectObjectEnd(buffer.current());
            }
            catch (IllegalArgumentException | IndexOutOfBoundsException e) {
                throw new IllegalArgumentException("Error in '" + fieldName + "'", e);
            }
            buffer.next();
        }
        return fullyApplied;
    }

    private boolean addFieldUpdates(DocumentUpdate update, TokenBuffer buffer, String fieldName) {
        Field field = update.getType().getField(fieldName);
        if (field == null) {
            if (!this.ignoreUndefinedFields) {
                throw new IllegalArgumentException("No field named '" + fieldName + "' in " + String.valueOf(update.getType()));
            }
            buffer.skipToRelativeNesting(-1);
            return false;
        }
        int localNesting = buffer.nesting();
        FieldUpdate fieldUpdate = FieldUpdate.create(field);
        buffer.next();
        while (localNesting <= buffer.nesting()) {
            switch (buffer.currentName()) {
                case "remove": {
                    if (TensorAddUpdateReader.isTensorField(field)) {
                        fieldUpdate.addValueUpdate(TensorRemoveUpdateReader.createTensorRemoveUpdate(buffer, field));
                        break;
                    }
                    AddRemoveCreator.createRemoves(buffer, field, fieldUpdate, this.ignoreUndefinedFields);
                    break;
                }
                case "add": {
                    if (TensorAddUpdateReader.isTensorField(field)) {
                        fieldUpdate.addValueUpdate(TensorAddUpdateReader.createTensorAddUpdate(buffer, field));
                        break;
                    }
                    AddRemoveCreator.createAdds(buffer, field, fieldUpdate, this.ignoreUndefinedFields);
                    break;
                }
                case "match": {
                    fieldUpdate.addValueUpdate(MapReader.createMapUpdate(buffer, field, this.ignoreUndefinedFields));
                    break;
                }
                case "modify": {
                    fieldUpdate.addValueUpdate(TensorModifyUpdateReader.createModifyUpdate(buffer, field));
                    break;
                }
                default: {
                    String action = buffer.currentName();
                    fieldUpdate.addValueUpdate(SingleValueReader.readSingleUpdate(buffer, field.getDataType(), action, this.ignoreUndefinedFields));
                }
            }
            buffer.next();
        }
        update.addFieldUpdate(fieldUpdate);
        return true;
    }

    private boolean addFieldPathUpdates(DocumentUpdate update, TokenBuffer buffer, String fieldPath) {
        int localNesting = buffer.nesting();
        buffer.next();
        while (localNesting <= buffer.nesting()) {
            FieldPathUpdate fieldPathUpdate;
            String fieldPathOperation = buffer.currentName().toLowerCase();
            if (fieldPathOperation.equals("assign")) {
                fieldPathUpdate = this.readAssignFieldPathUpdate(update.getType(), fieldPath, buffer);
            } else if (fieldPathOperation.equals(UPDATE_ADD)) {
                fieldPathUpdate = this.readAddFieldPathUpdate(update.getType(), fieldPath, buffer);
            } else if (fieldPathOperation.equals(UPDATE_REMOVE)) {
                fieldPathUpdate = this.readRemoveFieldPathUpdate(update.getType(), fieldPath, buffer);
            } else if (SingleValueReader.UPDATE_OPERATION_TO_ARITHMETIC_SIGN.containsKey(fieldPathOperation)) {
                fieldPathUpdate = this.readArithmeticFieldPathUpdate(update.getType(), fieldPath, buffer, fieldPathOperation);
            } else {
                throw new IllegalArgumentException("Field path update type '" + fieldPathOperation + "' not supported.");
            }
            update.addFieldPathUpdate(fieldPathUpdate);
            buffer.next();
        }
        return true;
    }

    private AssignFieldPathUpdate readAssignFieldPathUpdate(DocumentType documentType, String fieldPath, TokenBuffer buffer) {
        AssignFieldPathUpdate fieldPathUpdate = new AssignFieldPathUpdate(documentType, fieldPath);
        FieldValue fv = SingleValueReader.readSingleValue(buffer, fieldPathUpdate.getFieldPath().getResultingDataType(), this.ignoreUndefinedFields);
        fieldPathUpdate.setNewValue(fv);
        return fieldPathUpdate;
    }

    private AddFieldPathUpdate readAddFieldPathUpdate(DocumentType documentType, String fieldPath, TokenBuffer buffer) {
        AddFieldPathUpdate fieldPathUpdate = new AddFieldPathUpdate(documentType, fieldPath);
        FieldValue fv = SingleValueReader.readSingleValue(buffer, fieldPathUpdate.getFieldPath().getResultingDataType(), this.ignoreUndefinedFields);
        fieldPathUpdate.setNewValues((Array)fv);
        return fieldPathUpdate;
    }

    private RemoveFieldPathUpdate readRemoveFieldPathUpdate(DocumentType documentType, String fieldPath, TokenBuffer buffer) {
        JsonParserHelpers.expectScalarValue(buffer.current());
        return new RemoveFieldPathUpdate(documentType, fieldPath);
    }

    private AssignFieldPathUpdate readArithmeticFieldPathUpdate(DocumentType documentType, String fieldPath, TokenBuffer buffer, String fieldPathOperation) {
        AssignFieldPathUpdate fieldPathUpdate = new AssignFieldPathUpdate(documentType, fieldPath);
        String arithmeticSign = SingleValueReader.UPDATE_OPERATION_TO_ARITHMETIC_SIGN.get(fieldPathOperation);
        double value = Double.parseDouble(buffer.currentText());
        String expression = String.format("$value %s %s", arithmeticSign, value);
        fieldPathUpdate.setExpression(expression);
        return fieldPathUpdate;
    }

    private static boolean isFieldPath(String field) {
        return field.matches("^.*?[.\\[{].*$");
    }

    private static void verifyEndState(TokenBuffer buffer, JsonToken expectedFinalToken) {
        Preconditions.checkState((buffer.current() == expectedFinalToken ? 1 : 0) != 0, (String)"Expected end of JSON struct (%s), got %s", (Object)expectedFinalToken, (Object)buffer.current());
        Preconditions.checkState((buffer.nesting() == 0 ? 1 : 0) != 0, (Object)"Nesting not zero at end of operation");
        Preconditions.checkState((buffer.next() == null ? 1 : 0) != 0, (Object)"Dangling data at end of operation");
        Preconditions.checkState((boolean)buffer.isEmpty(), (Object)"Dangling data at end of operation");
    }
}

