/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespaxmlparser;

import com.yahoo.document.DocumentTypeManager;
import com.yahoo.document.serialization.DeserializationException;
import java.io.FileInputStream;
import java.io.InputStream;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class VespaXMLReader {
    DocumentTypeManager docTypeManager;
    XMLStreamReader reader;

    public VespaXMLReader(String fileName, DocumentTypeManager docTypeManager) throws Exception {
        this(new FileInputStream(fileName), docTypeManager);
    }

    public VespaXMLReader(InputStream stream, DocumentTypeManager docTypeManager) throws Exception {
        this.docTypeManager = docTypeManager;
        XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
        xmlInputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
        this.reader = xmlInputFactory.createXMLStreamReader(stream);
    }

    public VespaXMLReader(XMLStreamReader reader, DocumentTypeManager docTypeManager) {
        this.docTypeManager = docTypeManager;
        this.reader = reader;
    }

    protected RuntimeException newDeserializeException(String message) {
        return new DeserializationException(message + " (at line " + this.reader.getLocation().getLineNumber() + ", column " + this.reader.getLocation().getColumnNumber() + ")");
    }

    protected RuntimeException newException(Exception e) {
        return new DeserializationException(e.getMessage() + " (at line " + this.reader.getLocation().getLineNumber() + ", column " + this.reader.getLocation().getColumnNumber() + ")", e);
    }

    protected void skipToEnd(String tagName) throws XMLStreamException {
        while (this.reader.hasNext()) {
            if (this.reader.getEventType() == 2 && tagName.equals(this.reader.getName().toString())) {
                return;
            }
            this.reader.next();
        }
        throw new DeserializationException("Missing end tag for element '" + tagName + "'" + String.valueOf(this.reader.getLocation()));
    }

    public static boolean isBase64EncodingAttribute(String attributeName, String attributeValue) {
        return "binaryencoding".equals(attributeName) && "base64".equalsIgnoreCase(attributeValue);
    }

    public static boolean isBase64EncodedElement(XMLStreamReader reader) {
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            if (!VespaXMLReader.isBase64EncodingAttribute(reader.getAttributeName(i).toString(), reader.getAttributeValue(i))) continue;
            return true;
        }
        return false;
    }
}

