/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.datatypes;

import com.yahoo.document.DataType;
import com.yahoo.document.Field;
import com.yahoo.document.FieldPath;
import com.yahoo.document.MapDataType;
import com.yahoo.document.datatypes.CompositeFieldValue;
import com.yahoo.document.datatypes.FieldPathIteratorHandler;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.serialization.FieldReader;
import com.yahoo.document.serialization.FieldWriter;
import com.yahoo.document.serialization.XmlSerializationHelper;
import com.yahoo.document.serialization.XmlStream;
import com.yahoo.vespa.objects.FieldBase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MapFieldValue<K extends FieldValue, V extends FieldValue>
extends CompositeFieldValue
implements Map<K, V> {
    private Map<K, V> values;

    public MapFieldValue(MapDataType type) {
        this(type, 1);
    }

    public MapFieldValue(MapDataType type, int initialCapacity) {
        super(type);
        this.values = new HashMap(initialCapacity);
    }

    @Override
    public MapDataType getDataType() {
        return (MapDataType)super.getDataType();
    }

    @Override
    public void assign(Object o) {
        if (!this.checkAssign(o)) {
            return;
        }
        if (o instanceof MapFieldValue) {
            MapFieldValue a = (MapFieldValue)o;
            if (o == this) {
                return;
            }
            this.values.clear();
            this.putAll(a);
        } else if (o instanceof Map) {
            this.values = new MapWrapper((Map)o);
        } else {
            throw new IllegalArgumentException("Class " + String.valueOf(o.getClass()) + " not applicable to an " + String.valueOf(this.getClass()) + " instance.");
        }
    }

    @Override
    public MapFieldValue clone() {
        MapFieldValue copy = (MapFieldValue)super.clone();
        copy.values = new HashMap(this.values.size());
        for (Map.Entry<K, V> entry : this.values.entrySet()) {
            copy.values.put(((FieldValue)entry.getKey()).clone(), ((FieldValue)entry.getValue()).clone());
        }
        return copy;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof MapFieldValue)) {
            return false;
        }
        MapFieldValue m = (MapFieldValue)o;
        if (this.size() != m.size()) {
            return false;
        }
        if (!super.equals(m)) {
            return false;
        }
        return this.entrySet().equals(m.entrySet());
    }

    @Override
    public void clear() {
        this.values.clear();
    }

    @Override
    public void deserialize(Field field, FieldReader reader) {
        reader.read((FieldBase)field, this);
    }

    @Override
    @Deprecated
    public void printXml(XmlStream xml) {
        XmlSerializationHelper.printMapXml(this, xml);
    }

    @Override
    public void serialize(Field field, FieldWriter writer) {
        writer.write((FieldBase)field, this);
    }

    @Override
    public Object getWrappedValue() {
        if (this.values instanceof MapWrapper) {
            return ((MapWrapper)this.values).map;
        }
        HashMap<Object, Object> tmpMap = new HashMap<Object, Object>();
        for (Map.Entry<K, V> kvEntry : this.values.entrySet()) {
            tmpMap.put(((FieldValue)kvEntry.getKey()).getWrappedValue(), ((FieldValue)kvEntry.getValue()).getWrappedValue());
        }
        return tmpMap;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.values.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.values.containsValue(value);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.values.entrySet();
    }

    @Override
    public V get(Object key) {
        return (V)((FieldValue)this.values.get(key));
    }

    @Override
    public Set<K> keySet() {
        return this.values.keySet();
    }

    private void validateCompatibleTypes(DataType d, FieldValue v) {
        if (!d.isValueCompatible(v)) {
            throw new IllegalArgumentException("Incompatible data types. Got " + String.valueOf(v.getDataType()) + ", expected " + String.valueOf(d));
        }
    }

    @Override
    public V put(K key, V value) {
        this.validateCompatibleTypes(this.getDataType().getKeyType(), (FieldValue)key);
        this.validateCompatibleTypes(this.getDataType().getValueType(), (FieldValue)value);
        return (V)((FieldValue)this.values.put(key, value));
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (FieldValue key : m.keySet()) {
            this.validateCompatibleTypes(this.getDataType().getKeyType(), key);
        }
        for (FieldValue value : m.values()) {
            this.validateCompatibleTypes(this.getDataType().getValueType(), value);
        }
        this.values.putAll(m);
    }

    @Override
    public V remove(Object key) {
        return (V)((FieldValue)this.values.remove(key));
    }

    @Override
    public Collection<V> values() {
        return this.values.values();
    }

    public boolean contains(Object o) {
        return this.values.containsKey(o);
    }

    @Override
    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    @Override
    public int size() {
        return this.values.size();
    }

    boolean checkAndRemove(FieldValue key, FieldPathIteratorHandler.ModificationStatus status, boolean wasModified, List<FieldValue> keysToRemove) {
        if (status == FieldPathIteratorHandler.ModificationStatus.REMOVED) {
            keysToRemove.add(key);
            return true;
        }
        if (status == FieldPathIteratorHandler.ModificationStatus.MODIFIED) {
            return true;
        }
        return wasModified;
    }

    /*
     * Enabled aggressive block sorting
     */
    FieldPathIteratorHandler.ModificationStatus iterateNested(FieldPath fieldPath, int pos, FieldPathIteratorHandler handler, FieldValue complexFieldValue) {
        FieldPathIteratorHandler.ModificationStatus modificationStatus;
        boolean wasModified;
        ArrayList<FieldValue> keysToRemove;
        block22: {
            block23: {
                keysToRemove = new ArrayList<FieldValue>();
                wasModified = false;
                if (pos >= fieldPath.size()) break block23;
                block0 : switch (fieldPath.get(pos).getType()) {
                    case MAP_KEY: {
                        FieldPathIteratorHandler.ModificationStatus modificationStatus2;
                        Object val = (FieldValue)this.values.get(fieldPath.get(pos).getLookupKey());
                        if (val != null) {
                            wasModified = this.checkAndRemove(fieldPath.get(pos).getLookupKey(), ((FieldValue)val).iterateNested(fieldPath, pos + 1, handler), wasModified, keysToRemove);
                            break block22;
                        } else if (handler.createMissingPath() && (modificationStatus2 = ((FieldValue)(val = this.getDataType().getValueType().createFieldValue())).iterateNested(fieldPath, pos + 1, handler)) == FieldPathIteratorHandler.ModificationStatus.MODIFIED) {
                            this.put((K)fieldPath.get(pos).getLookupKey(), (V)val);
                            return modificationStatus2;
                        }
                        break block22;
                    }
                    case MAP_ALL_KEYS: {
                        for (FieldValue fieldValue : this.values.keySet()) {
                            wasModified = this.checkAndRemove(fieldValue, fieldValue.iterateNested(fieldPath, pos + 1, handler), wasModified, keysToRemove);
                        }
                        break block22;
                    }
                    case MAP_ALL_VALUES: {
                        for (Map.Entry entry : this.values.entrySet()) {
                            wasModified = this.checkAndRemove((FieldValue)entry.getKey(), ((FieldValue)entry.getValue()).iterateNested(fieldPath, pos + 1, handler), wasModified, keysToRemove);
                        }
                        break block22;
                    }
                    case VARIABLE: {
                        Object idx = (FieldPathIteratorHandler.IndexValue)handler.getVariables().get(fieldPath.get(pos).getVariableName());
                        if (idx != null) {
                            FieldValue fieldValue = (FieldValue)this.values.get(((FieldPathIteratorHandler.IndexValue)idx).getKey());
                            if (fieldValue != null) {
                                wasModified = this.checkAndRemove(((FieldPathIteratorHandler.IndexValue)idx).getKey(), fieldValue.iterateNested(fieldPath, pos + 1, handler), wasModified, keysToRemove);
                            }
                            break block22;
                        } else {
                            for (Map.Entry<K, V> entry : this.values.entrySet()) {
                                handler.getVariables().put(fieldPath.get(pos).getVariableName(), new FieldPathIteratorHandler.IndexValue((FieldValue)entry.getKey()));
                                wasModified = this.checkAndRemove((FieldValue)entry.getKey(), ((FieldValue)entry.getValue()).iterateNested(fieldPath, pos + 1, handler), wasModified, keysToRemove);
                            }
                            handler.getVariables().remove(fieldPath.get(pos).getVariableName());
                        }
                        break block22;
                    }
                    default: {
                        Object idx = this.values.entrySet().iterator();
                        while (idx.hasNext()) {
                            Map.Entry entry = (Map.Entry)idx.next();
                            wasModified = this.checkAndRemove((FieldValue)entry.getKey(), ((FieldValue)entry.getKey()).iterateNested(fieldPath, pos, handler), wasModified, keysToRemove);
                            break block0;
                        }
                        break block22;
                    }
                }
                {
                    continue;
                    break;
                }
            }
            FieldPathIteratorHandler.ModificationStatus status = handler.modify(complexFieldValue);
            if (status == FieldPathIteratorHandler.ModificationStatus.REMOVED) {
                return status;
            }
            if (status == FieldPathIteratorHandler.ModificationStatus.MODIFIED) {
                wasModified = true;
            }
            if (handler.onComplex(complexFieldValue)) {
                for (Map.Entry<K, V> entry : this.values.entrySet()) {
                    wasModified = this.checkAndRemove((FieldValue)entry.getKey(), ((FieldValue)entry.getKey()).iterateNested(fieldPath, pos, handler), wasModified, keysToRemove);
                }
            }
        }
        for (FieldValue fieldValue : keysToRemove) {
            this.values.remove(fieldValue);
        }
        if (wasModified) {
            modificationStatus = FieldPathIteratorHandler.ModificationStatus.MODIFIED;
            return modificationStatus;
        }
        modificationStatus = FieldPathIteratorHandler.ModificationStatus.NOT_MODIFIED;
        return modificationStatus;
    }

    @Override
    FieldPathIteratorHandler.ModificationStatus iterateNested(FieldPath fieldPath, int pos, FieldPathIteratorHandler handler) {
        return this.iterateNested(fieldPath, pos, handler, this);
    }

    @Override
    public int compareTo(FieldValue fieldValue) {
        int comp = super.compareTo(fieldValue);
        if (comp != 0) {
            return comp;
        }
        MapFieldValue rhs = (MapFieldValue)fieldValue;
        if (this.size() < rhs.size()) {
            return -1;
        }
        if (this.size() > rhs.size()) {
            return 1;
        }
        Map.Entry[] entries = this.entrySet().toArray(new Map.Entry[this.size()]);
        Map.Entry[] rhsEntries = rhs.entrySet().toArray(new Map.Entry[rhs.size()]);
        Arrays.sort(entries, Comparator.comparing(Map.Entry::getKey));
        Arrays.sort(rhsEntries, Comparator.comparing(Map.Entry::getKey));
        for (int i = 0; i < entries.length; ++i) {
            comp = ((FieldValue)entries[i].getKey()).compareTo((FieldValue)rhsEntries[i].getKey());
            if (comp != 0) {
                return comp;
            }
            comp = ((FieldValue)entries[i].getValue()).compareTo((FieldValue)rhsEntries[i].getValue());
            if (comp == 0) continue;
            return comp;
        }
        return 0;
    }

    class MapWrapper
    implements Map<K, V> {
        private final Map<Object, Object> map;
        private final DataType keyTypeVespa;
        private final DataType valTypeVespa;

        public MapWrapper(Map map) {
            this.keyTypeVespa = MapFieldValue.this.getDataType().getKeyType();
            this.valTypeVespa = MapFieldValue.this.getDataType().getValueType();
            this.map = map;
        }

        private Object unwrap(Object o) {
            return o instanceof FieldValue ? ((FieldValue)o).getWrappedValue() : o;
        }

        private K wrapKey(Object o) {
            if (o == null) {
                return null;
            }
            return this.keyTypeVespa.createFieldValue(o);
        }

        private V wrapValue(Object o) {
            if (o == null) {
                return null;
            }
            return this.valTypeVespa.createFieldValue(o);
        }

        @Override
        public void clear() {
            this.map.clear();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.map.containsKey(this.unwrap(key));
        }

        @Override
        public boolean containsValue(Object value) {
            return this.map.containsValue(this.unwrap(value));
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            HashMap ret = new HashMap();
            for (Map.Entry<Object, Object> e : this.map.entrySet()) {
                ret.put(this.wrapKey(e.getKey()), this.wrapValue(e.getValue()));
            }
            return ret.entrySet();
        }

        @Override
        public V get(Object key) {
            Object o = this.map.get(this.unwrap(key));
            return o == null ? null : (Object)this.wrapValue(o);
        }

        @Override
        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        @Override
        public Set<K> keySet() {
            HashSet ret = new HashSet();
            for (Map.Entry<Object, Object> e : this.map.entrySet()) {
                ret.add(this.wrapKey(e.getKey()));
            }
            return ret;
        }

        @Override
        public V put(K key, V value) {
            Object old = this.get(key);
            this.map.put(this.unwrap(key), this.unwrap(value));
            return old;
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> m) {
            for (Map.Entry e : m.entrySet()) {
                this.map.put(this.unwrap(e.getKey()), this.unwrap(e.getValue()));
            }
        }

        @Override
        public V remove(Object key) {
            return this.wrapValue(this.map.remove(this.unwrap(key)));
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public Collection<V> values() {
            ArrayList ret = new ArrayList();
            for (Object v : this.map.values()) {
                ret.add(this.wrapValue(v));
            }
            return ret;
        }
    }
}

