/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.rendering;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonFactoryBuilder;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.StreamReadConstraints;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.common.base.Preconditions;
import com.yahoo.container.logging.TraceRenderer;
import com.yahoo.data.JsonProducer;
import com.yahoo.data.access.Inspectable;
import com.yahoo.data.access.Inspector;
import com.yahoo.data.access.Type;
import com.yahoo.data.disclosure.DataSink;
import com.yahoo.data.disclosure.DataSource;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.StringFieldValue;
import com.yahoo.document.datatypes.TensorFieldValue;
import com.yahoo.document.json.JsonWriter;
import com.yahoo.document.serialization.FieldWriter;
import com.yahoo.json.Jackson;
import com.yahoo.lang.MutableBoolean;
import com.yahoo.processing.Response;
import com.yahoo.processing.execution.Execution;
import com.yahoo.processing.rendering.AsynchronousSectionedRenderer;
import com.yahoo.processing.request.CompoundName;
import com.yahoo.processing.response.Data;
import com.yahoo.processing.response.DataList;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.grouping.Continuation;
import com.yahoo.search.grouping.result.AbstractList;
import com.yahoo.search.grouping.result.BucketGroupId;
import com.yahoo.search.grouping.result.Group;
import com.yahoo.search.grouping.result.GroupId;
import com.yahoo.search.grouping.result.RootGroup;
import com.yahoo.search.grouping.result.ValueGroupId;
import com.yahoo.search.query.Properties;
import com.yahoo.search.rendering.JsonDataSource;
import com.yahoo.search.rendering.JsonGeneratorDataSink;
import com.yahoo.search.result.Coverage;
import com.yahoo.search.result.DefaultErrorHit;
import com.yahoo.search.result.ErrorHit;
import com.yahoo.search.result.ErrorMessage;
import com.yahoo.search.result.EventStream;
import com.yahoo.search.result.FeatureData;
import com.yahoo.search.result.Hit;
import com.yahoo.search.result.HitGroup;
import com.yahoo.search.result.NanNumber;
import com.yahoo.tensor.Tensor;
import com.yahoo.tensor.TensorDataSource;
import com.yahoo.tensor.TensorType;
import com.yahoo.tensor.serialization.JsonFormat;
import com.yahoo.yolean.trace.TraceVisitor;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.LongSupplier;

public class JsonRenderer
extends AsynchronousSectionedRenderer<Result> {
    private static final CompoundName RAW_AS_BASE64 = CompoundName.from((String)"renderer.json.rawAsBase64");
    private static final CompoundName WRAP_DEEP_MAPS = CompoundName.from((String)"renderer.json.jsonMaps");
    private static final CompoundName WRAP_WSETS = CompoundName.from((String)"renderer.json.jsonWsets");
    private static final CompoundName DEBUG_RENDERING_KEY = CompoundName.from((String)"renderer.json.debug");
    private static final CompoundName JSON_CALLBACK = CompoundName.from((String)"jsoncallback");
    private static final String BUCKET_LIMITS = "limits";
    private static final String BUCKET_TO = "to";
    private static final String BUCKET_FROM = "from";
    private static final String CHILDREN = "children";
    private static final String CONTINUATION = "continuation";
    private static final String COVERAGE = "coverage";
    private static final String COVERAGE_COVERAGE = "coverage";
    private static final String COVERAGE_DOCUMENTS = "documents";
    private static final String COVERAGE_DEGRADE = "degraded";
    private static final String COVERAGE_DEGRADE_MATCHPHASE = "match-phase";
    private static final String COVERAGE_DEGRADE_TIMEOUT = "timeout";
    private static final String COVERAGE_DEGRADE_ADAPTIVE_TIMEOUT = "adaptive-timeout";
    private static final String COVERAGE_DEGRADED_NON_IDEAL_STATE = "non-ideal-state";
    private static final String COVERAGE_FULL = "full";
    private static final String COVERAGE_NODES = "nodes";
    private static final String COVERAGE_RESULTS = "results";
    private static final String COVERAGE_RESULTS_FULL = "resultsFull";
    private static final String ERRORS = "errors";
    private static final String ERROR_CODE = "code";
    private static final String ERROR_MESSAGE = "message";
    private static final String ERROR_SOURCE = "source";
    private static final String ERROR_STACK_TRACE = "stackTrace";
    private static final String ERROR_SUMMARY = "summary";
    private static final String FIELDS = "fields";
    private static final String ID = "id";
    private static final String LABEL = "label";
    private static final String RELEVANCE = "relevance";
    private static final String ROOT = "root";
    private static final String SOURCE = "source";
    private static final String TOTAL_COUNT = "totalCount";
    private static final String TIMING = "timing";
    private static final String QUERY_TIME = "querytime";
    private static final String SUMMARY_FETCH_TIME = "summaryfetchtime";
    private static final String SEARCH_TIME = "searchtime";
    private static final String TYPES = "types";
    private static final String GROUPING_VALUE = "value";
    private static final String VESPA_HIDDEN_FIELD_PREFIX = "$";
    private static final JsonFactory generatorFactory = JsonRenderer.createGeneratorFactory();
    private volatile JsonGenerator generator;
    private volatile FieldConsumer fieldConsumer;
    private volatile Deque<Integer> renderedChildren;
    private volatile FieldConsumerSettings fieldConsumerSettings;
    private volatile LongSupplier timeSource;
    private volatile OutputStream stream;

    public JsonRenderer() {
        this(null);
    }

    public JsonRenderer(Executor executor) {
        super(executor);
    }

    private static JsonFactory createGeneratorFactory() {
        return Jackson.createMapper((JsonFactoryBuilder)((JsonFactoryBuilder)new JsonFactoryBuilder().streamReadConstraints(StreamReadConstraints.builder().maxStringLength(Integer.MAX_VALUE).build()))).disable(SerializationFeature.FLUSH_AFTER_WRITE_VALUE).getFactory();
    }

    public void init() {
        super.init();
        this.fieldConsumerSettings = new FieldConsumerSettings();
        this.fieldConsumerSettings.init();
        this.setGenerator(null, this.fieldConsumerSettings);
        this.renderedChildren = null;
        this.timeSource = System::currentTimeMillis;
        this.stream = null;
    }

    public void beginResponse(OutputStream stream) throws IOException {
        long renderingStartTimeMs = this.timeSource.getAsLong();
        this.beginJsonCallback(stream);
        this.fieldConsumerSettings.getSettings(this.getResult().getQuery());
        this.setGenerator(generatorFactory.createGenerator(stream, JsonEncoding.UTF8), this.fieldConsumerSettings);
        this.renderedChildren = new ArrayDeque<Integer>();
        this.generator.writeStartObject();
        this.renderTrace(this.getExecution().trace());
        this.renderTiming(renderingStartTimeMs);
        this.generator.writeFieldName(ROOT);
    }

    private void renderTiming(long renderingStartTimeMs) throws IOException {
        long startTimeMs;
        if (!this.getResult().getQuery().getPresentation().getTiming()) {
            return;
        }
        double milli = 0.001;
        this.generator.writeObjectFieldStart(TIMING);
        if (this.getResult().getElapsedTime().firstFill() != 0L) {
            long queryTimeMs = this.getResult().getElapsedTime().weightedSearchTime();
            long summaryFetchTimeMs = this.getResult().getElapsedTime().weightedFillTime();
            this.generator.writeNumberField(QUERY_TIME, (double)queryTimeMs * milli);
            this.generator.writeNumberField(SUMMARY_FETCH_TIME, (double)summaryFetchTimeMs * milli);
        }
        if ((startTimeMs = this.getResult().getElapsedTime().first()) != 0L) {
            long searchTime = renderingStartTimeMs - startTimeMs;
            this.generator.writeNumberField(SEARCH_TIME, (double)searchTime * milli);
        }
        this.generator.writeEndObject();
    }

    protected void renderTrace(Execution.Trace trace) throws IOException {
        if (!trace.traceNode().children().iterator().hasNext()) {
            return;
        }
        if (this.getResult().getQuery().getTrace().getLevel() == 0) {
            return;
        }
        try {
            long basetime = trace.traceNode().timestamp();
            if (basetime == 0L) {
                basetime = this.getResult().getElapsedTime().first();
            }
            trace.accept((TraceVisitor)new TraceRenderer(this.generator, (TraceRenderer.FieldConsumer)this.fieldConsumer, basetime));
        }
        catch (TraceRenderer.TraceRenderWrapper e) {
            throw new IOException(e);
        }
    }

    public void beginList(DataList<?> list) throws IOException {
        this.moreChildren();
        if (list instanceof HitGroup) {
            this.renderHitGroupHead((HitGroup)list);
        } else if (list instanceof EventStream) {
            this.renderHitGroupHead(new HitGroup("event_stream"));
        } else {
            throw new IllegalArgumentException("Expected subclass of com.yahoo.search.result.HitGroup, got " + String.valueOf(list.getClass()));
        }
    }

    protected void moreChildren() throws IOException {
        if (!this.renderedChildren.isEmpty()) {
            this.childrenArray();
        }
        this.renderedChildren.push(0);
    }

    private void childrenArray() throws IOException {
        if (this.renderedChildren.peek() == 0) {
            this.generator.writeArrayFieldStart(CHILDREN);
        }
        this.renderedChildren.push(this.renderedChildren.pop() + 1);
    }

    private void lessChildren() throws IOException {
        int lastRenderedChildren = this.renderedChildren.pop();
        if (lastRenderedChildren > 0) {
            this.generator.writeEndArray();
        }
    }

    protected void renderHitGroupHead(HitGroup hitGroup) throws IOException {
        ErrorHit errorHit;
        this.generator.writeStartObject();
        this.renderHitContents(hitGroup);
        if (this.getRecursionLevel() == 1) {
            this.renderCoverage();
        }
        if ((errorHit = hitGroup.getErrorHit()) != null) {
            this.renderErrors(errorHit.errors());
        }
    }

    protected void renderErrors(Set<ErrorMessage> errors) throws IOException {
        if (errors.isEmpty()) {
            return;
        }
        this.generator.writeArrayFieldStart(ERRORS);
        for (ErrorMessage e : errors) {
            JsonRenderer.renderError(this.generator, e);
        }
        this.generator.writeEndArray();
    }

    static void renderError(JsonGenerator generator, ErrorMessage error) throws IOException {
        String summary = error.getMessage();
        String source = error.getSource();
        Throwable cause = error.getCause();
        String message = error.getDetailedMessage();
        generator.writeStartObject();
        generator.writeNumberField(ERROR_CODE, error.getCode());
        generator.writeStringField(ERROR_SUMMARY, summary);
        if (source != null) {
            generator.writeStringField("source", source);
        }
        if (message != null) {
            generator.writeStringField(ERROR_MESSAGE, message);
        }
        if (cause != null && JsonRenderer.shouldRenderStacktraceOf(cause) && cause.getStackTrace().length > 0) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            cause.printStackTrace(printWriter);
            printWriter.close();
            generator.writeStringField(ERROR_STACK_TRACE, stringWriter.toString());
        }
        generator.writeEndObject();
    }

    static boolean shouldRenderStacktraceOf(Throwable cause) {
        return !(cause instanceof IllegalArgumentException);
    }

    protected void renderCoverage() throws IOException {
        Coverage c = this.getResult().getCoverage(false);
        if (c == null) {
            return;
        }
        this.generator.writeObjectFieldStart("coverage");
        this.generator.writeNumberField("coverage", c.getResultPercentage());
        this.generator.writeNumberField(COVERAGE_DOCUMENTS, c.getDocs());
        if (c.isDegraded()) {
            this.generator.writeObjectFieldStart(COVERAGE_DEGRADE);
            this.generator.writeBooleanField(COVERAGE_DEGRADE_MATCHPHASE, c.isDegradedByMatchPhase());
            this.generator.writeBooleanField(COVERAGE_DEGRADE_TIMEOUT, c.isDegradedByTimeout());
            this.generator.writeBooleanField(COVERAGE_DEGRADE_ADAPTIVE_TIMEOUT, c.isDegradedByAdapativeTimeout());
            this.generator.writeBooleanField(COVERAGE_DEGRADED_NON_IDEAL_STATE, c.isDegradedByNonIdealState());
            this.generator.writeEndObject();
        }
        this.generator.writeBooleanField(COVERAGE_FULL, c.getFull());
        this.generator.writeNumberField(COVERAGE_NODES, c.getNodes());
        this.generator.writeNumberField(COVERAGE_RESULTS, c.getResultSets());
        this.generator.writeNumberField(COVERAGE_RESULTS_FULL, c.getFullResultSets());
        this.generator.writeEndObject();
    }

    protected void renderHit(Hit hit) throws IOException {
        if (!this.shouldRender(hit)) {
            return;
        }
        this.childrenArray();
        this.generator.writeStartObject();
        this.renderHitContents(hit);
        this.generator.writeEndObject();
    }

    protected boolean shouldRender(Hit hit) {
        return !(hit instanceof DefaultErrorHit);
    }

    protected void renderHitContents(Hit hit) throws IOException {
        String source;
        String id = hit.getDisplayId();
        if (id != null) {
            this.generator.writeStringField(ID, id);
        }
        this.generator.writeNumberField(RELEVANCE, hit.getRelevance().getScore());
        if (!hit.types().isEmpty()) {
            this.generator.writeArrayFieldStart(TYPES);
            for (String t : hit.types()) {
                this.generator.writeString(t);
            }
            this.generator.writeEndArray();
        }
        if ((source = hit.getSource()) != null) {
            this.generator.writeStringField("source", hit.getSource());
        }
        this.renderSpecialCasesForGrouping(hit);
        this.renderAllFields(hit);
    }

    protected void renderAllFields(Hit hit) throws IOException {
        this.fieldConsumer.startHitFields();
        this.renderTotalHitCount(hit);
        this.renderStandardFields(hit);
        this.fieldConsumer.endHitFields();
    }

    private void renderStandardFields(Hit hit) {
        hit.forEachFieldAsRaw(this.fieldConsumer);
    }

    private void renderSpecialCasesForGrouping(Hit hit) throws IOException {
        if (hit instanceof AbstractList) {
            this.renderGroupingListSyntheticFields((AbstractList)hit);
        } else if (hit instanceof Group) {
            this.renderGroupingGroupSyntheticFields(hit);
        }
    }

    private void renderGroupingGroupSyntheticFields(Hit hit) throws IOException {
        this.renderGroupMetadata(((Group)hit).getGroupId());
        if (hit instanceof RootGroup) {
            this.renderContinuations(Map.of("this", ((RootGroup)hit).continuation()));
        }
    }

    private void renderGroupingListSyntheticFields(AbstractList a) throws IOException {
        this.writeGroupingLabel(a);
        this.renderContinuations(a.continuations());
    }

    private void writeGroupingLabel(AbstractList a) throws IOException {
        this.generator.writeStringField(LABEL, a.getLabel());
    }

    protected void renderContinuations(Map<String, Continuation> continuations) throws IOException {
        if (continuations.isEmpty()) {
            return;
        }
        this.generator.writeObjectFieldStart(CONTINUATION);
        for (Map.Entry<String, Continuation> e : continuations.entrySet()) {
            this.generator.writeStringField(e.getKey(), e.getValue().toString());
        }
        this.generator.writeEndObject();
    }

    protected void renderGroupMetadata(GroupId id) throws IOException {
        if (!(id instanceof ValueGroupId) && !(id instanceof BucketGroupId)) {
            return;
        }
        if (id instanceof ValueGroupId) {
            ValueGroupId valueId = (ValueGroupId)id;
            this.generator.writeStringField(GROUPING_VALUE, valueId.getValue().toString());
        } else {
            BucketGroupId bucketId = (BucketGroupId)id;
            this.generator.writeObjectFieldStart(BUCKET_LIMITS);
            this.generator.writeStringField(BUCKET_FROM, bucketId.getFrom().toString());
            this.generator.writeStringField(BUCKET_TO, bucketId.getTo().toString());
            this.generator.writeEndObject();
        }
    }

    protected void renderTotalHitCount(Hit hit) throws IOException {
        if (this.getRecursionLevel() != 1 || !(hit instanceof HitGroup)) {
            return;
        }
        this.fieldConsumer.ensureFieldsField();
        this.generator.writeNumberField(TOTAL_COUNT, this.getResult().getTotalHitCount());
    }

    public void data(Data data) throws IOException {
        if (data instanceof Hit) {
            this.renderHit((Hit)data);
        } else if (data instanceof EventStream.Event) {
            this.renderHit(((EventStream.Event)data).asHit());
        } else {
            throw new IllegalArgumentException("Expected subclass of com.yahoo.search.result.Hit, got " + String.valueOf(data.getClass()));
        }
    }

    public void endList(DataList<?> list) throws IOException {
        this.lessChildren();
        this.generator.writeEndObject();
    }

    public void endResponse() throws IOException {
        this.generator.close();
        this.endJsonCallback();
    }

    public String getEncoding() {
        return "utf-8";
    }

    public String getMimeType() {
        return "application/json";
    }

    private Result getResult() {
        Response r = this.getResponse();
        Preconditions.checkArgument((boolean)(r instanceof Result), (String)"JsonRenderer can only render instances of com.yahoo.search.Result, got instance of %s.", r.getClass());
        return (Result)r;
    }

    private void beginJsonCallback(OutputStream stream) throws IOException {
        if (this.shouldRenderJsonCallback()) {
            String jsonCallback = this.getJsonCallback() + "(";
            stream.write(jsonCallback.getBytes(StandardCharsets.UTF_8));
            this.stream = stream;
        }
    }

    private void endJsonCallback() throws IOException {
        if (this.shouldRenderJsonCallback() && this.stream != null) {
            this.stream.write(");".getBytes(StandardCharsets.UTF_8));
        }
    }

    private boolean shouldRenderJsonCallback() {
        String jsonCallback = this.getJsonCallback();
        return jsonCallback != null && !jsonCallback.isEmpty();
    }

    private String getJsonCallback() {
        Result result = this.getResult();
        Query query = result.getQuery();
        if (query != null) {
            return query.properties().getString(JSON_CALLBACK, null);
        }
        return null;
    }

    private void setGenerator(JsonGenerator generator, FieldConsumerSettings settings) {
        this.generator = generator;
        this.fieldConsumer = generator == null ? null : this.createFieldConsumer(generator, settings);
    }

    protected FieldConsumer createFieldConsumer(boolean debugRendering) {
        this.fieldConsumerSettings.debugRendering = debugRendering;
        return this.createFieldConsumer(this.generator, this.fieldConsumerSettings);
    }

    private FieldConsumer createFieldConsumer(JsonGenerator generator, FieldConsumerSettings settings) {
        return new FieldConsumer(generator, settings);
    }

    void setTimeSource(LongSupplier timeSource) {
        this.timeSource = timeSource;
    }

    static class FieldConsumerSettings {
        volatile boolean debugRendering = false;
        volatile boolean jsonDeepMaps = true;
        volatile boolean jsonWsets = true;
        volatile boolean jsonMapsAll = true;
        volatile boolean jsonWsetsAll = false;
        volatile boolean enableRawAsBase64 = false;
        volatile JsonFormat.EncodeOptions tensorOptions;
        RenderTarget renderTarget;

        FieldConsumerSettings() {
        }

        boolean convertDeep() {
            return this.jsonDeepMaps || this.jsonWsets;
        }

        void init() {
            this.debugRendering = false;
            this.jsonDeepMaps = true;
            this.jsonWsets = true;
            this.jsonMapsAll = true;
            this.jsonWsetsAll = true;
            this.tensorOptions = new JsonFormat.EncodeOptions(true, false, false);
            this.renderTarget = RenderTarget.Json;
        }

        void getSettings(Query q) {
            if (q == null) {
                this.init();
                return;
            }
            Properties props = q.properties();
            this.debugRendering = props.getBoolean(DEBUG_RENDERING_KEY, false);
            this.jsonDeepMaps = props.getBoolean(WRAP_DEEP_MAPS, true);
            this.jsonWsets = props.getBoolean(WRAP_WSETS, true);
            this.enableRawAsBase64 = props.getBoolean(RAW_AS_BASE64, true);
            this.jsonMapsAll = props.getBoolean(WRAP_DEEP_MAPS, true);
            this.jsonWsetsAll = props.getBoolean(WRAP_WSETS, true);
            this.tensorOptions = new JsonFormat.EncodeOptions(q.getPresentation().getTensorShortForm(), q.getPresentation().getTensorDirectValues(), q.getPresentation().getTensorHexDense());
        }
    }

    public static class FieldConsumer
    implements Hit.RawUtf8Consumer,
    TraceRenderer.FieldConsumer {
        private final JsonGenerator generator;
        private final JsonGeneratorDataSink dataSink;
        private final FieldConsumerSettings settings;
        private MutableBoolean hasFieldsField;

        protected FieldConsumer(boolean debugRendering, boolean tensorShortForm, boolean jsonMaps) {
            this(null, debugRendering, new JsonFormat.EncodeOptions(tensorShortForm, false, false), jsonMaps);
        }

        private FieldConsumer(JsonGenerator generator, boolean debugRendering, JsonFormat.EncodeOptions tensorOptions, boolean jsonMaps) {
            this.generator = generator;
            this.settings = new FieldConsumerSettings();
            this.settings.debugRendering = debugRendering;
            this.settings.tensorOptions = tensorOptions;
            this.settings.jsonDeepMaps = jsonMaps;
            this.dataSink = generator == null ? null : new JsonGeneratorDataSink(generator, this.settings.enableRawAsBase64);
        }

        FieldConsumer(JsonGenerator generator, FieldConsumerSettings settings) {
            this.generator = generator;
            this.settings = settings;
            this.dataSink = generator == null ? null : new JsonGeneratorDataSink(generator, settings.enableRawAsBase64);
        }

        void startHitFields() {
            this.hasFieldsField = new MutableBoolean(false);
        }

        void ensureFieldsField() throws IOException {
            if (this.hasFieldsField.get()) {
                return;
            }
            this.generator().writeObjectFieldStart(JsonRenderer.FIELDS);
            this.hasFieldsField.set(true);
        }

        void endHitFields() throws IOException {
            if (!this.hasFieldsField.get()) {
                return;
            }
            this.generator().writeEndObject();
            this.hasFieldsField = null;
        }

        @Override
        public void accept(String name, Object value) {
            try {
                if (this.shouldRender(name, value)) {
                    this.ensureFieldsField();
                    this.generator().writeFieldName(name);
                    this.renderFieldContents(value);
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        @Override
        public void accept(String name, byte[] utf8Data, int offset, int length) {
            try {
                if (this.shouldRenderUtf8Value(name, length)) {
                    this.ensureFieldsField();
                    this.generator().writeFieldName(name);
                    this.generator().writeUTF8String(utf8Data, offset, length);
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        protected boolean shouldRender(String name, Object value) {
            if (this.settings.debugRendering) {
                return true;
            }
            if (name.startsWith(JsonRenderer.VESPA_HIDDEN_FIELD_PREFIX)) {
                return false;
            }
            if (value instanceof CharSequence && ((CharSequence)value).length() == 0) {
                return false;
            }
            if (value instanceof StringFieldValue && ((StringFieldValue)value).getString().isEmpty()) {
                return false;
            }
            return !(value instanceof NanNumber);
        }

        protected boolean shouldRenderUtf8Value(String name, int length) {
            if (this.settings.debugRendering) {
                return true;
            }
            if (name.startsWith(JsonRenderer.VESPA_HIDDEN_FIELD_PREFIX)) {
                return false;
            }
            return length != 0;
        }

        private boolean tryEmitAsMap(Inspector data) {
            int entries = data.entryCount();
            Inspector[] keys = new Inspector[entries];
            Inspector[] values = new Inspector[entries];
            for (int i = 0; i < entries; ++i) {
                Inspector obj = data.entry(i);
                if (obj.type() != Type.OBJECT || obj.fieldCount() != 2) {
                    return false;
                }
                Inspector key = obj.field("key");
                Inspector value = obj.field(JsonRenderer.GROUPING_VALUE);
                if (!key.valid() || !value.valid()) {
                    return false;
                }
                if (key.type() != Type.STRING && !this.settings.jsonMapsAll) {
                    return false;
                }
                keys[i] = key;
                values[i] = value;
            }
            boolean convertDeep = this.settings.convertDeep();
            this.dataSink().startObject();
            for (int i = 0; i < entries; ++i) {
                this.dataSink().fieldNameFromPrimitive(keys[i]);
                if (convertDeep) {
                    this.emitWithConversion(values[i]);
                    continue;
                }
                values[i].emit((DataSink)this.dataSink());
            }
            this.dataSink().endObject();
            return true;
        }

        private boolean tryEmitAsWset(Inspector data) {
            int i;
            int entries = data.entryCount();
            Inspector[] items = new Inspector[entries];
            long[] weights = new long[entries];
            for (i = 0; i < entries; ++i) {
                Inspector obj = data.entry(i);
                if (obj.type() != Type.OBJECT || obj.fieldCount() != 2) {
                    return false;
                }
                Inspector item = obj.field("item");
                Inspector weight = obj.field("weight");
                if (!item.valid() || !weight.valid()) {
                    return false;
                }
                if (weight.type() != Type.LONG) {
                    return false;
                }
                if (item.type() != Type.STRING && !this.settings.jsonWsetsAll) {
                    return false;
                }
                items[i] = item;
                weights[i] = weight.asLong();
            }
            this.dataSink().startObject();
            for (i = 0; i < entries; ++i) {
                this.dataSink().fieldNameFromPrimitive(items[i]);
                this.dataSink().longValue(weights[i]);
            }
            this.dataSink().endObject();
            return true;
        }

        private void emitObjectWithConversion(Inspector data) {
            this.dataSink().startObject();
            for (Map.Entry entry : data.fields()) {
                this.dataSink().fieldName((String)entry.getKey());
                this.emitWithConversion((Inspector)entry.getValue());
            }
            this.dataSink().endObject();
        }

        private void emitArrayWithConversion(Inspector data) {
            int entries = data.entryCount();
            this.dataSink().startArray();
            for (int i = 0; i < entries; ++i) {
                this.emitWithConversion(data.entry(i));
            }
            this.dataSink().endArray();
        }

        private void emitWithConversion(Inspector data) {
            if (data.type() == Type.ARRAY) {
                if (this.settings.jsonDeepMaps && this.tryEmitAsMap(data)) {
                    return;
                }
                if (this.settings.jsonWsets && this.tryEmitAsWset(data)) {
                    return;
                }
                if (this.settings.convertDeep()) {
                    this.emitArrayWithConversion(data);
                    return;
                }
            }
            if (data.type() == Type.OBJECT && this.settings.convertDeep()) {
                this.emitObjectWithConversion(data);
                return;
            }
            data.emit((DataSink)this.dataSink());
        }

        private void emitTopLevel(Inspector data) {
            if (data.type() == Type.ARRAY && data.entryCount() > 0) {
                if (this.tryEmitAsMap(data)) {
                    return;
                }
                if (this.settings.jsonWsets && this.tryEmitAsWset(data)) {
                    return;
                }
                if (this.settings.convertDeep()) {
                    this.emitArrayWithConversion(data);
                    return;
                }
            }
            if (this.settings.convertDeep() && data.type() == Type.OBJECT) {
                this.emitObjectWithConversion(data);
                return;
            }
            data.emit((DataSink)this.dataSink());
        }

        protected void renderFieldContents(Object field) throws IOException {
            if (field instanceof Inspectable && !(field instanceof FeatureData)) {
                this.emitTopLevel(((Inspectable)field).inspect());
            } else {
                this.accept(field);
            }
        }

        public void accept(Object field) throws IOException {
            if (field == null) {
                this.generator().writeNull();
            } else if (field instanceof Boolean) {
                Boolean bool = (Boolean)field;
                this.generator().writeBoolean(bool.booleanValue());
            } else if (field instanceof Number) {
                Number num = (Number)field;
                this.renderNumberField(num);
            } else if (field instanceof TreeNode) {
                TreeNode treenode = (TreeNode)field;
                this.generator().writeTree(treenode);
            } else if (field instanceof Tensor) {
                Tensor t = (Tensor)field;
                this.renderTensor(Optional.of(t));
            } else if (field instanceof FeatureData) {
                FeatureData featureData = (FeatureData)field;
                this.generator().writeRawValue(featureData.toJson(this.settings.tensorOptions));
            } else if (field instanceof Inspectable) {
                Inspectable i = (Inspectable)field;
                i.inspect().emit((DataSink)this.dataSink());
            } else if (field instanceof DataSource) {
                DataSource ds = (DataSource)field;
                ds.emit((DataSink)this.dataSink());
            } else if (field instanceof JsonProducer) {
                JsonProducer jp = (JsonProducer)field;
                this.emitJsonProducer(jp);
            } else if (field instanceof TensorFieldValue) {
                TensorFieldValue tfv = (TensorFieldValue)field;
                this.renderTensor(tfv.getTensor());
            } else if (field instanceof FieldValue) {
                FieldValue fv = (FieldValue)field;
                fv.serialize(null, (FieldWriter)new JsonWriter(this.generator));
            } else {
                this.generator().writeString(field.toString());
            }
        }

        private void renderNumberField(Number field) throws IOException {
            if (field instanceof Integer) {
                this.generator().writeNumber(field.intValue());
            } else if (field instanceof Float) {
                this.generator().writeNumber(field.floatValue());
            } else if (field instanceof Double) {
                this.generator().writeNumber(field.doubleValue());
            } else if (field instanceof Long) {
                this.generator().writeNumber(field.longValue());
            } else if (field instanceof Byte || field instanceof Short) {
                this.generator().writeNumber(field.intValue());
            } else if (field instanceof BigInteger) {
                BigInteger bigint = (BigInteger)field;
                this.generator().writeNumber(bigint);
            } else if (field instanceof BigDecimal) {
                BigDecimal bigdec = (BigDecimal)field;
                this.generator().writeNumber(bigdec);
            } else {
                this.generator().writeNumber(field.doubleValue());
            }
        }

        private void emitJsonProducer(JsonProducer jp) throws IOException {
            if (this.settings.renderTarget == RenderTarget.Json) {
                this.generator().writeRawValue(jp.toJson());
            } else {
                JsonDataSource.fromJson(jp.toJson()).emit(this.dataSink());
            }
        }

        private void renderTensor(Optional<Tensor> tensor) {
            Tensor t = tensor.orElse(Tensor.Builder.of((TensorType)TensorType.empty).build());
            new TensorDataSource(t, this.settings.tensorOptions).emit((DataSink)new NonFiniteToNullDataSink(this.dataSink()));
        }

        private JsonGenerator generator() {
            if (this.generator == null) {
                throw new UnsupportedOperationException("Generator required but not assigned. All accept() methods must be overridden when sub-classing FieldConsumer");
            }
            return this.generator;
        }

        private JsonGeneratorDataSink dataSink() {
            if (this.dataSink == null) {
                throw new UnsupportedOperationException("DataSink required but not assigned. All accept() methods must be overridden when sub-classing FieldConsumer without a generator");
            }
            return this.dataSink;
        }
    }

    private record NonFiniteToNullDataSink(DataSink delegate) implements DataSink
    {
        public void doubleValue(double v) {
            if (Double.isFinite(v)) {
                this.delegate.doubleValue(v);
            } else {
                this.delegate.emptyValue();
            }
        }

        public void floatValue(float v) {
            if (Float.isFinite(v)) {
                this.delegate.floatValue(v);
            } else {
                this.delegate.emptyValue();
            }
        }

        public void fieldName(String utf16, byte[] utf8) {
            this.delegate.fieldName(utf16, utf8);
        }

        public void startObject() {
            this.delegate.startObject();
        }

        public void endObject() {
            this.delegate.endObject();
        }

        public void startArray() {
            this.delegate.startArray();
        }

        public void endArray() {
            this.delegate.endArray();
        }

        public void emptyValue() {
            this.delegate.emptyValue();
        }

        public void booleanValue(boolean v) {
            this.delegate.booleanValue(v);
        }

        public void longValue(long v) {
            this.delegate.longValue(v);
        }

        public void stringValue(String utf16, byte[] utf8) {
            this.delegate.stringValue(utf16, utf8);
        }

        public void dataValue(byte[] data) {
            this.delegate.dataValue(data);
        }
    }

    static enum RenderTarget {
        Json,
        Cbor;

    }
}

