/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.rendering;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.json.UTF8JsonGenerator;
import com.yahoo.data.disclosure.DataSink;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;

class JsonGeneratorDataSink
implements DataSink {
    private JsonGenerator gen;
    private boolean wantUtf8;

    public JsonGeneratorDataSink(JsonGenerator gen) {
        this.gen = gen;
        this.wantUtf8 = gen instanceof UTF8JsonGenerator;
    }

    public void fieldName(String utf16, byte[] utf8) {
        try {
            if (utf16 != null) {
                this.gen.writeFieldName(utf16);
            } else {
                this.gen.writeFieldName(new String(utf8, StandardCharsets.UTF_8));
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void startObject() {
        try {
            this.gen.writeStartObject();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void endObject() {
        try {
            this.gen.writeEndObject();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void startArray() {
        try {
            this.gen.writeStartArray();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void endArray() {
        try {
            this.gen.writeEndArray();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void emptyValue() {
        try {
            this.gen.writeNull();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void booleanValue(boolean v) {
        try {
            this.gen.writeBoolean(v);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void longValue(long v) {
        try {
            this.gen.writeNumber(v);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void intValue(int v) {
        try {
            this.gen.writeNumber(v);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void shortValue(short v) {
        try {
            this.gen.writeNumber(v);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void byteValue(byte v) {
        try {
            this.gen.writeNumber((short)v);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void doubleValue(double v) {
        try {
            this.gen.writeNumber(v);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void floatValue(float v) {
        try {
            this.gen.writeNumber(v);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void stringValue(String utf16, byte[] utf8) {
        try {
            if (this.wantUtf8) {
                if (utf8 != null) {
                    this.gen.writeUTF8String(utf8, 0, utf8.length);
                } else {
                    this.gen.writeString(utf16);
                }
            } else if (utf16 != null) {
                this.gen.writeString(utf16);
            } else {
                this.gen.writeString(new String(utf8, StandardCharsets.UTF_8));
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void dataValue(byte[] data) {
        throw new UnsupportedOperationException("Not implemented");
    }
}

