/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.query.ranking;

import com.yahoo.processing.IllegalInputException;
import com.yahoo.search.query.profile.types.FieldDescription;
import com.yahoo.search.query.profile.types.QueryProfileType;
import com.yahoo.search.query.ranking.Diversity;
import com.yahoo.search.query.ranking.RankProperties;
import java.util.Objects;

public class MatchPhase
implements Cloneable {
    private static final QueryProfileType argumentType = new QueryProfileType("matchPhase");
    public static final String ATTRIBUTE = "attribute";
    public static final String ASCENDING = "ascending";
    public static final String MAX_HITS = "maxHits";
    public static final String MAX_FILTER_COVERAGE = "maxFilterCoverage";
    private String attribute = null;
    private boolean ascending = false;
    private Long maxHits = null;
    private Double maxFilterCoverage = 0.2;
    private Diversity diversity = new Diversity();

    public static QueryProfileType getArgumentType() {
        return argumentType;
    }

    public void setAttribute(String attribute) {
        this.attribute = attribute;
    }

    public String getAttribute() {
        return this.attribute;
    }

    public void setAscending(boolean ascending) {
        this.ascending = ascending;
    }

    public boolean getAscending() {
        return this.ascending;
    }

    public void setMaxHits(long maxHits) {
        this.maxHits = maxHits;
    }

    public void setMaxFilterCoverage(double maxFilterCoverage) {
        if (maxFilterCoverage < 0.0 || maxFilterCoverage > 1.0) {
            throw new IllegalInputException("maxFilterCoverage must be in the range [0.0, 1.0], but is " + maxFilterCoverage);
        }
        this.maxFilterCoverage = maxFilterCoverage;
    }

    public Long getMaxHits() {
        return this.maxHits;
    }

    public Double getMaxFilterCoverage() {
        return this.maxFilterCoverage;
    }

    public Diversity getDiversity() {
        return this.diversity;
    }

    public void setDiversity(Diversity diversity) {
        this.diversity = diversity;
    }

    public void prepare(RankProperties rankProperties) {
        if (this.attribute == null || this.maxHits == null) {
            return;
        }
        rankProperties.put("vespa.matchphase.degradation.attribute", this.attribute);
        if (this.ascending) {
            rankProperties.put("vespa.matchphase.degradation.ascendingorder", "true");
        }
        rankProperties.put("vespa.matchphase.degradation.maxhits", String.valueOf(this.maxHits));
        rankProperties.put("vespa.matchphase.degradation.maxfiltercoverage", String.valueOf(this.maxFilterCoverage));
        this.diversity.prepare(rankProperties);
    }

    public int hashCode() {
        return Objects.hash(this.ascending, this.attribute, this.maxHits, this.diversity, this.maxFilterCoverage);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MatchPhase)) {
            return false;
        }
        MatchPhase other = (MatchPhase)o;
        if (this.ascending != other.ascending) {
            return false;
        }
        if (!Objects.equals(this.attribute, other.attribute)) {
            return false;
        }
        if (!Objects.equals(this.maxHits, other.maxHits)) {
            return false;
        }
        if (!Objects.equals(this.diversity, other.diversity)) {
            return false;
        }
        return Objects.equals(this.maxFilterCoverage, other.maxFilterCoverage);
    }

    public MatchPhase clone() {
        try {
            MatchPhase clone = (MatchPhase)super.clone();
            clone.diversity = this.diversity.clone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Won't happen", e);
        }
    }

    static {
        argumentType.setStrict(true);
        argumentType.setBuiltin(true);
        argumentType.addField(new FieldDescription(ATTRIBUTE, "string"));
        argumentType.addField(new FieldDescription(ASCENDING, "boolean"));
        argumentType.addField(new FieldDescription(MAX_HITS, "long"));
        argumentType.addField(new FieldDescription(MAX_FILTER_COVERAGE, "double"));
        argumentType.addField(new FieldDescription("diversity", "query-profile", "diversity"));
        argumentType.freeze();
    }
}

