/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.query.ranking;

import com.yahoo.search.query.profile.types.FieldDescription;
import com.yahoo.search.query.profile.types.QueryProfileFieldType;
import com.yahoo.search.query.profile.types.QueryProfileType;
import com.yahoo.search.query.ranking.RankProperties;
import com.yahoo.search.query.ranking.WeakAnd;
import java.util.Locale;
import java.util.Objects;

public class Matching
implements Cloneable {
    private static final QueryProfileType argumentType = new QueryProfileType("matching");
    public static final String TERMWISELIMIT = "termwiseLimit";
    public static final String NUMTHREADSPERSEARCH = "numThreadsPerSearch";
    public static final String NUMSEARCHPARTITIIONS = "numSearchPartitions";
    public static final String MINHITSPERTHREAD = "minHitsPerThread";
    public static final String POST_FILTER_THRESHOLD = "postFilterThreshold";
    public static final String EXPLORATION_SLACK = "explorationSlack";
    public static final String APPROXIMATE_THRESHOLD = "approximateThreshold";
    public static final String FILTER_FIRST_THRESHOLD = "filterFirstThreshold";
    public static final String FILTER_FIRST_EXPLORATION = "filterFirstExploration";
    public static final String TARGET_HITS_MAX_ADJUSTMENT_FACTOR = "targetHitsMaxAdjustmentFactor";
    public static final String FILTER_THRESHOLD = "filterThreshold";
    public static final String WEAKAND = "weakand";
    public Double termwiseLimit = null;
    private Integer numThreadsPerSearch = null;
    private Integer numSearchPartitions = null;
    private Integer minHitsPerThread = null;
    private Double postFilterThreshold = null;
    private Double approximateThreshold = null;
    private Double filterFirstThreshold = null;
    private Double filterFirstExploration = null;
    private Double explorationSlack = null;
    private Double targetHitsMaxAdjustmentFactor = null;
    private Double filterThreshold = null;
    private WeakAnd weakAnd = new WeakAnd();

    public static QueryProfileType getArgumentType() {
        return argumentType;
    }

    public Double getTermwiseLimit() {
        return this.termwiseLimit;
    }

    public Integer getNumThreadsPerSearch() {
        return this.numThreadsPerSearch;
    }

    public Integer getNumSearchPartitions() {
        return this.numSearchPartitions;
    }

    public Integer getMinHitsPerThread() {
        return this.minHitsPerThread;
    }

    public Double getPostFilterThreshold() {
        return this.postFilterThreshold;
    }

    public Double getApproximateThreshold() {
        return this.approximateThreshold;
    }

    public Double getFilterFirstThreshold() {
        return this.filterFirstThreshold;
    }

    public Double getFilterFirstExploration() {
        return this.filterFirstExploration;
    }

    public Double getExplorationSlack() {
        return this.explorationSlack;
    }

    public Double getTargetHitsMaxAdjustmentFactor() {
        return this.targetHitsMaxAdjustmentFactor;
    }

    public Double getFilterThreshold() {
        return this.filterThreshold;
    }

    public WeakAnd getWeakAnd() {
        return this.weakAnd;
    }

    private static void validateRange(String field, double v, double lboundIncl, double uboundIncl) {
        if (v < lboundIncl || v > uboundIncl) {
            throw new IllegalArgumentException(String.format(Locale.US, "%s must be in the range [%.1f, %.1f], but is %.1f", field, lboundIncl, uboundIncl, v));
        }
    }

    public void setTermwiselimit(double value) {
        Matching.validateRange(TERMWISELIMIT, value, 0.0, 1.0);
        this.termwiseLimit = value;
    }

    public void setNumThreadsPerSearch(int value) {
        this.numThreadsPerSearch = value;
    }

    public void setNumSearchPartitions(int value) {
        this.numSearchPartitions = value;
    }

    public void setMinHitsPerThread(int value) {
        this.minHitsPerThread = value;
    }

    public void setPostFilterThreshold(double threshold) {
        this.postFilterThreshold = threshold;
    }

    public void setApproximateThreshold(double threshold) {
        this.approximateThreshold = threshold;
    }

    public void setFilterFirstThreshold(double threshold) {
        this.filterFirstThreshold = threshold;
    }

    public void setFilterFirstExploration(double threshold) {
        this.filterFirstExploration = threshold;
    }

    public void setExplorationSlack(double slack) {
        this.explorationSlack = slack;
    }

    public void setTargetHitsMaxAdjustmentFactor(double factor) {
        this.targetHitsMaxAdjustmentFactor = factor;
    }

    public void setFilterThreshold(double threshold) {
        Matching.validateRange(FILTER_THRESHOLD, threshold, 0.0, 1.0);
        this.filterThreshold = threshold;
    }

    public void prepare(RankProperties rankProperties) {
        if (this.termwiseLimit != null) {
            rankProperties.put("vespa.matching.termwise_limit", String.valueOf(this.termwiseLimit));
        }
        if (this.numThreadsPerSearch != null) {
            rankProperties.put("vespa.matching.numthreadspersearch", String.valueOf(this.numThreadsPerSearch));
        }
        if (this.numSearchPartitions != null) {
            rankProperties.put("vespa.matching.numsearchpartitions", String.valueOf(this.numSearchPartitions));
        }
        if (this.minHitsPerThread != null) {
            rankProperties.put("vespa.matching.minhitsperthread", String.valueOf(this.minHitsPerThread));
        }
        if (this.postFilterThreshold != null) {
            rankProperties.put("vespa.matching.global_filter.upper_limit", String.valueOf(this.postFilterThreshold));
        }
        if (this.approximateThreshold != null) {
            rankProperties.put("vespa.matching.global_filter.lower_limit", String.valueOf(this.approximateThreshold));
        }
        if (this.filterFirstThreshold != null) {
            rankProperties.put("vespa.matching.nns.filter_first_upper_limit", String.valueOf(this.filterFirstThreshold));
        }
        if (this.filterFirstThreshold != null) {
            rankProperties.put("vespa.matching.nns.filter_first_exploration", String.valueOf(this.filterFirstExploration));
        }
        if (this.explorationSlack != null) {
            rankProperties.put("vespa.matching.nns.exploration_slack", String.valueOf(this.explorationSlack));
        }
        if (this.targetHitsMaxAdjustmentFactor != null) {
            rankProperties.put("vespa.matching.nns.target_hits_max_adjustment_factor", String.valueOf(this.targetHitsMaxAdjustmentFactor));
        }
        if (this.filterThreshold != null) {
            rankProperties.put("vespa.matching.filter_threshold", String.valueOf(this.filterThreshold));
        }
        this.weakAnd.prepare(rankProperties);
    }

    public Matching clone() {
        try {
            Matching clone = (Matching)super.clone();
            clone.weakAnd = this.weakAnd.clone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Won't happen", e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Matching matching = (Matching)o;
        return Objects.equals(this.termwiseLimit, matching.termwiseLimit) && Objects.equals(this.numThreadsPerSearch, matching.numThreadsPerSearch) && Objects.equals(this.numSearchPartitions, matching.numSearchPartitions) && Objects.equals(this.minHitsPerThread, matching.minHitsPerThread) && Objects.equals(this.postFilterThreshold, matching.postFilterThreshold) && Objects.equals(this.approximateThreshold, matching.approximateThreshold) && Objects.equals(this.filterFirstThreshold, matching.filterFirstThreshold) && Objects.equals(this.filterFirstExploration, matching.filterFirstExploration) && Objects.equals(this.explorationSlack, matching.explorationSlack) && Objects.equals(this.targetHitsMaxAdjustmentFactor, matching.targetHitsMaxAdjustmentFactor) && Objects.equals(this.filterThreshold, matching.filterThreshold) && Objects.equals(this.weakAnd, matching.weakAnd);
    }

    public int hashCode() {
        return Objects.hash(this.termwiseLimit, this.numThreadsPerSearch, this.numSearchPartitions, this.minHitsPerThread, this.postFilterThreshold, this.approximateThreshold, this.filterFirstThreshold, this.filterFirstExploration, this.explorationSlack, this.targetHitsMaxAdjustmentFactor, this.filterThreshold, this.weakAnd);
    }

    static {
        argumentType.setStrict(true);
        argumentType.setBuiltin(true);
        argumentType.addField(new FieldDescription(TERMWISELIMIT, "double"));
        argumentType.addField(new FieldDescription(NUMTHREADSPERSEARCH, "integer"));
        argumentType.addField(new FieldDescription(NUMSEARCHPARTITIIONS, "integer"));
        argumentType.addField(new FieldDescription(MINHITSPERTHREAD, "integer"));
        argumentType.addField(new FieldDescription(POST_FILTER_THRESHOLD, "double"));
        argumentType.addField(new FieldDescription(APPROXIMATE_THRESHOLD, "double"));
        argumentType.addField(new FieldDescription(FILTER_FIRST_THRESHOLD, "double"));
        argumentType.addField(new FieldDescription(FILTER_FIRST_EXPLORATION, "double"));
        argumentType.addField(new FieldDescription(EXPLORATION_SLACK, "double"));
        argumentType.addField(new FieldDescription(TARGET_HITS_MAX_ADJUSTMENT_FACTOR, "double"));
        argumentType.addField(new FieldDescription(FILTER_THRESHOLD, "double"));
        argumentType.addField(new FieldDescription(WEAKAND, new QueryProfileFieldType(WeakAnd.getArgumentType())));
        argumentType.freeze();
    }
}

