/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.querytransform;

import com.yahoo.component.chain.dependencies.After;
import com.yahoo.component.chain.dependencies.Before;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.Searcher;
import com.yahoo.search.query.Sorting;
import com.yahoo.search.searchchain.Execution;
import java.util.List;

@After(value={"rawQuery"})
@Before(value={"transformedQuery"})
public class NoRankingSearcher
extends Searcher {
    private static final String RANK = "[rank]";
    private static final String UNRANKED = "unranked";

    @Override
    public Result search(Query query, Execution execution) {
        List<Sorting.FieldOrder> s;
        List<Sorting.FieldOrder> list = s = query.getRanking().getSorting() != null ? query.getRanking().getSorting().fieldOrders() : null;
        if (s == null) {
            return execution.search(query);
        }
        for (Sorting.FieldOrder f : s) {
            if (!RANK.equals(f.getFieldName())) continue;
            return execution.search(query);
        }
        query.getRanking().setProfile(UNRANKED);
        return execution.search(query);
    }
}

