/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.query;

import ai.vespa.searchlib.searchprotocol.protobuf.SearchProtocol;
import com.yahoo.compress.IntegerCompressor;
import com.yahoo.prelude.query.Item;
import com.yahoo.prelude.query.PureWeightedString;
import com.yahoo.prelude.query.Substring;
import com.yahoo.prelude.query.TermItem;
import com.yahoo.prelude.query.ToProtobuf;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class WordAlternativesItem
extends TermItem {
    private List<Alternative> alternatives;

    public WordAlternativesItem(String indexName, boolean isFromQuery, Substring origin, Collection<Alternative> terms) {
        super(indexName, isFromQuery, origin);
        this.setAlternatives(terms);
    }

    public void setAlternatives(Collection<Alternative> terms) {
        this.alternatives = WordAlternativesItem.uniqueAlternatives(terms);
    }

    private static List<Alternative> uniqueAlternatives(Collection<Alternative> terms) {
        ArrayList<Alternative> uniqueTerms = new ArrayList<Alternative>(terms.size());
        for (Alternative term : terms) {
            int i = Collections.binarySearch(uniqueTerms, term, (t0, t1) -> t0.word.compareTo(t1.word));
            if (i >= 0) {
                Alternative old = (Alternative)uniqueTerms.get(i);
                if (!(old.exactness < term.exactness)) continue;
                uniqueTerms.set(i, term);
                continue;
            }
            uniqueTerms.add(~i, term);
        }
        return List.copyOf(uniqueTerms);
    }

    @Override
    public String stringValue() {
        StringBuilder builder = new StringBuilder();
        builder.append("[ ");
        for (Alternative a : this.alternatives) {
            builder.append(a.word).append("(").append(a.exactness).append(") ");
        }
        builder.append("]");
        return builder.toString();
    }

    @Override
    public boolean isStemmed() {
        return true;
    }

    @Override
    public int getNumWords() {
        return 1;
    }

    @Override
    public void setValue(String value) {
        throw new UnsupportedOperationException("Semantics for setting to a string would be brittle, use setAlternatives()");
    }

    @Override
    public String getRawWord() {
        if (this.getOrigin() == null) {
            return this.stringValue();
        }
        return this.getOrigin().getValue();
    }

    @Override
    public boolean isWords() {
        return true;
    }

    @Override
    public String getIndexedString() {
        return this.alternatives.stream().map(x -> x.word).collect(Collectors.joining(" "));
    }

    @Override
    public Item.ItemType getItemType() {
        return Item.ItemType.WORD_ALTERNATIVES;
    }

    @Override
    public String getName() {
        return "WORD_ALTERNATIVES";
    }

    public List<Alternative> getAlternatives() {
        return this.alternatives;
    }

    @Override
    public void encodeThis(ByteBuffer target) {
        super.encodeThis(target);
        IntegerCompressor.putCompressedPositiveNumber((int)this.alternatives.size(), (ByteBuffer)target);
        for (Alternative a : this.alternatives) {
            PureWeightedString p = new PureWeightedString(a.word, (int)((double)this.getWeight() * a.exactness + 0.5));
            p.setFilter(this.isFilter());
            ((Item)p).encode(target);
        }
    }

    public void addTerm(String term, double exactness) {
        if (this.alternatives.stream().anyMatch(a -> a.word.equals(term) && a.exactness >= exactness)) {
            return;
        }
        ArrayList<Alternative> newTerms = new ArrayList<Alternative>(this.alternatives.size() + 1);
        newTerms.addAll(this.alternatives);
        newTerms.add(new Alternative(term, exactness));
        this.setAlternatives(newTerms);
    }

    @Override
    public WordAlternativesItem clone() {
        WordAlternativesItem clone = (WordAlternativesItem)super.clone();
        clone.alternatives = new ArrayList<Alternative>(this.alternatives);
        return clone;
    }

    @Override
    public boolean equals(Object other) {
        if (!super.equals(other)) {
            return false;
        }
        return this.alternatives.equals(((WordAlternativesItem)other).alternatives);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.alternatives);
    }

    @Override
    SearchProtocol.QueryTreeItem toProtobuf() {
        SearchProtocol.ItemWordAlternatives.Builder builder = SearchProtocol.ItemWordAlternatives.newBuilder();
        builder.setProperties(ToProtobuf.buildTermProperties(this, this.getIndexName()));
        for (Alternative alt : this.alternatives) {
            SearchProtocol.PureWeightedString weightedString = SearchProtocol.PureWeightedString.newBuilder().setWeight((int)((double)this.getWeight() * alt.exactness + 0.5)).setValue(alt.word).build();
            builder.addWeightedStrings(weightedString);
        }
        return SearchProtocol.QueryTreeItem.newBuilder().setItemWordAlternatives(builder.build()).build();
    }

    public static final class Alternative {
        public final String word;
        public final double exactness;

        public Alternative(String word, double exactness) {
            this.word = word;
            this.exactness = exactness;
        }

        public String toString() {
            return "Alternative [word=" + this.word + ", exactness=" + this.exactness + "]";
        }

        public boolean equals(Object o) {
            if (!(o instanceof Alternative)) {
                return false;
            }
            Alternative other = (Alternative)o;
            if (!Objects.equals(this.word, other.word)) {
                return false;
            }
            return this.exactness == other.exactness;
        }

        public int hashCode() {
            return Objects.hash(this.word, this.exactness);
        }
    }
}

