// ------------   D O   N O T   E D I T !   ------------
// This file is generated from a config definition file.

package com.yahoo.search.query.profile.config;

import java.util.*;
import java.io.File;
import java.nio.file.Path;
import com.yahoo.config.*;

/**
 * This class represents the root node of query-profiles
 *
 * Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
 * Query profiles and their types - a query profile is a nested composite of query parameters with an id
 * A set of query parameters can be fetched from a query profile rather than being
 * submitted explicitly.
 */
public final class QueryProfilesConfig extends ConfigInstance {

  public final static String CONFIG_DEF_MD5 = "e4838a3e3110cfacc62bf5222756485d";
  public final static String CONFIG_DEF_NAME = "query-profiles";
  public final static String CONFIG_DEF_NAMESPACE = "search.query.profile.config";
  public final static String[] CONFIG_DEF_SCHEMA = {
    "namespace=search.query.profile.config",
    "queryprofile[].id string",
    "queryprofile[].type string default=\"\"",
    "queryprofile[].inherit[] string",
    "queryprofile[].dimensions[] string",
    "queryprofile[].property[].name string",
    "queryprofile[].property[].value string",
    "queryprofile[].property[].overridable string default=\"\"",
    "queryprofile[].reference[].name string",
    "queryprofile[].reference[].value string",
    "queryprofile[].reference[].overridable string default=\"\"",
    "queryprofile[].queryprofilevariant[].fordimensionvalues[] string",
    "queryprofile[].queryprofilevariant[].inherit[] string",
    "queryprofile[].queryprofilevariant[].property[].name string",
    "queryprofile[].queryprofilevariant[].property[].value string",
    "queryprofile[].queryprofilevariant[].property[].overridable string default=\"\"",
    "queryprofile[].queryprofilevariant[].reference[].name string",
    "queryprofile[].queryprofilevariant[].reference[].value string",
    "queryprofile[].queryprofilevariant[].reference[].overridable string default=\"\"",
    "queryprofiletype[].id string",
    "queryprofiletype[].strict bool default=false",
    "queryprofiletype[].matchaspath bool default=false",
    "queryprofiletype[].inherit[] string",
    "queryprofiletype[].field[].name string",
    "queryprofiletype[].field[].type string",
    "queryprofiletype[].field[].overridable bool default=true",
    "queryprofiletype[].field[].mandatory bool default=false",
    "queryprofiletype[].field[].alias string default=\"\"",
    "enableGroupingSessionCache bool default=true"
  };

  public static String getDefMd5()       { return CONFIG_DEF_MD5; }
  public static String getDefName()      { return CONFIG_DEF_NAME; }
  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

  public interface Producer extends ConfigInstance.Producer {
    void getConfig(Builder builder);
  }

  public static final class Builder implements ConfigInstance.Builder {
    private Set<String> __uninitialized = new HashSet<String>();

    public List<Queryprofile.Builder> queryprofile = new ArrayList<>();
    public List<Queryprofiletype.Builder> queryprofiletype = new ArrayList<>();
    private Boolean enableGroupingSessionCache = null;

    public Builder() { }

    public Builder(QueryProfilesConfig config) {
      for (Queryprofile q : config.queryprofile()) {
        queryprofile(new Queryprofile.Builder(q));
      }
      for (Queryprofiletype q : config.queryprofiletype()) {
        queryprofiletype(new Queryprofiletype.Builder(q));
      }
      enableGroupingSessionCache(config.enableGroupingSessionCache());
    }

    private Builder override(Builder __superior) {
      if (!__superior.queryprofile.isEmpty())
        queryprofile.addAll(__superior.queryprofile);
      if (!__superior.queryprofiletype.isEmpty())
        queryprofiletype.addAll(__superior.queryprofiletype);
      if (__superior.enableGroupingSessionCache != null)
        enableGroupingSessionCache(__superior.enableGroupingSessionCache);
      return this;
    }

    /**
     * Add the given builder to this builder's list of Queryprofile builders
     * @param __builder a builder
     * @return this builder
     */
    public Builder queryprofile(Queryprofile.Builder __builder) {
      queryprofile.add(__builder);
      return this;
    }

    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder queryprofile(java.util.function.Consumer<Queryprofile.Builder> __func) {
      Queryprofile.Builder __inner = new Queryprofile.Builder();
      __func.accept(__inner);
      queryprofile.add(__inner);
      return this;
    }

    /**
     * Set the given list as this builder's list of Queryprofile builders
     * @param __builders a list of builders
     * @return this builder
     */
    public Builder queryprofile(List<Queryprofile.Builder> __builders) {
      queryprofile = __builders;
      return this;
    }

    /**
     * Add the given builder to this builder's list of Queryprofiletype builders
     * @param __builder a builder
     * @return this builder
     */
    public Builder queryprofiletype(Queryprofiletype.Builder __builder) {
      queryprofiletype.add(__builder);
      return this;
    }

    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder queryprofiletype(java.util.function.Consumer<Queryprofiletype.Builder> __func) {
      Queryprofiletype.Builder __inner = new Queryprofiletype.Builder();
      __func.accept(__inner);
      queryprofiletype.add(__inner);
      return this;
    }

    /**
     * Set the given list as this builder's list of Queryprofiletype builders
     * @param __builders a list of builders
     * @return this builder
     */
    public Builder queryprofiletype(List<Queryprofiletype.Builder> __builders) {
      queryprofiletype = __builders;
      return this;
    }

    public Builder enableGroupingSessionCache(boolean __value) {
      enableGroupingSessionCache = __value;
      return this;
    }

    private Builder enableGroupingSessionCache(String __value) {
      return enableGroupingSessionCache(Boolean.valueOf(__value));
    }

    private boolean _applyOnRestart = false;

    @java.lang.Override
    public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
      if (producer instanceof Producer) {
        ((Producer)producer).getConfig(this);
        return true;
      }
      return false;
    }

    @java.lang.Override
    public final String getDefMd5() { return CONFIG_DEF_MD5; }

    @java.lang.Override
    public final String getDefName() { return CONFIG_DEF_NAME; }

    @java.lang.Override
    public final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

    @java.lang.Override
    public final boolean getApplyOnRestart() { return _applyOnRestart; }

    @java.lang.Override
    public final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }

    public QueryProfilesConfig build() {
      return new QueryProfilesConfig(this);
    }

  }

  private final InnerNodeVector<Queryprofile> queryprofile;
  private final InnerNodeVector<Queryprofiletype> queryprofiletype;
  // TODO Remove once no longer used by old config models
  private final BooleanNode enableGroupingSessionCache;

  public QueryProfilesConfig(Builder builder) {
    this(builder, true);
  }

  private QueryProfilesConfig(Builder builder, boolean throwIfUninitialized) {
    if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
      throw new IllegalArgumentException("The following builder parameters for " +
          "query-profiles must be initialized: " + builder.__uninitialized);

    queryprofile = Queryprofile.createVector(builder.queryprofile);
    queryprofiletype = Queryprofiletype.createVector(builder.queryprofiletype);
    enableGroupingSessionCache = (builder.enableGroupingSessionCache == null) ?
        new BooleanNode(true) : new BooleanNode(builder.enableGroupingSessionCache);
  }

  /**
   * @return query-profiles.queryprofile[]
   */
  public List<Queryprofile> queryprofile() {
    return queryprofile;
  }

  /**
   * @param i the index of the value to return
   * @return query-profiles.queryprofile[]
   */
  public Queryprofile queryprofile(int i) {
    return queryprofile.get(i);
  }

  /**
   * @return query-profiles.queryprofiletype[]
   */
  public List<Queryprofiletype> queryprofiletype() {
    return queryprofiletype;
  }

  /**
   * @param i the index of the value to return
   * @return query-profiles.queryprofiletype[]
   */
  public Queryprofiletype queryprofiletype(int i) {
    return queryprofiletype.get(i);
  }

  /**
   * @return query-profiles.enableGroupingSessionCache
   */
  public boolean enableGroupingSessionCache() {
    return enableGroupingSessionCache.value();
  }

  private ChangesRequiringRestart getChangesRequiringRestart(QueryProfilesConfig newConfig) {
    ChangesRequiringRestart changes = new ChangesRequiringRestart("query-profiles");
    return changes;
  }

  private static boolean containsFieldsFlaggedWithRestart() {
    return false;
  }

  /**
   * This class represents query-profiles.queryprofile[]
   */
  public final static class Queryprofile extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>(List.of(
        "id"
        ));

      private String id = null;
      private String type = null;
      public List<String> inherit = new ArrayList<>();
      public List<String> dimensions = new ArrayList<>();
      public List<Property.Builder> property = new ArrayList<>();
      public List<Reference.Builder> reference = new ArrayList<>();
      public List<Queryprofilevariant.Builder> queryprofilevariant = new ArrayList<>();

      public Builder() { }

      public Builder(Queryprofile config) {
        id(config.id());
        type(config.type());
        inherit(config.inherit());
        dimensions(config.dimensions());
        for (Property p : config.property()) {
          property(new Property.Builder(p));
        }
        for (Reference r : config.reference()) {
          reference(new Reference.Builder(r));
        }
        for (Queryprofilevariant q : config.queryprofilevariant()) {
          queryprofilevariant(new Queryprofilevariant.Builder(q));
        }
      }

      private Builder override(Builder __superior) {
        if (__superior.id != null)
          id(__superior.id);
        if (__superior.type != null)
          type(__superior.type);
        if (!__superior.inherit.isEmpty())
          inherit.addAll(__superior.inherit);
        if (!__superior.dimensions.isEmpty())
          dimensions.addAll(__superior.dimensions);
        if (!__superior.property.isEmpty())
          property.addAll(__superior.property);
        if (!__superior.reference.isEmpty())
          reference.addAll(__superior.reference);
        if (!__superior.queryprofilevariant.isEmpty())
          queryprofilevariant.addAll(__superior.queryprofilevariant);
        return this;
      }

      public Builder id(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        id = __value;
        __uninitialized.remove("id");
        return this;
      }


      public Builder type(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        type = __value;
        return this;
      }


      public Builder inherit(String __value) {
        inherit.add(__value);
        return this;
      }

      public Builder inherit(Collection<String> __values) {
        inherit.addAll(__values);
        return this;
      }

      public Builder dimensions(String __value) {
        dimensions.add(__value);
        return this;
      }

      public Builder dimensions(Collection<String> __values) {
        dimensions.addAll(__values);
        return this;
      }

      /**
       * Add the given builder to this builder's list of Property builders
       * @param __builder a builder
       * @return this builder
       */
      public Builder property(Property.Builder __builder) {
        property.add(__builder);
        return this;
      }

      /**
       * Make a new builder and run the supplied function on it before adding it to the list
       * @param __func lambda that modifies the given builder
       * @return this builder
       */
      public Builder property(java.util.function.Consumer<Property.Builder> __func) {
        Property.Builder __inner = new Property.Builder();
        __func.accept(__inner);
        property.add(__inner);
        return this;
      }

      /**
       * Set the given list as this builder's list of Property builders
       * @param __builders a list of builders
       * @return this builder
       */
      public Builder property(List<Property.Builder> __builders) {
        property = __builders;
        return this;
      }

      /**
       * Add the given builder to this builder's list of Reference builders
       * @param __builder a builder
       * @return this builder
       */
      public Builder reference(Reference.Builder __builder) {
        reference.add(__builder);
        return this;
      }

      /**
       * Make a new builder and run the supplied function on it before adding it to the list
       * @param __func lambda that modifies the given builder
       * @return this builder
       */
      public Builder reference(java.util.function.Consumer<Reference.Builder> __func) {
        Reference.Builder __inner = new Reference.Builder();
        __func.accept(__inner);
        reference.add(__inner);
        return this;
      }

      /**
       * Set the given list as this builder's list of Reference builders
       * @param __builders a list of builders
       * @return this builder
       */
      public Builder reference(List<Reference.Builder> __builders) {
        reference = __builders;
        return this;
      }

      /**
       * Add the given builder to this builder's list of Queryprofilevariant builders
       * @param __builder a builder
       * @return this builder
       */
      public Builder queryprofilevariant(Queryprofilevariant.Builder __builder) {
        queryprofilevariant.add(__builder);
        return this;
      }

      /**
       * Make a new builder and run the supplied function on it before adding it to the list
       * @param __func lambda that modifies the given builder
       * @return this builder
       */
      public Builder queryprofilevariant(java.util.function.Consumer<Queryprofilevariant.Builder> __func) {
        Queryprofilevariant.Builder __inner = new Queryprofilevariant.Builder();
        __func.accept(__inner);
        queryprofilevariant.add(__inner);
        return this;
      }

      /**
       * Set the given list as this builder's list of Queryprofilevariant builders
       * @param __builders a list of builders
       * @return this builder
       */
      public Builder queryprofilevariant(List<Queryprofilevariant.Builder> __builders) {
        queryprofilevariant = __builders;
        return this;
      }

      public Queryprofile build() {
        return new Queryprofile(this);
      }

    }

    // The id of this query profile. The id has the form name(:version)?
    // where the version has the form 1(.2(.3(.identifier)?)?)?.
    // The default query profile (if any) must be called "default".
    private final StringNode id;
    // The (optional) type of this query profile, an id string
    // If no type is given, all values are legal
    private final StringNode type;
    // The optional list of query profiles this inherits, by id.
    // The id's has the form name(:version)?
    // where the version has the form 1(.2(.3(.identifier)?)?)?.
    // If the version is not specified the newest version found is used.
    private final LeafNodeVector<String, StringNode> inherit;
    // The dimensions over which this profile may vary, if any
    private final LeafNodeVector<String, StringNode> dimensions;
    private final InnerNodeVector<Property> property;
    private final InnerNodeVector<Reference> reference;
    private final InnerNodeVector<Queryprofilevariant> queryprofilevariant;

    public Queryprofile(Builder builder) {
      this(builder, true);
    }

    private Queryprofile(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "query-profiles.queryprofile[] must be initialized: " + builder.__uninitialized);

      id = (builder.id == null) ?
          new StringNode() : new StringNode(builder.id);
      type = (builder.type == null) ?
          new StringNode("") : new StringNode(builder.type);
      inherit = new LeafNodeVector<>(builder.inherit, new StringNode());
      dimensions = new LeafNodeVector<>(builder.dimensions, new StringNode());
      property = Property.createVector(builder.property);
      reference = Reference.createVector(builder.reference);
      queryprofilevariant = Queryprofilevariant.createVector(builder.queryprofilevariant);
    }

    /**
     * @return query-profiles.queryprofile[].id
     */
    public String id() {
      return id.value();
    }

    /**
     * @return query-profiles.queryprofile[].type
     */
    public String type() {
      return type.value();
    }

    /**
     * @return query-profiles.queryprofile[].inherit[]
     */
    public List<String> inherit() {
      return inherit.asList();
    }

    /**
     * @param i the index of the value to return
     * @return query-profiles.queryprofile[].inherit[]
     */
    public String inherit(int i) {
      return inherit.get(i).value();
    }

    /**
     * @return query-profiles.queryprofile[].dimensions[]
     */
    public List<String> dimensions() {
      return dimensions.asList();
    }

    /**
     * @param i the index of the value to return
     * @return query-profiles.queryprofile[].dimensions[]
     */
    public String dimensions(int i) {
      return dimensions.get(i).value();
    }

    /**
     * @return query-profiles.queryprofile[].property[]
     */
    public List<Property> property() {
      return property;
    }

    /**
     * @param i the index of the value to return
     * @return query-profiles.queryprofile[].property[]
     */
    public Property property(int i) {
      return property.get(i);
    }

    /**
     * @return query-profiles.queryprofile[].reference[]
     */
    public List<Reference> reference() {
      return reference;
    }

    /**
     * @param i the index of the value to return
     * @return query-profiles.queryprofile[].reference[]
     */
    public Reference reference(int i) {
      return reference.get(i);
    }

    /**
     * @return query-profiles.queryprofile[].queryprofilevariant[]
     */
    public List<Queryprofilevariant> queryprofilevariant() {
      return queryprofilevariant;
    }

    /**
     * @param i the index of the value to return
     * @return query-profiles.queryprofile[].queryprofilevariant[]
     */
    public Queryprofilevariant queryprofilevariant(int i) {
      return queryprofilevariant.get(i);
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Queryprofile newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("queryprofile");
      return changes;
    }

    private static InnerNodeVector<Queryprofile> createVector(List<Builder> builders) {
        List<Queryprofile> elems = new ArrayList<>();
        for (Builder b : builders) {
            elems.add(new Queryprofile(b));
        }
        return new InnerNodeVector<Queryprofile>(elems);
    }

    /**
     * This class represents query-profiles.queryprofile[].property[]
     */
    public final static class Property extends InnerNode { 

      public static final class Builder implements ConfigBuilder {
        private Set<String> __uninitialized = new HashSet<String>(List.of(
          "name",
          "value"
          ));

        private String name = null;
        private String value = null;
        private String overridable = null;

        public Builder() { }

        public Builder(Property config) {
          name(config.name());
          value(config.value());
          overridable(config.overridable());
        }

        private Builder override(Builder __superior) {
          if (__superior.name != null)
            name(__superior.name);
          if (__superior.value != null)
            value(__superior.value);
          if (__superior.overridable != null)
            overridable(__superior.overridable);
          return this;
        }

        public Builder name(String __value) {
        if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
          name = __value;
          __uninitialized.remove("name");
          return this;
        }


        public Builder value(String __value) {
        if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
          value = __value;
          __uninitialized.remove("value");
          return this;
        }


        public Builder overridable(String __value) {
        if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
          overridable = __value;
          return this;
        }


        public Property build() {
          return new Property(this);
        }

      }

      // A property name. Note that names containing dots will create implicit query profile
      // sub-instances. These instances will completely override instances in super-profiles
      // even if they don't set all the values of the super-instance
      private final StringNode name;
      // The property value
      private final StringNode value;
      // Whether the value is overridable in the request or by a programmatic setting: "true", "false" or ""
      // which means take the value from any inherited profile or the type
      private final StringNode overridable;

      public Property(Builder builder) {
        this(builder, true);
      }

      private Property(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
          throw new IllegalArgumentException("The following builder parameters for " +
              "query-profiles.queryprofile[].property[] must be initialized: " + builder.__uninitialized);

        name = (builder.name == null) ?
            new StringNode() : new StringNode(builder.name);
        value = (builder.value == null) ?
            new StringNode() : new StringNode(builder.value);
        overridable = (builder.overridable == null) ?
            new StringNode("") : new StringNode(builder.overridable);
      }

      /**
       * @return query-profiles.queryprofile[].property[].name
       */
      public String name() {
        return name.value();
      }

      /**
       * @return query-profiles.queryprofile[].property[].value
       */
      public String value() {
        return value.value();
      }

      /**
       * @return query-profiles.queryprofile[].property[].overridable
       */
      public String overridable() {
        return overridable.value();
      }

      private ChangesRequiringRestart getChangesRequiringRestart(Property newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart("property");
        return changes;
      }

      private static InnerNodeVector<Property> createVector(List<Builder> builders) {
          List<Property> elems = new ArrayList<>();
          for (Builder b : builders) {
              elems.add(new Property(b));
          }
          return new InnerNodeVector<Property>(elems);
      }
    }

    /**
     * This class represents query-profiles.queryprofile[].reference[]
     */
    public final static class Reference extends InnerNode { 

      public static final class Builder implements ConfigBuilder {
        private Set<String> __uninitialized = new HashSet<String>(List.of(
          "name",
          "value"
          ));

        private String name = null;
        private String value = null;
        private String overridable = null;

        public Builder() { }

        public Builder(Reference config) {
          name(config.name());
          value(config.value());
          overridable(config.overridable());
        }

        private Builder override(Builder __superior) {
          if (__superior.name != null)
            name(__superior.name);
          if (__superior.value != null)
            value(__superior.value);
          if (__superior.overridable != null)
            overridable(__superior.overridable);
          return this;
        }

        public Builder name(String __value) {
        if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
          name = __value;
          __uninitialized.remove("name");
          return this;
        }


        public Builder value(String __value) {
        if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
          value = __value;
          __uninitialized.remove("value");
          return this;
        }


        public Builder overridable(String __value) {
        if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
          overridable = __value;
          return this;
        }


        public Reference build() {
          return new Reference(this);
        }

      }

      // A reference name to another query profile
      private final StringNode name;
      // The id of the referenced profile, the version part may be missing
      // or underspecified as usual
      private final StringNode value;
      // Whether the value is overridable in the request or by a programmatic setting: "true", "false" or ""
      // which means take the value from any inherited profile or the type
      private final StringNode overridable;

      public Reference(Builder builder) {
        this(builder, true);
      }

      private Reference(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
          throw new IllegalArgumentException("The following builder parameters for " +
              "query-profiles.queryprofile[].reference[] must be initialized: " + builder.__uninitialized);

        name = (builder.name == null) ?
            new StringNode() : new StringNode(builder.name);
        value = (builder.value == null) ?
            new StringNode() : new StringNode(builder.value);
        overridable = (builder.overridable == null) ?
            new StringNode("") : new StringNode(builder.overridable);
      }

      /**
       * @return query-profiles.queryprofile[].reference[].name
       */
      public String name() {
        return name.value();
      }

      /**
       * @return query-profiles.queryprofile[].reference[].value
       */
      public String value() {
        return value.value();
      }

      /**
       * @return query-profiles.queryprofile[].reference[].overridable
       */
      public String overridable() {
        return overridable.value();
      }

      private ChangesRequiringRestart getChangesRequiringRestart(Reference newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart("reference");
        return changes;
      }

      private static InnerNodeVector<Reference> createVector(List<Builder> builders) {
          List<Reference> elems = new ArrayList<>();
          for (Builder b : builders) {
              elems.add(new Reference(b));
          }
          return new InnerNodeVector<Reference>(elems);
      }
    }

    /**
     * This class represents query-profiles.queryprofile[].queryprofilevariant[]
     */
    public final static class Queryprofilevariant extends InnerNode { 

      public static final class Builder implements ConfigBuilder {
        private Set<String> __uninitialized = new HashSet<String>();

        public List<String> fordimensionvalues = new ArrayList<>();
        public List<String> inherit = new ArrayList<>();
        public List<Property.Builder> property = new ArrayList<>();
        public List<Reference.Builder> reference = new ArrayList<>();

        public Builder() { }

        public Builder(Queryprofilevariant config) {
          fordimensionvalues(config.fordimensionvalues());
          inherit(config.inherit());
          for (Property p : config.property()) {
            property(new Property.Builder(p));
          }
          for (Reference r : config.reference()) {
            reference(new Reference.Builder(r));
          }
        }

        private Builder override(Builder __superior) {
          if (!__superior.fordimensionvalues.isEmpty())
            fordimensionvalues.addAll(__superior.fordimensionvalues);
          if (!__superior.inherit.isEmpty())
            inherit.addAll(__superior.inherit);
          if (!__superior.property.isEmpty())
            property.addAll(__superior.property);
          if (!__superior.reference.isEmpty())
            reference.addAll(__superior.reference);
          return this;
        }

        public Builder fordimensionvalues(String __value) {
          fordimensionvalues.add(__value);
          return this;
        }

        public Builder fordimensionvalues(Collection<String> __values) {
          fordimensionvalues.addAll(__values);
          return this;
        }

        public Builder inherit(String __value) {
          inherit.add(__value);
          return this;
        }

        public Builder inherit(Collection<String> __values) {
          inherit.addAll(__values);
          return this;
        }

        /**
         * Add the given builder to this builder's list of Property builders
         * @param __builder a builder
         * @return this builder
         */
        public Builder property(Property.Builder __builder) {
          property.add(__builder);
          return this;
        }

        /**
         * Make a new builder and run the supplied function on it before adding it to the list
         * @param __func lambda that modifies the given builder
         * @return this builder
         */
        public Builder property(java.util.function.Consumer<Property.Builder> __func) {
          Property.Builder __inner = new Property.Builder();
          __func.accept(__inner);
          property.add(__inner);
          return this;
        }

        /**
         * Set the given list as this builder's list of Property builders
         * @param __builders a list of builders
         * @return this builder
         */
        public Builder property(List<Property.Builder> __builders) {
          property = __builders;
          return this;
        }

        /**
         * Add the given builder to this builder's list of Reference builders
         * @param __builder a builder
         * @return this builder
         */
        public Builder reference(Reference.Builder __builder) {
          reference.add(__builder);
          return this;
        }

        /**
         * Make a new builder and run the supplied function on it before adding it to the list
         * @param __func lambda that modifies the given builder
         * @return this builder
         */
        public Builder reference(java.util.function.Consumer<Reference.Builder> __func) {
          Reference.Builder __inner = new Reference.Builder();
          __func.accept(__inner);
          reference.add(__inner);
          return this;
        }

        /**
         * Set the given list as this builder's list of Reference builders
         * @param __builders a list of builders
         * @return this builder
         */
        public Builder reference(List<Reference.Builder> __builders) {
          reference = __builders;
          return this;
        }

        public Queryprofilevariant build() {
          return new Queryprofilevariant(this);
        }

      }

      // A variant of this (top level) profile for some value of its dimensions
      private final LeafNodeVector<String, StringNode> fordimensionvalues;
      // The optional list of query profiles this variant inherits, by id.
      // The id's has the form name(:version)?
      // where the version has the form 1(.2(.3(.identifier)?)?)?.
      // If the version is not specified the newest version found is used.
      private final LeafNodeVector<String, StringNode> inherit;
      private final InnerNodeVector<Property> property;
      private final InnerNodeVector<Reference> reference;

      public Queryprofilevariant(Builder builder) {
        this(builder, true);
      }

      private Queryprofilevariant(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
          throw new IllegalArgumentException("The following builder parameters for " +
              "query-profiles.queryprofile[].queryprofilevariant[] must be initialized: " + builder.__uninitialized);

        fordimensionvalues = new LeafNodeVector<>(builder.fordimensionvalues, new StringNode());
        inherit = new LeafNodeVector<>(builder.inherit, new StringNode());
        property = Property.createVector(builder.property);
        reference = Reference.createVector(builder.reference);
      }

      /**
       * @return query-profiles.queryprofile[].queryprofilevariant[].fordimensionvalues[]
       */
      public List<String> fordimensionvalues() {
        return fordimensionvalues.asList();
      }

      /**
       * @param i the index of the value to return
       * @return query-profiles.queryprofile[].queryprofilevariant[].fordimensionvalues[]
       */
      public String fordimensionvalues(int i) {
        return fordimensionvalues.get(i).value();
      }

      /**
       * @return query-profiles.queryprofile[].queryprofilevariant[].inherit[]
       */
      public List<String> inherit() {
        return inherit.asList();
      }

      /**
       * @param i the index of the value to return
       * @return query-profiles.queryprofile[].queryprofilevariant[].inherit[]
       */
      public String inherit(int i) {
        return inherit.get(i).value();
      }

      /**
       * @return query-profiles.queryprofile[].queryprofilevariant[].property[]
       */
      public List<Property> property() {
        return property;
      }

      /**
       * @param i the index of the value to return
       * @return query-profiles.queryprofile[].queryprofilevariant[].property[]
       */
      public Property property(int i) {
        return property.get(i);
      }

      /**
       * @return query-profiles.queryprofile[].queryprofilevariant[].reference[]
       */
      public List<Reference> reference() {
        return reference;
      }

      /**
       * @param i the index of the value to return
       * @return query-profiles.queryprofile[].queryprofilevariant[].reference[]
       */
      public Reference reference(int i) {
        return reference.get(i);
      }

      private ChangesRequiringRestart getChangesRequiringRestart(Queryprofilevariant newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart("queryprofilevariant");
        return changes;
      }

      private static InnerNodeVector<Queryprofilevariant> createVector(List<Builder> builders) {
          List<Queryprofilevariant> elems = new ArrayList<>();
          for (Builder b : builders) {
              elems.add(new Queryprofilevariant(b));
          }
          return new InnerNodeVector<Queryprofilevariant>(elems);
      }

      /**
       * This class represents query-profiles.queryprofile[].queryprofilevariant[].property[]
       */
      public final static class Property extends InnerNode { 

        public static final class Builder implements ConfigBuilder {
          private Set<String> __uninitialized = new HashSet<String>(List.of(
            "name",
            "value"
            ));

          private String name = null;
          private String value = null;
          private String overridable = null;

          public Builder() { }

          public Builder(Property config) {
            name(config.name());
            value(config.value());
            overridable(config.overridable());
          }

          private Builder override(Builder __superior) {
            if (__superior.name != null)
              name(__superior.name);
            if (__superior.value != null)
              value(__superior.value);
            if (__superior.overridable != null)
              overridable(__superior.overridable);
            return this;
          }

          public Builder name(String __value) {
          if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
            name = __value;
            __uninitialized.remove("name");
            return this;
          }


          public Builder value(String __value) {
          if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
            value = __value;
            __uninitialized.remove("value");
            return this;
          }


          public Builder overridable(String __value) {
          if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
            overridable = __value;
            return this;
          }


          public Property build() {
            return new Property(this);
          }

        }

        // Content of profile variant
        private final StringNode name;
        // Content of profile variant
        private final StringNode value;
        // Whether this property is overridable: "true", "false" or ""
        private final StringNode overridable;

        public Property(Builder builder) {
          this(builder, true);
        }

        private Property(Builder builder, boolean throwIfUninitialized) {
          if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
            throw new IllegalArgumentException("The following builder parameters for " +
                "query-profiles.queryprofile[].queryprofilevariant[].property[] must be initialized: " + builder.__uninitialized);

          name = (builder.name == null) ?
              new StringNode() : new StringNode(builder.name);
          value = (builder.value == null) ?
              new StringNode() : new StringNode(builder.value);
          overridable = (builder.overridable == null) ?
              new StringNode("") : new StringNode(builder.overridable);
        }

        /**
         * @return query-profiles.queryprofile[].queryprofilevariant[].property[].name
         */
        public String name() {
          return name.value();
        }

        /**
         * @return query-profiles.queryprofile[].queryprofilevariant[].property[].value
         */
        public String value() {
          return value.value();
        }

        /**
         * @return query-profiles.queryprofile[].queryprofilevariant[].property[].overridable
         */
        public String overridable() {
          return overridable.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Property newConfig) {
          ChangesRequiringRestart changes = new ChangesRequiringRestart("property");
          return changes;
        }

        private static InnerNodeVector<Property> createVector(List<Builder> builders) {
            List<Property> elems = new ArrayList<>();
            for (Builder b : builders) {
                elems.add(new Property(b));
            }
            return new InnerNodeVector<Property>(elems);
        }
      }

      /**
       * This class represents query-profiles.queryprofile[].queryprofilevariant[].reference[]
       */
      public final static class Reference extends InnerNode { 

        public static final class Builder implements ConfigBuilder {
          private Set<String> __uninitialized = new HashSet<String>(List.of(
            "name",
            "value"
            ));

          private String name = null;
          private String value = null;
          private String overridable = null;

          public Builder() { }

          public Builder(Reference config) {
            name(config.name());
            value(config.value());
            overridable(config.overridable());
          }

          private Builder override(Builder __superior) {
            if (__superior.name != null)
              name(__superior.name);
            if (__superior.value != null)
              value(__superior.value);
            if (__superior.overridable != null)
              overridable(__superior.overridable);
            return this;
          }

          public Builder name(String __value) {
          if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
            name = __value;
            __uninitialized.remove("name");
            return this;
          }


          public Builder value(String __value) {
          if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
            value = __value;
            __uninitialized.remove("value");
            return this;
          }


          public Builder overridable(String __value) {
          if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
            overridable = __value;
            return this;
          }


          public Reference build() {
            return new Reference(this);
          }

        }

        // Content of profile variant
        private final StringNode name;
        // Content of profile variant
        private final StringNode value;
        // Whether this reference is overridable: "true", "false" or ""
        private final StringNode overridable;

        public Reference(Builder builder) {
          this(builder, true);
        }

        private Reference(Builder builder, boolean throwIfUninitialized) {
          if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
            throw new IllegalArgumentException("The following builder parameters for " +
                "query-profiles.queryprofile[].queryprofilevariant[].reference[] must be initialized: " + builder.__uninitialized);

          name = (builder.name == null) ?
              new StringNode() : new StringNode(builder.name);
          value = (builder.value == null) ?
              new StringNode() : new StringNode(builder.value);
          overridable = (builder.overridable == null) ?
              new StringNode("") : new StringNode(builder.overridable);
        }

        /**
         * @return query-profiles.queryprofile[].queryprofilevariant[].reference[].name
         */
        public String name() {
          return name.value();
        }

        /**
         * @return query-profiles.queryprofile[].queryprofilevariant[].reference[].value
         */
        public String value() {
          return value.value();
        }

        /**
         * @return query-profiles.queryprofile[].queryprofilevariant[].reference[].overridable
         */
        public String overridable() {
          return overridable.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Reference newConfig) {
          ChangesRequiringRestart changes = new ChangesRequiringRestart("reference");
          return changes;
        }

        private static InnerNodeVector<Reference> createVector(List<Builder> builders) {
            List<Reference> elems = new ArrayList<>();
            for (Builder b : builders) {
                elems.add(new Reference(b));
            }
            return new InnerNodeVector<Reference>(elems);
        }
      }
    }
  }

  /**
   * This class represents query-profiles.queryprofiletype[]
   */
  public final static class Queryprofiletype extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>(List.of(
        "id"
        ));

      private String id = null;
      private Boolean strict = null;
      private Boolean matchaspath = null;
      public List<String> inherit = new ArrayList<>();
      public List<Field.Builder> field = new ArrayList<>();

      public Builder() { }

      public Builder(Queryprofiletype config) {
        id(config.id());
        strict(config.strict());
        matchaspath(config.matchaspath());
        inherit(config.inherit());
        for (Field f : config.field()) {
          field(new Field.Builder(f));
        }
      }

      private Builder override(Builder __superior) {
        if (__superior.id != null)
          id(__superior.id);
        if (__superior.strict != null)
          strict(__superior.strict);
        if (__superior.matchaspath != null)
          matchaspath(__superior.matchaspath);
        if (!__superior.inherit.isEmpty())
          inherit.addAll(__superior.inherit);
        if (!__superior.field.isEmpty())
          field.addAll(__superior.field);
        return this;
      }

      public Builder id(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        id = __value;
        __uninitialized.remove("id");
        return this;
      }


      public Builder strict(boolean __value) {
        strict = __value;
        return this;
      }

      private Builder strict(String __value) {
        return strict(Boolean.valueOf(__value));
      }

      public Builder matchaspath(boolean __value) {
        matchaspath = __value;
        return this;
      }

      private Builder matchaspath(String __value) {
        return matchaspath(Boolean.valueOf(__value));
      }

      public Builder inherit(String __value) {
        inherit.add(__value);
        return this;
      }

      public Builder inherit(Collection<String> __values) {
        inherit.addAll(__values);
        return this;
      }

      /**
       * Add the given builder to this builder's list of Field builders
       * @param __builder a builder
       * @return this builder
       */
      public Builder field(Field.Builder __builder) {
        field.add(__builder);
        return this;
      }

      /**
       * Make a new builder and run the supplied function on it before adding it to the list
       * @param __func lambda that modifies the given builder
       * @return this builder
       */
      public Builder field(java.util.function.Consumer<Field.Builder> __func) {
        Field.Builder __inner = new Field.Builder();
        __func.accept(__inner);
        field.add(__inner);
        return this;
      }

      /**
       * Set the given list as this builder's list of Field builders
       * @param __builders a list of builders
       * @return this builder
       */
      public Builder field(List<Field.Builder> __builders) {
        field = __builders;
        return this;
      }

      public Queryprofiletype build() {
        return new Queryprofiletype(this);
      }

    }

    // A query profile type defines the values of instance query profiles.
    // The id follows the same rules as for query profiles
    private final StringNode id;
    // If this is strict, non-declared values can not be set in a query profile of this type nor
    // in the request or by a programmatic call
    private final BooleanNode strict;
    // With this set to true, requests for query profile instances of this type will be matched as path names
    private final BooleanNode matchaspath;
    // The optional list of query profile types this inherits, by id.
    // The id's has the form name(:version)?
    // where the version has the form 1(.2(.3(.identifier)?)?)?.
    // If the version is not specified the newest version found is used.
    private final LeafNodeVector<String, StringNode> inherit;
    private final InnerNodeVector<Field> field;

    public Queryprofiletype(Builder builder) {
      this(builder, true);
    }

    private Queryprofiletype(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "query-profiles.queryprofiletype[] must be initialized: " + builder.__uninitialized);

      id = (builder.id == null) ?
          new StringNode() : new StringNode(builder.id);
      strict = (builder.strict == null) ?
          new BooleanNode(false) : new BooleanNode(builder.strict);
      matchaspath = (builder.matchaspath == null) ?
          new BooleanNode(false) : new BooleanNode(builder.matchaspath);
      inherit = new LeafNodeVector<>(builder.inherit, new StringNode());
      field = Field.createVector(builder.field);
    }

    /**
     * @return query-profiles.queryprofiletype[].id
     */
    public String id() {
      return id.value();
    }

    /**
     * @return query-profiles.queryprofiletype[].strict
     */
    public boolean strict() {
      return strict.value();
    }

    /**
     * @return query-profiles.queryprofiletype[].matchaspath
     */
    public boolean matchaspath() {
      return matchaspath.value();
    }

    /**
     * @return query-profiles.queryprofiletype[].inherit[]
     */
    public List<String> inherit() {
      return inherit.asList();
    }

    /**
     * @param i the index of the value to return
     * @return query-profiles.queryprofiletype[].inherit[]
     */
    public String inherit(int i) {
      return inherit.get(i).value();
    }

    /**
     * @return query-profiles.queryprofiletype[].field[]
     */
    public List<Field> field() {
      return field;
    }

    /**
     * @param i the index of the value to return
     * @return query-profiles.queryprofiletype[].field[]
     */
    public Field field(int i) {
      return field.get(i);
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Queryprofiletype newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("queryprofiletype");
      return changes;
    }

    private static InnerNodeVector<Queryprofiletype> createVector(List<Builder> builders) {
        List<Queryprofiletype> elems = new ArrayList<>();
        for (Builder b : builders) {
            elems.add(new Queryprofiletype(b));
        }
        return new InnerNodeVector<Queryprofiletype>(elems);
    }

    /**
     * This class represents query-profiles.queryprofiletype[].field[]
     */
    public final static class Field extends InnerNode { 

      public static final class Builder implements ConfigBuilder {
        private Set<String> __uninitialized = new HashSet<String>(List.of(
          "name",
          "type"
          ));

        private String name = null;
        private String type = null;
        private Boolean overridable = null;
        private Boolean mandatory = null;
        private String alias = null;

        public Builder() { }

        public Builder(Field config) {
          name(config.name());
          type(config.type());
          overridable(config.overridable());
          mandatory(config.mandatory());
          alias(config.alias());
        }

        private Builder override(Builder __superior) {
          if (__superior.name != null)
            name(__superior.name);
          if (__superior.type != null)
            type(__superior.type);
          if (__superior.overridable != null)
            overridable(__superior.overridable);
          if (__superior.mandatory != null)
            mandatory(__superior.mandatory);
          if (__superior.alias != null)
            alias(__superior.alias);
          return this;
        }

        public Builder name(String __value) {
        if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
          name = __value;
          __uninitialized.remove("name");
          return this;
        }


        public Builder type(String __value) {
        if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
          type = __value;
          __uninitialized.remove("type");
          return this;
        }


        public Builder overridable(boolean __value) {
          overridable = __value;
          return this;
        }

        private Builder overridable(String __value) {
          return overridable(Boolean.valueOf(__value));
        }

        public Builder mandatory(boolean __value) {
          mandatory = __value;
          return this;
        }

        private Builder mandatory(String __value) {
          return mandatory(Boolean.valueOf(__value));
        }

        public Builder alias(String __value) {
        if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
          alias = __value;
          return this;
        }


        public Field build() {
          return new Field(this);
        }

      }

      // Declaration of a field
      private final StringNode name;
      // The type of the field, a primitive, query-profile or query-profile:id to declare a reference
      // which is untyped or typed, respectively
      private final StringNode type;
      // Whether values of this is overridable in the request or by a programmatic setting
      private final BooleanNode overridable;
      // Whether this must be present in the query profile or the request for this to be valid
      private final BooleanNode mandatory;
      // A space-separated list of aliases of this field name. Aliases are case insensitive
      private final StringNode alias;

      public Field(Builder builder) {
        this(builder, true);
      }

      private Field(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
          throw new IllegalArgumentException("The following builder parameters for " +
              "query-profiles.queryprofiletype[].field[] must be initialized: " + builder.__uninitialized);

        name = (builder.name == null) ?
            new StringNode() : new StringNode(builder.name);
        type = (builder.type == null) ?
            new StringNode() : new StringNode(builder.type);
        overridable = (builder.overridable == null) ?
            new BooleanNode(true) : new BooleanNode(builder.overridable);
        mandatory = (builder.mandatory == null) ?
            new BooleanNode(false) : new BooleanNode(builder.mandatory);
        alias = (builder.alias == null) ?
            new StringNode("") : new StringNode(builder.alias);
      }

      /**
       * @return query-profiles.queryprofiletype[].field[].name
       */
      public String name() {
        return name.value();
      }

      /**
       * @return query-profiles.queryprofiletype[].field[].type
       */
      public String type() {
        return type.value();
      }

      /**
       * @return query-profiles.queryprofiletype[].field[].overridable
       */
      public boolean overridable() {
        return overridable.value();
      }

      /**
       * @return query-profiles.queryprofiletype[].field[].mandatory
       */
      public boolean mandatory() {
        return mandatory.value();
      }

      /**
       * @return query-profiles.queryprofiletype[].field[].alias
       */
      public String alias() {
        return alias.value();
      }

      private ChangesRequiringRestart getChangesRequiringRestart(Field newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart("field");
        return changes;
      }

      private static InnerNodeVector<Field> createVector(List<Builder> builders) {
          List<Field> elems = new ArrayList<>();
          for (Builder b : builders) {
              elems.add(new Field(b));
          }
          return new InnerNodeVector<Field>(elems);
      }
    }
  }

}
