// ------------   D O   N O T   E D I T !   ------------
// This file is generated from a config definition file.

package com.yahoo.search.pagetemplates;

import java.util.*;
import java.io.File;
import java.nio.file.Path;
import com.yahoo.config.*;

/**
 * This class represents the root node of page-templates
 *
 * Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
 */
public final class PageTemplatesConfig extends ConfigInstance {

  public final static String CONFIG_DEF_MD5 = "54a3f1cc4d2bf8872e341ac9426899db";
  public final static String CONFIG_DEF_NAME = "page-templates";
  public final static String CONFIG_DEF_NAMESPACE = "search.pagetemplates";
  public final static String[] CONFIG_DEF_SCHEMA = {
    "namespace=search.pagetemplates",
    "page[] string"
  };

  public static String getDefMd5()       { return CONFIG_DEF_MD5; }
  public static String getDefName()      { return CONFIG_DEF_NAME; }
  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

  public interface Producer extends ConfigInstance.Producer {
    void getConfig(Builder builder);
  }

  public static final class Builder implements ConfigInstance.Builder {
    private Set<String> __uninitialized = new HashSet<String>();

    public List<String> page = new ArrayList<>();

    public Builder() { }

    public Builder(PageTemplatesConfig config) {
      page(config.page());
    }

    private Builder override(Builder __superior) {
      if (!__superior.page.isEmpty())
        page.addAll(__superior.page);
      return this;
    }

    public Builder page(String __value) {
      page.add(__value);
      return this;
    }

    public Builder page(Collection<String> __values) {
      page.addAll(__values);
      return this;
    }

    private boolean _applyOnRestart = false;

    @java.lang.Override
    public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
      if (producer instanceof Producer) {
        ((Producer)producer).getConfig(this);
        return true;
      }
      return false;
    }

    @java.lang.Override
    public final String getDefMd5() { return CONFIG_DEF_MD5; }

    @java.lang.Override
    public final String getDefName() { return CONFIG_DEF_NAME; }

    @java.lang.Override
    public final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

    @java.lang.Override
    public final boolean getApplyOnRestart() { return _applyOnRestart; }

    @java.lang.Override
    public final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }

    public PageTemplatesConfig build() {
      return new PageTemplatesConfig(this);
    }

  }

  // The xml content of a page template
  private final LeafNodeVector<String, StringNode> page;

  public PageTemplatesConfig(Builder builder) {
    this(builder, true);
  }

  private PageTemplatesConfig(Builder builder, boolean throwIfUninitialized) {
    if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
      throw new IllegalArgumentException("The following builder parameters for " +
          "page-templates must be initialized: " + builder.__uninitialized);

    page = new LeafNodeVector<>(builder.page, new StringNode());
  }

  /**
   * @return page-templates.page[]
   */
  public List<String> page() {
    return page.asList();
  }

  /**
   * @param i the index of the value to return
   * @return page-templates.page[]
   */
  public String page(int i) {
    return page.get(i).value();
  }

  private ChangesRequiringRestart getChangesRequiringRestart(PageTemplatesConfig newConfig) {
    ChangesRequiringRestart changes = new ChangesRequiringRestart("page-templates");
    return changes;
  }

  private static boolean containsFieldsFlaggedWithRestart() {
    return false;
  }


}
