// ------------   D O   N O T   E D I T !   ------------
// This file is generated from a config definition file.

package com.yahoo.search.federation;

import java.util.*;
import java.io.File;
import java.nio.file.Path;
import com.yahoo.config.*;

/**
 * This class represents the root node of federation
 *
 * Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
 */
public final class FederationConfig extends ConfigInstance {

  public final static String CONFIG_DEF_MD5 = "0cea5264da0cb851f0ea85d9477a6724";
  public final static String CONFIG_DEF_NAME = "federation";
  public final static String CONFIG_DEF_NAMESPACE = "search.federation";
  public final static String[] CONFIG_DEF_SCHEMA = {
    "namespace=search.federation",
    "target[].id string",
    "target[].useByDefault bool default=false",
    "target[].searchChain[].searchChainId string",
    "target[].searchChain[].timeoutMillis int default=-1",
    "target[].searchChain[].requestTimeoutMillis int default=-1",
    "target[].searchChain[].optional bool default=false",
    "target[].searchChain[].useByDefault bool default=false",
    "target[].searchChain[].providerId string default=\"\"",
    "target[].searchChain[].documentTypes[] string",
    "targetSelector string default=\"\""
  };

  public static String getDefMd5()       { return CONFIG_DEF_MD5; }
  public static String getDefName()      { return CONFIG_DEF_NAME; }
  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

  public interface Producer extends ConfigInstance.Producer {
    void getConfig(Builder builder);
  }

  public static final class Builder implements ConfigInstance.Builder {
    private Set<String> __uninitialized = new HashSet<String>();

    public List<Target.Builder> target = new ArrayList<>();
    private String targetSelector = null;

    public Builder() { }

    public Builder(FederationConfig config) {
      for (Target t : config.target()) {
        target(new Target.Builder(t));
      }
      targetSelector(config.targetSelector());
    }

    private Builder override(Builder __superior) {
      if (!__superior.target.isEmpty())
        target.addAll(__superior.target);
      if (__superior.targetSelector != null)
        targetSelector(__superior.targetSelector);
      return this;
    }

    /**
     * Add the given builder to this builder's list of Target builders
     * @param __builder a builder
     * @return this builder
     */
    public Builder target(Target.Builder __builder) {
      target.add(__builder);
      return this;
    }

    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder target(java.util.function.Consumer<Target.Builder> __func) {
      Target.Builder __inner = new Target.Builder();
      __func.accept(__inner);
      target.add(__inner);
      return this;
    }

    /**
     * Set the given list as this builder's list of Target builders
     * @param __builders a list of builders
     * @return this builder
     */
    public Builder target(List<Target.Builder> __builders) {
      target = __builders;
      return this;
    }

    public Builder targetSelector(String __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      targetSelector = __value;
      return this;
    }


    private boolean _applyOnRestart = false;

    @java.lang.Override
    public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
      if (producer instanceof Producer) {
        ((Producer)producer).getConfig(this);
        return true;
      }
      return false;
    }

    @java.lang.Override
    public final String getDefMd5() { return CONFIG_DEF_MD5; }

    @java.lang.Override
    public final String getDefName() { return CONFIG_DEF_NAME; }

    @java.lang.Override
    public final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

    @java.lang.Override
    public final boolean getApplyOnRestart() { return _applyOnRestart; }

    @java.lang.Override
    public final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }

    public FederationConfig build() {
      return new FederationConfig(this);
    }

  }

  private final InnerNodeVector<Target> target;
  private final StringNode targetSelector;

  public FederationConfig(Builder builder) {
    this(builder, true);
  }

  private FederationConfig(Builder builder, boolean throwIfUninitialized) {
    if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
      throw new IllegalArgumentException("The following builder parameters for " +
          "federation must be initialized: " + builder.__uninitialized);

    target = Target.createVector(builder.target);
    targetSelector = (builder.targetSelector == null) ?
        new StringNode("") : new StringNode(builder.targetSelector);
  }

  /**
   * @return federation.target[]
   */
  public List<Target> target() {
    return target;
  }

  /**
   * @param i the index of the value to return
   * @return federation.target[]
   */
  public Target target(int i) {
    return target.get(i);
  }

  /**
   * @return federation.targetSelector
   */
  public String targetSelector() {
    return targetSelector.value();
  }

  private ChangesRequiringRestart getChangesRequiringRestart(FederationConfig newConfig) {
    ChangesRequiringRestart changes = new ChangesRequiringRestart("federation");
    return changes;
  }

  private static boolean containsFieldsFlaggedWithRestart() {
    return false;
  }

  /**
   * This class represents federation.target[]
   */
  public final static class Target extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>(List.of(
        "id"
        ));

      private String id = null;
      private Boolean useByDefault = null;
      public List<SearchChain.Builder> searchChain = new ArrayList<>();

      public Builder() { }

      public Builder(Target config) {
        id(config.id());
        useByDefault(config.useByDefault());
        for (SearchChain s : config.searchChain()) {
          searchChain(new SearchChain.Builder(s));
        }
      }

      private Builder override(Builder __superior) {
        if (__superior.id != null)
          id(__superior.id);
        if (__superior.useByDefault != null)
          useByDefault(__superior.useByDefault);
        if (!__superior.searchChain.isEmpty())
          searchChain.addAll(__superior.searchChain);
        return this;
      }

      public Builder id(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        id = __value;
        __uninitialized.remove("id");
        return this;
      }


      public Builder useByDefault(boolean __value) {
        useByDefault = __value;
        return this;
      }

      private Builder useByDefault(String __value) {
        return useByDefault(Boolean.valueOf(__value));
      }

      /**
       * Add the given builder to this builder's list of SearchChain builders
       * @param __builder a builder
       * @return this builder
       */
      public Builder searchChain(SearchChain.Builder __builder) {
        searchChain.add(__builder);
        return this;
      }

      /**
       * Make a new builder and run the supplied function on it before adding it to the list
       * @param __func lambda that modifies the given builder
       * @return this builder
       */
      public Builder searchChain(java.util.function.Consumer<SearchChain.Builder> __func) {
        SearchChain.Builder __inner = new SearchChain.Builder();
        __func.accept(__inner);
        searchChain.add(__inner);
        return this;
      }

      /**
       * Set the given list as this builder's list of SearchChain builders
       * @param __builders a list of builders
       * @return this builder
       */
      public Builder searchChain(List<SearchChain.Builder> __builders) {
        searchChain = __builders;
        return this;
      }

      public Target build() {
        return new Target(this);
      }

    }

    private final StringNode id;
    private final BooleanNode useByDefault;
    private final InnerNodeVector<SearchChain> searchChain;

    public Target(Builder builder) {
      this(builder, true);
    }

    private Target(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "federation.target[] must be initialized: " + builder.__uninitialized);

      id = (builder.id == null) ?
          new StringNode() : new StringNode(builder.id);
      useByDefault = (builder.useByDefault == null) ?
          new BooleanNode(false) : new BooleanNode(builder.useByDefault);
      searchChain = SearchChain.createVector(builder.searchChain);
    }

    /**
     * @return federation.target[].id
     */
    public String id() {
      return id.value();
    }

    /**
     * @return federation.target[].useByDefault
     */
    public boolean useByDefault() {
      return useByDefault.value();
    }

    /**
     * @return federation.target[].searchChain[]
     */
    public List<SearchChain> searchChain() {
      return searchChain;
    }

    /**
     * @param i the index of the value to return
     * @return federation.target[].searchChain[]
     */
    public SearchChain searchChain(int i) {
      return searchChain.get(i);
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Target newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("target");
      return changes;
    }

    private static InnerNodeVector<Target> createVector(List<Builder> builders) {
        List<Target> elems = new ArrayList<>();
        for (Builder b : builders) {
            elems.add(new Target(b));
        }
        return new InnerNodeVector<Target>(elems);
    }

    /**
     * This class represents federation.target[].searchChain[]
     */
    public final static class SearchChain extends InnerNode { 

      public static final class Builder implements ConfigBuilder {
        private Set<String> __uninitialized = new HashSet<String>(List.of(
          "searchChainId"
          ));

        private String searchChainId = null;
        private Integer timeoutMillis = null;
        private Integer requestTimeoutMillis = null;
        private Boolean optional = null;
        private Boolean useByDefault = null;
        private String providerId = null;
        public List<String> documentTypes = new ArrayList<>();

        public Builder() { }

        public Builder(SearchChain config) {
          searchChainId(config.searchChainId());
          timeoutMillis(config.timeoutMillis());
          requestTimeoutMillis(config.requestTimeoutMillis());
          optional(config.optional());
          useByDefault(config.useByDefault());
          providerId(config.providerId());
          documentTypes(config.documentTypes());
        }

        private Builder override(Builder __superior) {
          if (__superior.searchChainId != null)
            searchChainId(__superior.searchChainId);
          if (__superior.timeoutMillis != null)
            timeoutMillis(__superior.timeoutMillis);
          if (__superior.requestTimeoutMillis != null)
            requestTimeoutMillis(__superior.requestTimeoutMillis);
          if (__superior.optional != null)
            optional(__superior.optional);
          if (__superior.useByDefault != null)
            useByDefault(__superior.useByDefault);
          if (__superior.providerId != null)
            providerId(__superior.providerId);
          if (!__superior.documentTypes.isEmpty())
            documentTypes.addAll(__superior.documentTypes);
          return this;
        }

        public Builder searchChainId(String __value) {
        if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
          searchChainId = __value;
          __uninitialized.remove("searchChainId");
          return this;
        }


        public Builder timeoutMillis(int __value) {
          timeoutMillis = __value;
          return this;
        }

        private Builder timeoutMillis(String __value) {
          return timeoutMillis(Integer.valueOf(__value));
        }

        public Builder requestTimeoutMillis(int __value) {
          requestTimeoutMillis = __value;
          return this;
        }

        private Builder requestTimeoutMillis(String __value) {
          return requestTimeoutMillis(Integer.valueOf(__value));
        }

        public Builder optional(boolean __value) {
          optional = __value;
          return this;
        }

        private Builder optional(String __value) {
          return optional(Boolean.valueOf(__value));
        }

        public Builder useByDefault(boolean __value) {
          useByDefault = __value;
          return this;
        }

        private Builder useByDefault(String __value) {
          return useByDefault(Boolean.valueOf(__value));
        }

        public Builder providerId(String __value) {
        if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
          providerId = __value;
          return this;
        }


        public Builder documentTypes(String __value) {
          documentTypes.add(__value);
          return this;
        }

        public Builder documentTypes(Collection<String> __values) {
          documentTypes.addAll(__values);
          return this;
        }

        public SearchChain build() {
          return new SearchChain(this);
        }

      }

      // the component id of the chain used for federation.
      private final StringNode searchChainId;
      private final IntegerNode timeoutMillis;
      private final IntegerNode requestTimeoutMillis;
      private final BooleanNode optional;
      private final BooleanNode useByDefault;
      // if non-empty, this is a provider for the source target[].name
      private final StringNode providerId;
      private final LeafNodeVector<String, StringNode> documentTypes;

      public SearchChain(Builder builder) {
        this(builder, true);
      }

      private SearchChain(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
          throw new IllegalArgumentException("The following builder parameters for " +
              "federation.target[].searchChain[] must be initialized: " + builder.__uninitialized);

        searchChainId = (builder.searchChainId == null) ?
            new StringNode() : new StringNode(builder.searchChainId);
        timeoutMillis = (builder.timeoutMillis == null) ?
            new IntegerNode(-1) : new IntegerNode(builder.timeoutMillis);
        requestTimeoutMillis = (builder.requestTimeoutMillis == null) ?
            new IntegerNode(-1) : new IntegerNode(builder.requestTimeoutMillis);
        optional = (builder.optional == null) ?
            new BooleanNode(false) : new BooleanNode(builder.optional);
        useByDefault = (builder.useByDefault == null) ?
            new BooleanNode(false) : new BooleanNode(builder.useByDefault);
        providerId = (builder.providerId == null) ?
            new StringNode("") : new StringNode(builder.providerId);
        documentTypes = new LeafNodeVector<>(builder.documentTypes, new StringNode());
      }

      /**
       * @return federation.target[].searchChain[].searchChainId
       */
      public String searchChainId() {
        return searchChainId.value();
      }

      /**
       * @return federation.target[].searchChain[].timeoutMillis
       */
      public int timeoutMillis() {
        return timeoutMillis.value();
      }

      /**
       * @return federation.target[].searchChain[].requestTimeoutMillis
       */
      public int requestTimeoutMillis() {
        return requestTimeoutMillis.value();
      }

      /**
       * @return federation.target[].searchChain[].optional
       */
      public boolean optional() {
        return optional.value();
      }

      /**
       * @return federation.target[].searchChain[].useByDefault
       */
      public boolean useByDefault() {
        return useByDefault.value();
      }

      /**
       * @return federation.target[].searchChain[].providerId
       */
      public String providerId() {
        return providerId.value();
      }

      /**
       * @return federation.target[].searchChain[].documentTypes[]
       */
      public List<String> documentTypes() {
        return documentTypes.asList();
      }

      /**
       * @param i the index of the value to return
       * @return federation.target[].searchChain[].documentTypes[]
       */
      public String documentTypes(int i) {
        return documentTypes.get(i).value();
      }

      private ChangesRequiringRestart getChangesRequiringRestart(SearchChain newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart("searchChain");
        return changes;
      }

      private static InnerNodeVector<SearchChain> createVector(List<Builder> builders) {
          List<SearchChain> elems = new ArrayList<>();
          for (Builder b : builders) {
              elems.add(new SearchChain(b));
          }
          return new InnerNodeVector<SearchChain>(elems);
      }
    }
  }

}
