// ------------   D O   N O T   E D I T !   ------------
// This file is generated from a config definition file.

package com.yahoo.search.config;

import java.util.*;
import java.io.File;
import java.nio.file.Path;
import com.yahoo.config.*;

/**
 * This class represents the root node of schema-info
 *
 * Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
 */
public final class SchemaInfoConfig extends ConfigInstance {

  public final static String CONFIG_DEF_MD5 = "a28f8cd394b0692601cd7cefab46e421";
  public final static String CONFIG_DEF_NAME = "schema-info";
  public final static String CONFIG_DEF_NAMESPACE = "search.config";
  public final static String[] CONFIG_DEF_SCHEMA = {
    "namespace=search.config",
    "schema[].name string",
    "schema[].field[].name string",
    "schema[].field[].type string",
    "schema[].field[].alias[] string",
    "schema[].field[].attribute bool",
    "schema[].field[].index bool",
    "schema[].field[].bitPacked bool",
    "schema[].fieldset[].name string",
    "schema[].fieldset[].field[] string",
    "schema[].summaryclass[].name string",
    "schema[].summaryclass[].fields[].name string",
    "schema[].summaryclass[].fields[].type string",
    "schema[].summaryclass[].fields[].dynamic bool default=false",
    "schema[].rankprofile[].name string",
    "schema[].rankprofile[].hasSummaryFeatures bool default=true",
    "schema[].rankprofile[].hasRankFeatures bool default=true",
    "schema[].rankprofile[].significance.useModel bool default=false",
    "schema[].rankprofile[].input[].name string",
    "schema[].rankprofile[].input[].type string"
  };

  public static String getDefMd5()       { return CONFIG_DEF_MD5; }
  public static String getDefName()      { return CONFIG_DEF_NAME; }
  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

  public interface Producer extends ConfigInstance.Producer {
    void getConfig(Builder builder);
  }

  public static final class Builder implements ConfigInstance.Builder {
    private Set<String> __uninitialized = new HashSet<String>();

    public List<Schema.Builder> schema = new ArrayList<>();

    public Builder() { }

    public Builder(SchemaInfoConfig config) {
      for (Schema s : config.schema()) {
        schema(new Schema.Builder(s));
      }
    }

    private Builder override(Builder __superior) {
      if (!__superior.schema.isEmpty())
        schema.addAll(__superior.schema);
      return this;
    }

    /**
     * Add the given builder to this builder's list of Schema builders
     * @param __builder a builder
     * @return this builder
     */
    public Builder schema(Schema.Builder __builder) {
      schema.add(__builder);
      return this;
    }

    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder schema(java.util.function.Consumer<Schema.Builder> __func) {
      Schema.Builder __inner = new Schema.Builder();
      __func.accept(__inner);
      schema.add(__inner);
      return this;
    }

    /**
     * Set the given list as this builder's list of Schema builders
     * @param __builders a list of builders
     * @return this builder
     */
    public Builder schema(List<Schema.Builder> __builders) {
      schema = __builders;
      return this;
    }

    private boolean _applyOnRestart = false;

    @java.lang.Override
    public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
      if (producer instanceof Producer) {
        ((Producer)producer).getConfig(this);
        return true;
      }
      return false;
    }

    @java.lang.Override
    public final String getDefMd5() { return CONFIG_DEF_MD5; }

    @java.lang.Override
    public final String getDefName() { return CONFIG_DEF_NAME; }

    @java.lang.Override
    public final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

    @java.lang.Override
    public final boolean getApplyOnRestart() { return _applyOnRestart; }

    @java.lang.Override
    public final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }

    public SchemaInfoConfig build() {
      return new SchemaInfoConfig(this);
    }

  }

  private final InnerNodeVector<Schema> schema;

  public SchemaInfoConfig(Builder builder) {
    this(builder, true);
  }

  private SchemaInfoConfig(Builder builder, boolean throwIfUninitialized) {
    if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
      throw new IllegalArgumentException("The following builder parameters for " +
          "schema-info must be initialized: " + builder.__uninitialized);

    schema = Schema.createVector(builder.schema);
  }

  /**
   * @return schema-info.schema[]
   */
  public List<Schema> schema() {
    return schema;
  }

  /**
   * @param i the index of the value to return
   * @return schema-info.schema[]
   */
  public Schema schema(int i) {
    return schema.get(i);
  }

  private ChangesRequiringRestart getChangesRequiringRestart(SchemaInfoConfig newConfig) {
    ChangesRequiringRestart changes = new ChangesRequiringRestart("schema-info");
    return changes;
  }

  private static boolean containsFieldsFlaggedWithRestart() {
    return false;
  }

  /**
   * This class represents schema-info.schema[]
   */
  public final static class Schema extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>(List.of(
        "name"
        ));

      private String name = null;
      public List<Field.Builder> field = new ArrayList<>();
      public List<Fieldset.Builder> fieldset = new ArrayList<>();
      public List<Summaryclass.Builder> summaryclass = new ArrayList<>();
      public List<Rankprofile.Builder> rankprofile = new ArrayList<>();

      public Builder() { }

      public Builder(Schema config) {
        name(config.name());
        for (Field f : config.field()) {
          field(new Field.Builder(f));
        }
        for (Fieldset f : config.fieldset()) {
          fieldset(new Fieldset.Builder(f));
        }
        for (Summaryclass s : config.summaryclass()) {
          summaryclass(new Summaryclass.Builder(s));
        }
        for (Rankprofile r : config.rankprofile()) {
          rankprofile(new Rankprofile.Builder(r));
        }
      }

      private Builder override(Builder __superior) {
        if (__superior.name != null)
          name(__superior.name);
        if (!__superior.field.isEmpty())
          field.addAll(__superior.field);
        if (!__superior.fieldset.isEmpty())
          fieldset.addAll(__superior.fieldset);
        if (!__superior.summaryclass.isEmpty())
          summaryclass.addAll(__superior.summaryclass);
        if (!__superior.rankprofile.isEmpty())
          rankprofile.addAll(__superior.rankprofile);
        return this;
      }

      public Builder name(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        name = __value;
        __uninitialized.remove("name");
        return this;
      }


      /**
       * Add the given builder to this builder's list of Field builders
       * @param __builder a builder
       * @return this builder
       */
      public Builder field(Field.Builder __builder) {
        field.add(__builder);
        return this;
      }

      /**
       * Make a new builder and run the supplied function on it before adding it to the list
       * @param __func lambda that modifies the given builder
       * @return this builder
       */
      public Builder field(java.util.function.Consumer<Field.Builder> __func) {
        Field.Builder __inner = new Field.Builder();
        __func.accept(__inner);
        field.add(__inner);
        return this;
      }

      /**
       * Set the given list as this builder's list of Field builders
       * @param __builders a list of builders
       * @return this builder
       */
      public Builder field(List<Field.Builder> __builders) {
        field = __builders;
        return this;
      }

      /**
       * Add the given builder to this builder's list of Fieldset builders
       * @param __builder a builder
       * @return this builder
       */
      public Builder fieldset(Fieldset.Builder __builder) {
        fieldset.add(__builder);
        return this;
      }

      /**
       * Make a new builder and run the supplied function on it before adding it to the list
       * @param __func lambda that modifies the given builder
       * @return this builder
       */
      public Builder fieldset(java.util.function.Consumer<Fieldset.Builder> __func) {
        Fieldset.Builder __inner = new Fieldset.Builder();
        __func.accept(__inner);
        fieldset.add(__inner);
        return this;
      }

      /**
       * Set the given list as this builder's list of Fieldset builders
       * @param __builders a list of builders
       * @return this builder
       */
      public Builder fieldset(List<Fieldset.Builder> __builders) {
        fieldset = __builders;
        return this;
      }

      /**
       * Add the given builder to this builder's list of Summaryclass builders
       * @param __builder a builder
       * @return this builder
       */
      public Builder summaryclass(Summaryclass.Builder __builder) {
        summaryclass.add(__builder);
        return this;
      }

      /**
       * Make a new builder and run the supplied function on it before adding it to the list
       * @param __func lambda that modifies the given builder
       * @return this builder
       */
      public Builder summaryclass(java.util.function.Consumer<Summaryclass.Builder> __func) {
        Summaryclass.Builder __inner = new Summaryclass.Builder();
        __func.accept(__inner);
        summaryclass.add(__inner);
        return this;
      }

      /**
       * Set the given list as this builder's list of Summaryclass builders
       * @param __builders a list of builders
       * @return this builder
       */
      public Builder summaryclass(List<Summaryclass.Builder> __builders) {
        summaryclass = __builders;
        return this;
      }

      /**
       * Add the given builder to this builder's list of Rankprofile builders
       * @param __builder a builder
       * @return this builder
       */
      public Builder rankprofile(Rankprofile.Builder __builder) {
        rankprofile.add(__builder);
        return this;
      }

      /**
       * Make a new builder and run the supplied function on it before adding it to the list
       * @param __func lambda that modifies the given builder
       * @return this builder
       */
      public Builder rankprofile(java.util.function.Consumer<Rankprofile.Builder> __func) {
        Rankprofile.Builder __inner = new Rankprofile.Builder();
        __func.accept(__inner);
        rankprofile.add(__inner);
        return this;
      }

      /**
       * Set the given list as this builder's list of Rankprofile builders
       * @param __builders a list of builders
       * @return this builder
       */
      public Builder rankprofile(List<Rankprofile.Builder> __builders) {
        rankprofile = __builders;
        return this;
      }

      public Schema build() {
        return new Schema(this);
      }

    }

    // The name of this schema
    private final StringNode name;
    private final InnerNodeVector<Field> field;
    private final InnerNodeVector<Fieldset> fieldset;
    private final InnerNodeVector<Summaryclass> summaryclass;
    private final InnerNodeVector<Rankprofile> rankprofile;

    public Schema(Builder builder) {
      this(builder, true);
    }

    private Schema(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "schema-info.schema[] must be initialized: " + builder.__uninitialized);

      name = (builder.name == null) ?
          new StringNode() : new StringNode(builder.name);
      field = Field.createVector(builder.field);
      fieldset = Fieldset.createVector(builder.fieldset);
      summaryclass = Summaryclass.createVector(builder.summaryclass);
      rankprofile = Rankprofile.createVector(builder.rankprofile);
    }

    /**
     * @return schema-info.schema[].name
     */
    public String name() {
      return name.value();
    }

    /**
     * @return schema-info.schema[].field[]
     */
    public List<Field> field() {
      return field;
    }

    /**
     * @param i the index of the value to return
     * @return schema-info.schema[].field[]
     */
    public Field field(int i) {
      return field.get(i);
    }

    /**
     * @return schema-info.schema[].fieldset[]
     */
    public List<Fieldset> fieldset() {
      return fieldset;
    }

    /**
     * @param i the index of the value to return
     * @return schema-info.schema[].fieldset[]
     */
    public Fieldset fieldset(int i) {
      return fieldset.get(i);
    }

    /**
     * @return schema-info.schema[].summaryclass[]
     */
    public List<Summaryclass> summaryclass() {
      return summaryclass;
    }

    /**
     * @param i the index of the value to return
     * @return schema-info.schema[].summaryclass[]
     */
    public Summaryclass summaryclass(int i) {
      return summaryclass.get(i);
    }

    /**
     * @return schema-info.schema[].rankprofile[]
     */
    public List<Rankprofile> rankprofile() {
      return rankprofile;
    }

    /**
     * @param i the index of the value to return
     * @return schema-info.schema[].rankprofile[]
     */
    public Rankprofile rankprofile(int i) {
      return rankprofile.get(i);
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Schema newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("schema");
      return changes;
    }

    private static InnerNodeVector<Schema> createVector(List<Builder> builders) {
        List<Schema> elems = new ArrayList<>();
        for (Builder b : builders) {
            elems.add(new Schema(b));
        }
        return new InnerNodeVector<Schema>(elems);
    }

    /**
     * This class represents schema-info.schema[].field[]
     */
    public final static class Field extends InnerNode { 

      public static final class Builder implements ConfigBuilder {
        private Set<String> __uninitialized = new HashSet<String>(List.of(
          "name",
          "type",
          "attribute",
          "index",
          "bitPacked"
          ));

        private String name = null;
        private String type = null;
        public List<String> alias = new ArrayList<>();
        private Boolean attribute = null;
        private Boolean index = null;
        private Boolean bitPacked = null;

        public Builder() { }

        public Builder(Field config) {
          name(config.name());
          type(config.type());
          alias(config.alias());
          attribute(config.attribute());
          index(config.index());
          bitPacked(config.bitPacked());
        }

        private Builder override(Builder __superior) {
          if (__superior.name != null)
            name(__superior.name);
          if (__superior.type != null)
            type(__superior.type);
          if (!__superior.alias.isEmpty())
            alias.addAll(__superior.alias);
          if (__superior.attribute != null)
            attribute(__superior.attribute);
          if (__superior.index != null)
            index(__superior.index);
          if (__superior.bitPacked != null)
            bitPacked(__superior.bitPacked);
          return this;
        }

        public Builder name(String __value) {
        if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
          name = __value;
          __uninitialized.remove("name");
          return this;
        }


        public Builder type(String __value) {
        if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
          type = __value;
          __uninitialized.remove("type");
          return this;
        }


        public Builder alias(String __value) {
          alias.add(__value);
          return this;
        }

        public Builder alias(Collection<String> __values) {
          alias.addAll(__values);
          return this;
        }

        public Builder attribute(boolean __value) {
          attribute = __value;
          __uninitialized.remove("attribute");
          return this;
        }

        private Builder attribute(String __value) {
          return attribute(Boolean.valueOf(__value));
        }

        public Builder index(boolean __value) {
          index = __value;
          __uninitialized.remove("index");
          return this;
        }

        private Builder index(String __value) {
          return index(Boolean.valueOf(__value));
        }

        public Builder bitPacked(boolean __value) {
          bitPacked = __value;
          __uninitialized.remove("bitPacked");
          return this;
        }

        private Builder bitPacked(String __value) {
          return bitPacked(Boolean.valueOf(__value));
        }

        public Field build() {
          return new Field(this);
        }

      }

      // Information about a schema field (currently incomplete)
      private final StringNode name;
      private final StringNode type;
      private final LeafNodeVector<String, StringNode> alias;
      private final BooleanNode attribute;
      private final BooleanNode index;
      private final BooleanNode bitPacked;

      public Field(Builder builder) {
        this(builder, true);
      }

      private Field(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
          throw new IllegalArgumentException("The following builder parameters for " +
              "schema-info.schema[].field[] must be initialized: " + builder.__uninitialized);

        name = (builder.name == null) ?
            new StringNode() : new StringNode(builder.name);
        type = (builder.type == null) ?
            new StringNode() : new StringNode(builder.type);
        alias = new LeafNodeVector<>(builder.alias, new StringNode());
        attribute = (builder.attribute == null) ?
            new BooleanNode() : new BooleanNode(builder.attribute);
        index = (builder.index == null) ?
            new BooleanNode() : new BooleanNode(builder.index);
        bitPacked = (builder.bitPacked == null) ?
            new BooleanNode() : new BooleanNode(builder.bitPacked);
      }

      /**
       * @return schema-info.schema[].field[].name
       */
      public String name() {
        return name.value();
      }

      /**
       * @return schema-info.schema[].field[].type
       */
      public String type() {
        return type.value();
      }

      /**
       * @return schema-info.schema[].field[].alias[]
       */
      public List<String> alias() {
        return alias.asList();
      }

      /**
       * @param i the index of the value to return
       * @return schema-info.schema[].field[].alias[]
       */
      public String alias(int i) {
        return alias.get(i).value();
      }

      /**
       * @return schema-info.schema[].field[].attribute
       */
      public boolean attribute() {
        return attribute.value();
      }

      /**
       * @return schema-info.schema[].field[].index
       */
      public boolean index() {
        return index.value();
      }

      /**
       * @return schema-info.schema[].field[].bitPacked
       */
      public boolean bitPacked() {
        return bitPacked.value();
      }

      private ChangesRequiringRestart getChangesRequiringRestart(Field newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart("field");
        return changes;
      }

      private static InnerNodeVector<Field> createVector(List<Builder> builders) {
          List<Field> elems = new ArrayList<>();
          for (Builder b : builders) {
              elems.add(new Field(b));
          }
          return new InnerNodeVector<Field>(elems);
      }
    }

    /**
     * This class represents schema-info.schema[].fieldset[]
     */
    public final static class Fieldset extends InnerNode { 

      public static final class Builder implements ConfigBuilder {
        private Set<String> __uninitialized = new HashSet<String>(List.of(
          "name"
          ));

        private String name = null;
        public List<String> field = new ArrayList<>();

        public Builder() { }

        public Builder(Fieldset config) {
          name(config.name());
          field(config.field());
        }

        private Builder override(Builder __superior) {
          if (__superior.name != null)
            name(__superior.name);
          if (!__superior.field.isEmpty())
            field.addAll(__superior.field);
          return this;
        }

        public Builder name(String __value) {
        if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
          name = __value;
          __uninitialized.remove("name");
          return this;
        }


        public Builder field(String __value) {
          field.add(__value);
          return this;
        }

        public Builder field(Collection<String> __values) {
          field.addAll(__values);
          return this;
        }

        public Fieldset build() {
          return new Fieldset(this);
        }

      }

      // Field sets
      private final StringNode name;
      private final LeafNodeVector<String, StringNode> field;

      public Fieldset(Builder builder) {
        this(builder, true);
      }

      private Fieldset(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
          throw new IllegalArgumentException("The following builder parameters for " +
              "schema-info.schema[].fieldset[] must be initialized: " + builder.__uninitialized);

        name = (builder.name == null) ?
            new StringNode() : new StringNode(builder.name);
        field = new LeafNodeVector<>(builder.field, new StringNode());
      }

      /**
       * @return schema-info.schema[].fieldset[].name
       */
      public String name() {
        return name.value();
      }

      /**
       * @return schema-info.schema[].fieldset[].field[]
       */
      public List<String> field() {
        return field.asList();
      }

      /**
       * @param i the index of the value to return
       * @return schema-info.schema[].fieldset[].field[]
       */
      public String field(int i) {
        return field.get(i).value();
      }

      private ChangesRequiringRestart getChangesRequiringRestart(Fieldset newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart("fieldset");
        return changes;
      }

      private static InnerNodeVector<Fieldset> createVector(List<Builder> builders) {
          List<Fieldset> elems = new ArrayList<>();
          for (Builder b : builders) {
              elems.add(new Fieldset(b));
          }
          return new InnerNodeVector<Fieldset>(elems);
      }
    }

    /**
     * This class represents schema-info.schema[].summaryclass[]
     */
    public final static class Summaryclass extends InnerNode { 

      public static final class Builder implements ConfigBuilder {
        private Set<String> __uninitialized = new HashSet<String>(List.of(
          "name"
          ));

        private String name = null;
        public List<Fields.Builder> fields = new ArrayList<>();

        public Builder() { }

        public Builder(Summaryclass config) {
          name(config.name());
          for (Fields f : config.fields()) {
            fields(new Fields.Builder(f));
          }
        }

        private Builder override(Builder __superior) {
          if (__superior.name != null)
            name(__superior.name);
          if (!__superior.fields.isEmpty())
            fields.addAll(__superior.fields);
          return this;
        }

        public Builder name(String __value) {
        if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
          name = __value;
          __uninitialized.remove("name");
          return this;
        }


        /**
         * Add the given builder to this builder's list of Fields builders
         * @param __builder a builder
         * @return this builder
         */
        public Builder fields(Fields.Builder __builder) {
          fields.add(__builder);
          return this;
        }

        /**
         * Make a new builder and run the supplied function on it before adding it to the list
         * @param __func lambda that modifies the given builder
         * @return this builder
         */
        public Builder fields(java.util.function.Consumer<Fields.Builder> __func) {
          Fields.Builder __inner = new Fields.Builder();
          __func.accept(__inner);
          fields.add(__inner);
          return this;
        }

        /**
         * Set the given list as this builder's list of Fields builders
         * @param __builders a list of builders
         * @return this builder
         */
        public Builder fields(List<Fields.Builder> __builders) {
          fields = __builders;
          return this;
        }

        public Summaryclass build() {
          return new Summaryclass(this);
        }

      }

      // Information about a summary class
      private final StringNode name;
      private final InnerNodeVector<Fields> fields;

      public Summaryclass(Builder builder) {
        this(builder, true);
      }

      private Summaryclass(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
          throw new IllegalArgumentException("The following builder parameters for " +
              "schema-info.schema[].summaryclass[] must be initialized: " + builder.__uninitialized);

        name = (builder.name == null) ?
            new StringNode() : new StringNode(builder.name);
        fields = Fields.createVector(builder.fields);
      }

      /**
       * @return schema-info.schema[].summaryclass[].name
       */
      public String name() {
        return name.value();
      }

      /**
       * @return schema-info.schema[].summaryclass[].fields[]
       */
      public List<Fields> fields() {
        return fields;
      }

      /**
       * @param i the index of the value to return
       * @return schema-info.schema[].summaryclass[].fields[]
       */
      public Fields fields(int i) {
        return fields.get(i);
      }

      private ChangesRequiringRestart getChangesRequiringRestart(Summaryclass newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart("summaryclass");
        return changes;
      }

      private static InnerNodeVector<Summaryclass> createVector(List<Builder> builders) {
          List<Summaryclass> elems = new ArrayList<>();
          for (Builder b : builders) {
              elems.add(new Summaryclass(b));
          }
          return new InnerNodeVector<Summaryclass>(elems);
      }

      /**
       * This class represents schema-info.schema[].summaryclass[].fields[]
       */
      public final static class Fields extends InnerNode { 

        public static final class Builder implements ConfigBuilder {
          private Set<String> __uninitialized = new HashSet<String>(List.of(
            "name",
            "type"
            ));

          private String name = null;
          private String type = null;
          private Boolean dynamic = null;

          public Builder() { }

          public Builder(Fields config) {
            name(config.name());
            type(config.type());
            dynamic(config.dynamic());
          }

          private Builder override(Builder __superior) {
            if (__superior.name != null)
              name(__superior.name);
            if (__superior.type != null)
              type(__superior.type);
            if (__superior.dynamic != null)
              dynamic(__superior.dynamic);
            return this;
          }

          public Builder name(String __value) {
          if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
            name = __value;
            __uninitialized.remove("name");
            return this;
          }


          public Builder type(String __value) {
          if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
            type = __value;
            __uninitialized.remove("type");
            return this;
          }


          public Builder dynamic(boolean __value) {
            dynamic = __value;
            return this;
          }

          private Builder dynamic(String __value) {
            return dynamic(Boolean.valueOf(__value));
          }

          public Fields build() {
            return new Fields(this);
          }

        }

        // The name of a field in the summary class
        private final StringNode name;
        // The type of a field in the summary class
        private final StringNode type;
        // Whether this field is a dynamic snippet
        private final BooleanNode dynamic;

        public Fields(Builder builder) {
          this(builder, true);
        }

        private Fields(Builder builder, boolean throwIfUninitialized) {
          if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
            throw new IllegalArgumentException("The following builder parameters for " +
                "schema-info.schema[].summaryclass[].fields[] must be initialized: " + builder.__uninitialized);

          name = (builder.name == null) ?
              new StringNode() : new StringNode(builder.name);
          type = (builder.type == null) ?
              new StringNode() : new StringNode(builder.type);
          dynamic = (builder.dynamic == null) ?
              new BooleanNode(false) : new BooleanNode(builder.dynamic);
        }

        /**
         * @return schema-info.schema[].summaryclass[].fields[].name
         */
        public String name() {
          return name.value();
        }

        /**
         * @return schema-info.schema[].summaryclass[].fields[].type
         */
        public String type() {
          return type.value();
        }

        /**
         * @return schema-info.schema[].summaryclass[].fields[].dynamic
         */
        public boolean dynamic() {
          return dynamic.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Fields newConfig) {
          ChangesRequiringRestart changes = new ChangesRequiringRestart("fields");
          return changes;
        }

        private static InnerNodeVector<Fields> createVector(List<Builder> builders) {
            List<Fields> elems = new ArrayList<>();
            for (Builder b : builders) {
                elems.add(new Fields(b));
            }
            return new InnerNodeVector<Fields>(elems);
        }
      }
    }

    /**
     * This class represents schema-info.schema[].rankprofile[]
     */
    public final static class Rankprofile extends InnerNode { 

      public static final class Builder implements ConfigBuilder {
        private Set<String> __uninitialized = new HashSet<String>(List.of(
          "name"
          ));

        private String name = null;
        private Boolean hasSummaryFeatures = null;
        private Boolean hasRankFeatures = null;
        public Significance.Builder significance = new Significance.Builder();
        public List<Input.Builder> input = new ArrayList<>();

        public Builder() { }

        public Builder(Rankprofile config) {
          name(config.name());
          hasSummaryFeatures(config.hasSummaryFeatures());
          hasRankFeatures(config.hasRankFeatures());
          significance(new Significance.Builder(config.significance()));
          for (Input i : config.input()) {
            input(new Input.Builder(i));
          }
        }

        private Builder override(Builder __superior) {
          if (__superior.name != null)
            name(__superior.name);
          if (__superior.hasSummaryFeatures != null)
            hasSummaryFeatures(__superior.hasSummaryFeatures);
          if (__superior.hasRankFeatures != null)
            hasRankFeatures(__superior.hasRankFeatures);
          significance(significance.override(__superior.significance));
          if (!__superior.input.isEmpty())
            input.addAll(__superior.input);
          return this;
        }

        public Builder name(String __value) {
        if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
          name = __value;
          __uninitialized.remove("name");
          return this;
        }


        public Builder hasSummaryFeatures(boolean __value) {
          hasSummaryFeatures = __value;
          return this;
        }

        private Builder hasSummaryFeatures(String __value) {
          return hasSummaryFeatures(Boolean.valueOf(__value));
        }

        public Builder hasRankFeatures(boolean __value) {
          hasRankFeatures = __value;
          return this;
        }

        private Builder hasRankFeatures(String __value) {
          return hasRankFeatures(Boolean.valueOf(__value));
        }

        public Builder significance(Significance.Builder __builder) {
          significance = __builder;
          return this;
        }
        /**
         * Make a new builder and run the supplied function on it before adding it to the list
         * @param __func lambda that modifies the given builder
         * @return this builder
         */
        public Builder significance(java.util.function.Consumer<Significance.Builder> __func) {
          Significance.Builder __inner = new Significance.Builder();
          __func.accept(__inner);
          significance = __inner;
          return this;
        }

        /**
         * Add the given builder to this builder's list of Input builders
         * @param __builder a builder
         * @return this builder
         */
        public Builder input(Input.Builder __builder) {
          input.add(__builder);
          return this;
        }

        /**
         * Make a new builder and run the supplied function on it before adding it to the list
         * @param __func lambda that modifies the given builder
         * @return this builder
         */
        public Builder input(java.util.function.Consumer<Input.Builder> __func) {
          Input.Builder __inner = new Input.Builder();
          __func.accept(__inner);
          input.add(__inner);
          return this;
        }

        /**
         * Set the given list as this builder's list of Input builders
         * @param __builders a list of builders
         * @return this builder
         */
        public Builder input(List<Input.Builder> __builders) {
          input = __builders;
          return this;
        }

        public Rankprofile build() {
          return new Rankprofile(this);
        }

      }

      // Information about rank profiles
      private final StringNode name;
      private final BooleanNode hasSummaryFeatures;
      private final BooleanNode hasRankFeatures;
      private final Significance significance;
      private final InnerNodeVector<Input> input;

      public Rankprofile(Builder builder) {
        this(builder, true);
      }

      private Rankprofile(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
          throw new IllegalArgumentException("The following builder parameters for " +
              "schema-info.schema[].rankprofile[] must be initialized: " + builder.__uninitialized);

        name = (builder.name == null) ?
            new StringNode() : new StringNode(builder.name);
        hasSummaryFeatures = (builder.hasSummaryFeatures == null) ?
            new BooleanNode(true) : new BooleanNode(builder.hasSummaryFeatures);
        hasRankFeatures = (builder.hasRankFeatures == null) ?
            new BooleanNode(true) : new BooleanNode(builder.hasRankFeatures);
        significance = new Significance(builder.significance, throwIfUninitialized);
        input = Input.createVector(builder.input);
      }

      /**
       * @return schema-info.schema[].rankprofile[].name
       */
      public String name() {
        return name.value();
      }

      /**
       * @return schema-info.schema[].rankprofile[].hasSummaryFeatures
       */
      public boolean hasSummaryFeatures() {
        return hasSummaryFeatures.value();
      }

      /**
       * @return schema-info.schema[].rankprofile[].hasRankFeatures
       */
      public boolean hasRankFeatures() {
        return hasRankFeatures.value();
      }

      /**
       * @return schema-info.schema[].rankprofile[].significance
       */
      public Significance significance() {
        return significance;
      }

      /**
       * @return schema-info.schema[].rankprofile[].input[]
       */
      public List<Input> input() {
        return input;
      }

      /**
       * @param i the index of the value to return
       * @return schema-info.schema[].rankprofile[].input[]
       */
      public Input input(int i) {
        return input.get(i);
      }

      private ChangesRequiringRestart getChangesRequiringRestart(Rankprofile newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart("rankprofile");
        return changes;
      }

      private static InnerNodeVector<Rankprofile> createVector(List<Builder> builders) {
          List<Rankprofile> elems = new ArrayList<>();
          for (Builder b : builders) {
              elems.add(new Rankprofile(b));
          }
          return new InnerNodeVector<Rankprofile>(elems);
      }

      /**
       * This class represents schema-info.schema[].rankprofile[].significance
       */
      public final static class Significance extends InnerNode { 

        public static final class Builder implements ConfigBuilder {
          private Set<String> __uninitialized = new HashSet<String>();

          private Boolean useModel = null;

          public Builder() { }

          public Builder(Significance config) {
            useModel(config.useModel());
          }

          private Builder override(Builder __superior) {
            if (__superior.useModel != null)
              useModel(__superior.useModel);
            return this;
          }

          public Builder useModel(boolean __value) {
            useModel = __value;
            return this;
          }

          private Builder useModel(String __value) {
            return useModel(Boolean.valueOf(__value));
          }

          public Significance build() {
            return new Significance(this);
          }

        }

        private final BooleanNode useModel;

        public Significance(Builder builder) {
          this(builder, true);
        }

        private Significance(Builder builder, boolean throwIfUninitialized) {
          if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
            throw new IllegalArgumentException("The following builder parameters for " +
                "schema-info.schema[].rankprofile[].significance must be initialized: " + builder.__uninitialized);

          useModel = (builder.useModel == null) ?
              new BooleanNode(false) : new BooleanNode(builder.useModel);
        }

        /**
         * @return schema-info.schema[].rankprofile[].significance.useModel
         */
        public boolean useModel() {
          return useModel.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Significance newConfig) {
          ChangesRequiringRestart changes = new ChangesRequiringRestart("significance");
          return changes;
        }
      }

      /**
       * This class represents schema-info.schema[].rankprofile[].input[]
       */
      public final static class Input extends InnerNode { 

        public static final class Builder implements ConfigBuilder {
          private Set<String> __uninitialized = new HashSet<String>(List.of(
            "name",
            "type"
            ));

          private String name = null;
          private String type = null;

          public Builder() { }

          public Builder(Input config) {
            name(config.name());
            type(config.type());
          }

          private Builder override(Builder __superior) {
            if (__superior.name != null)
              name(__superior.name);
            if (__superior.type != null)
              type(__superior.type);
            return this;
          }

          public Builder name(String __value) {
          if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
            name = __value;
            __uninitialized.remove("name");
            return this;
          }


          public Builder type(String __value) {
          if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
            type = __value;
            __uninitialized.remove("type");
            return this;
          }


          public Input build() {
            return new Input(this);
          }

        }

        // The name of an input (query rank feature) accepted by this profile
        private final StringNode name;
        // The tensor type of an input (query rank feature) accepted by this profile
        private final StringNode type;

        public Input(Builder builder) {
          this(builder, true);
        }

        private Input(Builder builder, boolean throwIfUninitialized) {
          if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
            throw new IllegalArgumentException("The following builder parameters for " +
                "schema-info.schema[].rankprofile[].input[] must be initialized: " + builder.__uninitialized);

          name = (builder.name == null) ?
              new StringNode() : new StringNode(builder.name);
          type = (builder.type == null) ?
              new StringNode() : new StringNode(builder.type);
        }

        /**
         * @return schema-info.schema[].rankprofile[].input[].name
         */
        public String name() {
          return name.value();
        }

        /**
         * @return schema-info.schema[].rankprofile[].input[].type
         */
        public String type() {
          return type.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Input newConfig) {
          ChangesRequiringRestart changes = new ChangesRequiringRestart("input");
          return changes;
        }

        private static InnerNodeVector<Input> createVector(List<Builder> builders) {
            List<Input> elems = new ArrayList<>();
            for (Builder b : builders) {
                elems.add(new Input(b));
            }
            return new InnerNodeVector<Input>(elems);
        }
      }
    }
  }

}
