// ------------   D O   N O T   E D I T !   ------------
// This file is generated from a config definition file.

package com.yahoo.search.config;

import java.util.*;
import java.io.File;
import java.nio.file.Path;
import com.yahoo.config.*;

/**
 * This class represents the root node of qr-start
 *
 * Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
 * Do update the start script with the new name if you change it:
 */
public final class QrStartConfig extends ConfigInstance {

  public final static String CONFIG_DEF_MD5 = "5b0c786729f3f12e23c39ba88eac88a1";
  public final static String CONFIG_DEF_NAME = "qr-start";
  public final static String CONFIG_DEF_NAMESPACE = "search.config";
  public final static String[] CONFIG_DEF_SCHEMA = {
    "namespace=search.config",
    "jvm.server bool default=true restart",
    "jvm.verbosegc bool default=false restart",
    "jvm.gcopts string default=\"-XX:+UseG1GC -XX:MaxTenuringThreshold=15 -XX:NewRatio=1\" restart",
    "jvm.heapsize int default=1536 restart",
    "jvm.minHeapsize int default=1536 restart",
    "jvm.stacksize int default=512 restart",
    "jvm.compressedClassSpaceSize int default=32 restart",
    "jvm.baseMaxDirectMemorySize int default=16 restart",
    "jvm.directMemorySizeCache int default=0 restart",
    "jvm.heapSizeAsPercentageOfPhysicalMemory int default=0 restart",
    "jvm.availableProcessors int default=0 restart",
    "qrs.env string default=\"\" restart",
    "jdisc.classpath_extra string default=\"\" restart",
    "jdisc.export_packages string default=\"\" restart"
  };

  public static String getDefMd5()       { return CONFIG_DEF_MD5; }
  public static String getDefName()      { return CONFIG_DEF_NAME; }
  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

  public interface Producer extends ConfigInstance.Producer {
    void getConfig(Builder builder);
  }

  public static final class Builder implements ConfigInstance.Builder {
    private Set<String> __uninitialized = new HashSet<String>();

    public Jvm.Builder jvm = new Jvm.Builder();
    public Qrs.Builder qrs = new Qrs.Builder();
    public Jdisc.Builder jdisc = new Jdisc.Builder();

    public Builder() { }

    public Builder(QrStartConfig config) {
      jvm(new Jvm.Builder(config.jvm()));
      qrs(new Qrs.Builder(config.qrs()));
      jdisc(new Jdisc.Builder(config.jdisc()));
    }

    private Builder override(Builder __superior) {
      jvm(jvm.override(__superior.jvm));
      qrs(qrs.override(__superior.qrs));
      jdisc(jdisc.override(__superior.jdisc));
      return this;
    }

    public Builder jvm(Jvm.Builder __builder) {
      jvm = __builder;
      return this;
    }
    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder jvm(java.util.function.Consumer<Jvm.Builder> __func) {
      Jvm.Builder __inner = new Jvm.Builder();
      __func.accept(__inner);
      jvm = __inner;
      return this;
    }

    public Builder qrs(Qrs.Builder __builder) {
      qrs = __builder;
      return this;
    }
    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder qrs(java.util.function.Consumer<Qrs.Builder> __func) {
      Qrs.Builder __inner = new Qrs.Builder();
      __func.accept(__inner);
      qrs = __inner;
      return this;
    }

    public Builder jdisc(Jdisc.Builder __builder) {
      jdisc = __builder;
      return this;
    }
    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder jdisc(java.util.function.Consumer<Jdisc.Builder> __func) {
      Jdisc.Builder __inner = new Jdisc.Builder();
      __func.accept(__inner);
      jdisc = __inner;
      return this;
    }

    private boolean _applyOnRestart = false;

    @java.lang.Override
    public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
      if (producer instanceof Producer) {
        ((Producer)producer).getConfig(this);
        return true;
      }
      return false;
    }

    @java.lang.Override
    public final String getDefMd5() { return CONFIG_DEF_MD5; }

    @java.lang.Override
    public final String getDefName() { return CONFIG_DEF_NAME; }

    @java.lang.Override
    public final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

    @java.lang.Override
    public final boolean getApplyOnRestart() { return _applyOnRestart; }

    @java.lang.Override
    public final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }

    public QrStartConfig build() {
      return new QrStartConfig(this);
    }

  }

  private final Jvm jvm;
  private final Qrs qrs;
  private final Jdisc jdisc;

  public QrStartConfig(Builder builder) {
    this(builder, true);
  }

  private QrStartConfig(Builder builder, boolean throwIfUninitialized) {
    if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
      throw new IllegalArgumentException("The following builder parameters for " +
          "qr-start must be initialized: " + builder.__uninitialized);

    jvm = new Jvm(builder.jvm, throwIfUninitialized);
    qrs = new Qrs(builder.qrs, throwIfUninitialized);
    jdisc = new Jdisc(builder.jdisc, throwIfUninitialized);
  }

  /**
   * @return qr-start.jvm
   */
  public Jvm jvm() {
    return jvm;
  }

  /**
   * @return qr-start.qrs
   */
  public Qrs qrs() {
    return qrs;
  }

  /**
   * @return qr-start.jdisc
   */
  public Jdisc jdisc() {
    return jdisc;
  }

  private ChangesRequiringRestart getChangesRequiringRestart(QrStartConfig newConfig) {
    ChangesRequiringRestart changes = new ChangesRequiringRestart("qr-start");
      changes.mergeChanges("jvm", this.jvm.getChangesRequiringRestart(newConfig.jvm));
      changes.mergeChanges("qrs", this.qrs.getChangesRequiringRestart(newConfig.qrs));
      changes.mergeChanges("jdisc", this.jdisc.getChangesRequiringRestart(newConfig.jdisc));
    return changes;
  }

  private static boolean containsFieldsFlaggedWithRestart() {
    return true;
  }

  /**
   * This class represents qr-start.jvm
   */
  public final static class Jvm extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>();

      private Boolean server = null;
      private Boolean verbosegc = null;
      private String gcopts = null;
      private Integer heapsize = null;
      private Integer minHeapsize = null;
      private Integer stacksize = null;
      private Integer compressedClassSpaceSize = null;
      private Integer baseMaxDirectMemorySize = null;
      private Integer directMemorySizeCache = null;
      private Integer heapSizeAsPercentageOfPhysicalMemory = null;
      private Integer availableProcessors = null;

      public Builder() { }

      public Builder(Jvm config) {
        server(config.server());
        verbosegc(config.verbosegc());
        gcopts(config.gcopts());
        heapsize(config.heapsize());
        minHeapsize(config.minHeapsize());
        stacksize(config.stacksize());
        compressedClassSpaceSize(config.compressedClassSpaceSize());
        baseMaxDirectMemorySize(config.baseMaxDirectMemorySize());
        directMemorySizeCache(config.directMemorySizeCache());
        heapSizeAsPercentageOfPhysicalMemory(config.heapSizeAsPercentageOfPhysicalMemory());
        availableProcessors(config.availableProcessors());
      }

      private Builder override(Builder __superior) {
        if (__superior.server != null)
          server(__superior.server);
        if (__superior.verbosegc != null)
          verbosegc(__superior.verbosegc);
        if (__superior.gcopts != null)
          gcopts(__superior.gcopts);
        if (__superior.heapsize != null)
          heapsize(__superior.heapsize);
        if (__superior.minHeapsize != null)
          minHeapsize(__superior.minHeapsize);
        if (__superior.stacksize != null)
          stacksize(__superior.stacksize);
        if (__superior.compressedClassSpaceSize != null)
          compressedClassSpaceSize(__superior.compressedClassSpaceSize);
        if (__superior.baseMaxDirectMemorySize != null)
          baseMaxDirectMemorySize(__superior.baseMaxDirectMemorySize);
        if (__superior.directMemorySizeCache != null)
          directMemorySizeCache(__superior.directMemorySizeCache);
        if (__superior.heapSizeAsPercentageOfPhysicalMemory != null)
          heapSizeAsPercentageOfPhysicalMemory(__superior.heapSizeAsPercentageOfPhysicalMemory);
        if (__superior.availableProcessors != null)
          availableProcessors(__superior.availableProcessors);
        return this;
      }

      public Builder server(boolean __value) {
        server = __value;
        return this;
      }

      private Builder server(String __value) {
        return server(Boolean.valueOf(__value));
      }

      public Builder verbosegc(boolean __value) {
        verbosegc = __value;
        return this;
      }

      private Builder verbosegc(String __value) {
        return verbosegc(Boolean.valueOf(__value));
      }

      public Builder gcopts(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        gcopts = __value;
        return this;
      }


      public Builder heapsize(int __value) {
        heapsize = __value;
        return this;
      }

      private Builder heapsize(String __value) {
        return heapsize(Integer.valueOf(__value));
      }

      public Builder minHeapsize(int __value) {
        minHeapsize = __value;
        return this;
      }

      private Builder minHeapsize(String __value) {
        return minHeapsize(Integer.valueOf(__value));
      }

      public Builder stacksize(int __value) {
        stacksize = __value;
        return this;
      }

      private Builder stacksize(String __value) {
        return stacksize(Integer.valueOf(__value));
      }

      public Builder compressedClassSpaceSize(int __value) {
        compressedClassSpaceSize = __value;
        return this;
      }

      private Builder compressedClassSpaceSize(String __value) {
        return compressedClassSpaceSize(Integer.valueOf(__value));
      }

      public Builder baseMaxDirectMemorySize(int __value) {
        baseMaxDirectMemorySize = __value;
        return this;
      }

      private Builder baseMaxDirectMemorySize(String __value) {
        return baseMaxDirectMemorySize(Integer.valueOf(__value));
      }

      public Builder directMemorySizeCache(int __value) {
        directMemorySizeCache = __value;
        return this;
      }

      private Builder directMemorySizeCache(String __value) {
        return directMemorySizeCache(Integer.valueOf(__value));
      }

      public Builder heapSizeAsPercentageOfPhysicalMemory(int __value) {
        heapSizeAsPercentageOfPhysicalMemory = __value;
        return this;
      }

      private Builder heapSizeAsPercentageOfPhysicalMemory(String __value) {
        return heapSizeAsPercentageOfPhysicalMemory(Integer.valueOf(__value));
      }

      public Builder availableProcessors(int __value) {
        availableProcessors = __value;
        return this;
      }

      private Builder availableProcessors(String __value) {
        return availableProcessors(Integer.valueOf(__value));
      }

      public Jvm build() {
        return new Jvm(this);
      }

    }

    // Server or client VM
    private final BooleanNode server;
    // Debug logging of Garbage Collection
    private final BooleanNode verbosegc;
    // Garbage Collection tuning parameters
    private final StringNode gcopts;
    // Heap size (in megabytes) for the Java VM
    private final IntegerNode heapsize;
    // Min heapsize (in megabytes) for the Java VM
    private final IntegerNode minHeapsize;
    // Stack size (in kilobytes)
    private final IntegerNode stacksize;
    // CompressedOOps size in megabytes
    private final IntegerNode compressedClassSpaceSize;
    // Base value of maximum direct memory size (in megabytes)
    private final IntegerNode baseMaxDirectMemorySize;
    // Amount of direct memory used for caching. (in megabytes)
    private final IntegerNode directMemorySizeCache;
    // Set heap size as this percentage of available RAM, instead of absolute
    // value above. Setting outside [1, 99] disables this setting.
    private final IntegerNode heapSizeAsPercentageOfPhysicalMemory;
    // Number of processors available, can be used to set -XX:ActiveProcessorCount if set to non-zero.
    // In that case will be the number returned by the JVM when calling Runtime.getRuntime().availableProcessors()
    private final IntegerNode availableProcessors;

    public Jvm(Builder builder) {
      this(builder, true);
    }

    private Jvm(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "qr-start.jvm must be initialized: " + builder.__uninitialized);

      server = (builder.server == null) ?
          new BooleanNode(true) : new BooleanNode(builder.server);
      verbosegc = (builder.verbosegc == null) ?
          new BooleanNode(false) : new BooleanNode(builder.verbosegc);
      gcopts = (builder.gcopts == null) ?
          new StringNode("-XX:+UseG1GC -XX:MaxTenuringThreshold=15 -XX:NewRatio=1") : new StringNode(builder.gcopts);
      heapsize = (builder.heapsize == null) ?
          new IntegerNode(1536) : new IntegerNode(builder.heapsize);
      minHeapsize = (builder.minHeapsize == null) ?
          new IntegerNode(1536) : new IntegerNode(builder.minHeapsize);
      stacksize = (builder.stacksize == null) ?
          new IntegerNode(512) : new IntegerNode(builder.stacksize);
      compressedClassSpaceSize = (builder.compressedClassSpaceSize == null) ?
          new IntegerNode(32) : new IntegerNode(builder.compressedClassSpaceSize);
      baseMaxDirectMemorySize = (builder.baseMaxDirectMemorySize == null) ?
          new IntegerNode(16) : new IntegerNode(builder.baseMaxDirectMemorySize);
      directMemorySizeCache = (builder.directMemorySizeCache == null) ?
          new IntegerNode(0) : new IntegerNode(builder.directMemorySizeCache);
      heapSizeAsPercentageOfPhysicalMemory = (builder.heapSizeAsPercentageOfPhysicalMemory == null) ?
          new IntegerNode(0) : new IntegerNode(builder.heapSizeAsPercentageOfPhysicalMemory);
      availableProcessors = (builder.availableProcessors == null) ?
          new IntegerNode(0) : new IntegerNode(builder.availableProcessors);
    }

    /**
     * @return qr-start.jvm.server
     */
    public boolean server() {
      return server.value();
    }

    /**
     * @return qr-start.jvm.verbosegc
     */
    public boolean verbosegc() {
      return verbosegc.value();
    }

    /**
     * @return qr-start.jvm.gcopts
     */
    public String gcopts() {
      return gcopts.value();
    }

    /**
     * @return qr-start.jvm.heapsize
     */
    public int heapsize() {
      return heapsize.value();
    }

    /**
     * @return qr-start.jvm.minHeapsize
     */
    public int minHeapsize() {
      return minHeapsize.value();
    }

    /**
     * @return qr-start.jvm.stacksize
     */
    public int stacksize() {
      return stacksize.value();
    }

    /**
     * @return qr-start.jvm.compressedClassSpaceSize
     */
    public int compressedClassSpaceSize() {
      return compressedClassSpaceSize.value();
    }

    /**
     * @return qr-start.jvm.baseMaxDirectMemorySize
     */
    public int baseMaxDirectMemorySize() {
      return baseMaxDirectMemorySize.value();
    }

    /**
     * @return qr-start.jvm.directMemorySizeCache
     */
    public int directMemorySizeCache() {
      return directMemorySizeCache.value();
    }

    /**
     * @return qr-start.jvm.heapSizeAsPercentageOfPhysicalMemory
     */
    public int heapSizeAsPercentageOfPhysicalMemory() {
      return heapSizeAsPercentageOfPhysicalMemory.value();
    }

    /**
     * @return qr-start.jvm.availableProcessors
     */
    public int availableProcessors() {
      return availableProcessors.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Jvm newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("jvm");
        changes.compare(this.server, newConfig.server, "server", "Server or client VM");
        changes.compare(this.verbosegc, newConfig.verbosegc, "verbosegc", "Debug logging of Garbage Collection");
        changes.compare(this.gcopts, newConfig.gcopts, "gcopts", "Garbage Collection tuning parameters");
        changes.compare(this.heapsize, newConfig.heapsize, "heapsize", "Heap size (in megabytes) for the Java VM");
        changes.compare(this.minHeapsize, newConfig.minHeapsize, "minHeapsize", "Min heapsize (in megabytes) for the Java VM");
        changes.compare(this.stacksize, newConfig.stacksize, "stacksize", "Stack size (in kilobytes)");
        changes.compare(this.compressedClassSpaceSize, newConfig.compressedClassSpaceSize, "compressedClassSpaceSize", "CompressedOOps size in megabytes");
        changes.compare(this.baseMaxDirectMemorySize, newConfig.baseMaxDirectMemorySize, "baseMaxDirectMemorySize", "Base value of maximum direct memory size (in megabytes)");
        changes.compare(this.directMemorySizeCache, newConfig.directMemorySizeCache, "directMemorySizeCache", "Amount of direct memory used for caching. (in megabytes)");
        changes.compare(this.heapSizeAsPercentageOfPhysicalMemory, newConfig.heapSizeAsPercentageOfPhysicalMemory, "heapSizeAsPercentageOfPhysicalMemory", "Set heap size as this percentage of available RAM, instead of absolute\nvalue above. Setting outside [1, 99] disables this setting.");
        changes.compare(this.availableProcessors, newConfig.availableProcessors, "availableProcessors", "Number of processors available, can be used to set -XX:ActiveProcessorCount if set to non-zero.\nIn that case will be the number returned by the JVM when calling Runtime.getRuntime().availableProcessors()");
      return changes;
    }
  }

  /**
   * This class represents qr-start.qrs
   */
  public final static class Qrs extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>();

      private String env = null;

      public Builder() { }

      public Builder(Qrs config) {
        env(config.env());
      }

      private Builder override(Builder __superior) {
        if (__superior.env != null)
          env(__superior.env);
        return this;
      }

      public Builder env(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        env = __value;
        return this;
      }


      public Qrs build() {
        return new Qrs(this);
      }

    }

    // Extra environment variables
    private final StringNode env;

    public Qrs(Builder builder) {
      this(builder, true);
    }

    private Qrs(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "qr-start.qrs must be initialized: " + builder.__uninitialized);

      env = (builder.env == null) ?
          new StringNode("") : new StringNode(builder.env);
    }

    /**
     * @return qr-start.qrs.env
     */
    public String env() {
      return env.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Qrs newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("qrs");
        changes.compare(this.env, newConfig.env, "env", "Extra environment variables");
      return changes;
    }
  }

  /**
   * This class represents qr-start.jdisc
   */
  public final static class Jdisc extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>();

      private String classpath_extra = null;
      private String export_packages = null;

      public Builder() { }

      public Builder(Jdisc config) {
        classpath_extra(config.classpath_extra());
        export_packages(config.export_packages());
      }

      private Builder override(Builder __superior) {
        if (__superior.classpath_extra != null)
          classpath_extra(__superior.classpath_extra);
        if (__superior.export_packages != null)
          export_packages(__superior.export_packages);
        return this;
      }

      public Builder classpath_extra(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        classpath_extra = __value;
        return this;
      }


      public Builder export_packages(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        export_packages = __value;
        return this;
      }


      public Jdisc build() {
        return new Jdisc(this);
      }

    }

    // Extra class path entries, forwarded to vespa-start-container_daemon. Overrides the corresponding env setting.
    private final StringNode classpath_extra;
    // Extra export packages entries, forwarded to vespa-start-container_daemon. Overrides the corresponding env setting.
    private final StringNode export_packages;

    public Jdisc(Builder builder) {
      this(builder, true);
    }

    private Jdisc(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "qr-start.jdisc must be initialized: " + builder.__uninitialized);

      classpath_extra = (builder.classpath_extra == null) ?
          new StringNode("") : new StringNode(builder.classpath_extra);
      export_packages = (builder.export_packages == null) ?
          new StringNode("") : new StringNode(builder.export_packages);
    }

    /**
     * @return qr-start.jdisc.classpath_extra
     */
    public String classpath_extra() {
      return classpath_extra.value();
    }

    /**
     * @return qr-start.jdisc.export_packages
     */
    public String export_packages() {
      return export_packages.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Jdisc newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("jdisc");
        changes.compare(this.classpath_extra, newConfig.classpath_extra, "classpath_extra", "Extra class path entries, forwarded to vespa-start-container_daemon. Overrides the corresponding env setting.");
        changes.compare(this.export_packages, newConfig.export_packages, "export_packages", "Extra export packages entries, forwarded to vespa-start-container_daemon. Overrides the corresponding env setting.");
      return changes;
    }
  }

}
