// ------------   D O   N O T   E D I T !   ------------
// This file is generated from a config definition file.

package com.yahoo.search.config;

import java.util.*;
import java.io.File;
import java.nio.file.Path;
import com.yahoo.config.*;

/**
 * This class represents the root node of index-info
 *
 * Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
 * Commands per search definition to be applied to query terms per index before searching
 */
public final class IndexInfoConfig extends ConfigInstance {

  public final static String CONFIG_DEF_MD5 = "c9efd8a55a11a5910b9929c57fe43c8b";
  public final static String CONFIG_DEF_NAME = "index-info";
  public final static String CONFIG_DEF_NAMESPACE = "search.config";
  public final static String[] CONFIG_DEF_SCHEMA = {
    "namespace=search.config",
    "indexinfo[].name string",
    "indexinfo[].command[].indexname string",
    "indexinfo[].command[].command string",
    "indexinfo[].alias[].alias string",
    "indexinfo[].alias[].indexname string"
  };

  public static String getDefMd5()       { return CONFIG_DEF_MD5; }
  public static String getDefName()      { return CONFIG_DEF_NAME; }
  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

  public interface Producer extends ConfigInstance.Producer {
    void getConfig(Builder builder);
  }

  public static final class Builder implements ConfigInstance.Builder {
    private Set<String> __uninitialized = new HashSet<String>();

    public List<Indexinfo.Builder> indexinfo = new ArrayList<>();

    public Builder() { }

    public Builder(IndexInfoConfig config) {
      for (Indexinfo i : config.indexinfo()) {
        indexinfo(new Indexinfo.Builder(i));
      }
    }

    private Builder override(Builder __superior) {
      if (!__superior.indexinfo.isEmpty())
        indexinfo.addAll(__superior.indexinfo);
      return this;
    }

    /**
     * Add the given builder to this builder's list of Indexinfo builders
     * @param __builder a builder
     * @return this builder
     */
    public Builder indexinfo(Indexinfo.Builder __builder) {
      indexinfo.add(__builder);
      return this;
    }

    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder indexinfo(java.util.function.Consumer<Indexinfo.Builder> __func) {
      Indexinfo.Builder __inner = new Indexinfo.Builder();
      __func.accept(__inner);
      indexinfo.add(__inner);
      return this;
    }

    /**
     * Set the given list as this builder's list of Indexinfo builders
     * @param __builders a list of builders
     * @return this builder
     */
    public Builder indexinfo(List<Indexinfo.Builder> __builders) {
      indexinfo = __builders;
      return this;
    }

    private boolean _applyOnRestart = false;

    @java.lang.Override
    public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
      if (producer instanceof Producer) {
        ((Producer)producer).getConfig(this);
        return true;
      }
      return false;
    }

    @java.lang.Override
    public final String getDefMd5() { return CONFIG_DEF_MD5; }

    @java.lang.Override
    public final String getDefName() { return CONFIG_DEF_NAME; }

    @java.lang.Override
    public final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

    @java.lang.Override
    public final boolean getApplyOnRestart() { return _applyOnRestart; }

    @java.lang.Override
    public final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }

    public IndexInfoConfig build() {
      return new IndexInfoConfig(this);
    }

  }

  private final InnerNodeVector<Indexinfo> indexinfo;

  public IndexInfoConfig(Builder builder) {
    this(builder, true);
  }

  private IndexInfoConfig(Builder builder, boolean throwIfUninitialized) {
    if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
      throw new IllegalArgumentException("The following builder parameters for " +
          "index-info must be initialized: " + builder.__uninitialized);

    indexinfo = Indexinfo.createVector(builder.indexinfo);
  }

  /**
   * @return index-info.indexinfo[]
   */
  public List<Indexinfo> indexinfo() {
    return indexinfo;
  }

  /**
   * @param i the index of the value to return
   * @return index-info.indexinfo[]
   */
  public Indexinfo indexinfo(int i) {
    return indexinfo.get(i);
  }

  private ChangesRequiringRestart getChangesRequiringRestart(IndexInfoConfig newConfig) {
    ChangesRequiringRestart changes = new ChangesRequiringRestart("index-info");
    return changes;
  }

  private static boolean containsFieldsFlaggedWithRestart() {
    return false;
  }

  /**
   * This class represents index-info.indexinfo[]
   */
  public final static class Indexinfo extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>(List.of(
        "name"
        ));

      private String name = null;
      public List<Command.Builder> command = new ArrayList<>();
      public List<Alias.Builder> alias = new ArrayList<>();

      public Builder() { }

      public Builder(Indexinfo config) {
        name(config.name());
        for (Command c : config.command()) {
          command(new Command.Builder(c));
        }
        for (Alias a : config.alias()) {
          alias(new Alias.Builder(a));
        }
      }

      private Builder override(Builder __superior) {
        if (__superior.name != null)
          name(__superior.name);
        if (!__superior.command.isEmpty())
          command.addAll(__superior.command);
        if (!__superior.alias.isEmpty())
          alias.addAll(__superior.alias);
        return this;
      }

      public Builder name(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        name = __value;
        __uninitialized.remove("name");
        return this;
      }


      /**
       * Add the given builder to this builder's list of Command builders
       * @param __builder a builder
       * @return this builder
       */
      public Builder command(Command.Builder __builder) {
        command.add(__builder);
        return this;
      }

      /**
       * Make a new builder and run the supplied function on it before adding it to the list
       * @param __func lambda that modifies the given builder
       * @return this builder
       */
      public Builder command(java.util.function.Consumer<Command.Builder> __func) {
        Command.Builder __inner = new Command.Builder();
        __func.accept(__inner);
        command.add(__inner);
        return this;
      }

      /**
       * Set the given list as this builder's list of Command builders
       * @param __builders a list of builders
       * @return this builder
       */
      public Builder command(List<Command.Builder> __builders) {
        command = __builders;
        return this;
      }

      /**
       * Add the given builder to this builder's list of Alias builders
       * @param __builder a builder
       * @return this builder
       */
      public Builder alias(Alias.Builder __builder) {
        alias.add(__builder);
        return this;
      }

      /**
       * Make a new builder and run the supplied function on it before adding it to the list
       * @param __func lambda that modifies the given builder
       * @return this builder
       */
      public Builder alias(java.util.function.Consumer<Alias.Builder> __func) {
        Alias.Builder __inner = new Alias.Builder();
        __func.accept(__inner);
        alias.add(__inner);
        return this;
      }

      /**
       * Set the given list as this builder's list of Alias builders
       * @param __builders a list of builders
       * @return this builder
       */
      public Builder alias(List<Alias.Builder> __builders) {
        alias = __builders;
        return this;
      }

      public Indexinfo build() {
        return new Indexinfo(this);
      }

    }

    // The name of the search definition this index info applies to
    private final StringNode name;
    private final InnerNodeVector<Command> command;
    private final InnerNodeVector<Alias> alias;

    public Indexinfo(Builder builder) {
      this(builder, true);
    }

    private Indexinfo(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "index-info.indexinfo[] must be initialized: " + builder.__uninitialized);

      name = (builder.name == null) ?
          new StringNode() : new StringNode(builder.name);
      command = Command.createVector(builder.command);
      alias = Alias.createVector(builder.alias);
    }

    /**
     * @return index-info.indexinfo[].name
     */
    public String name() {
      return name.value();
    }

    /**
     * @return index-info.indexinfo[].command[]
     */
    public List<Command> command() {
      return command;
    }

    /**
     * @param i the index of the value to return
     * @return index-info.indexinfo[].command[]
     */
    public Command command(int i) {
      return command.get(i);
    }

    /**
     * @return index-info.indexinfo[].alias[]
     */
    public List<Alias> alias() {
      return alias;
    }

    /**
     * @param i the index of the value to return
     * @return index-info.indexinfo[].alias[]
     */
    public Alias alias(int i) {
      return alias.get(i);
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Indexinfo newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("indexinfo");
      return changes;
    }

    private static InnerNodeVector<Indexinfo> createVector(List<Builder> builders) {
        List<Indexinfo> elems = new ArrayList<>();
        for (Builder b : builders) {
            elems.add(new Indexinfo(b));
        }
        return new InnerNodeVector<Indexinfo>(elems);
    }

    /**
     * This class represents index-info.indexinfo[].command[]
     */
    public final static class Command extends InnerNode { 

      public static final class Builder implements ConfigBuilder {
        private Set<String> __uninitialized = new HashSet<String>(List.of(
          "indexname",
          "command"
          ));

        private String indexname = null;
        private String command = null;

        public Builder() { }

        public Builder(Command config) {
          indexname(config.indexname());
          command(config.command());
        }

        private Builder override(Builder __superior) {
          if (__superior.indexname != null)
            indexname(__superior.indexname);
          if (__superior.command != null)
            command(__superior.command);
          return this;
        }

        public Builder indexname(String __value) {
        if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
          indexname = __value;
          __uninitialized.remove("indexname");
          return this;
        }


        public Builder command(String __value) {
        if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
          command = __value;
          __uninitialized.remove("command");
          return this;
        }


        public Command build() {
          return new Command(this);
        }

      }

      // The name of a index for which we have a command
      private final StringNode indexname;
      // The command, e.g. "lowercase", "word" or "rise"
      private final StringNode command;

      public Command(Builder builder) {
        this(builder, true);
      }

      private Command(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
          throw new IllegalArgumentException("The following builder parameters for " +
              "index-info.indexinfo[].command[] must be initialized: " + builder.__uninitialized);

        indexname = (builder.indexname == null) ?
            new StringNode() : new StringNode(builder.indexname);
        command = (builder.command == null) ?
            new StringNode() : new StringNode(builder.command);
      }

      /**
       * @return index-info.indexinfo[].command[].indexname
       */
      public String indexname() {
        return indexname.value();
      }

      /**
       * @return index-info.indexinfo[].command[].command
       */
      public String command() {
        return command.value();
      }

      private ChangesRequiringRestart getChangesRequiringRestart(Command newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart("command");
        return changes;
      }

      private static InnerNodeVector<Command> createVector(List<Builder> builders) {
          List<Command> elems = new ArrayList<>();
          for (Builder b : builders) {
              elems.add(new Command(b));
          }
          return new InnerNodeVector<Command>(elems);
      }
    }

    /**
     * This class represents index-info.indexinfo[].alias[]
     */
    public final static class Alias extends InnerNode { 

      public static final class Builder implements ConfigBuilder {
        private Set<String> __uninitialized = new HashSet<String>(List.of(
          "alias",
          "indexname"
          ));

        private String alias = null;
        private String indexname = null;

        public Builder() { }

        public Builder(Alias config) {
          alias(config.alias());
          indexname(config.indexname());
        }

        private Builder override(Builder __superior) {
          if (__superior.alias != null)
            alias(__superior.alias);
          if (__superior.indexname != null)
            indexname(__superior.indexname);
          return this;
        }

        public Builder alias(String __value) {
        if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
          alias = __value;
          __uninitialized.remove("alias");
          return this;
        }


        public Builder indexname(String __value) {
        if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
          indexname = __value;
          __uninitialized.remove("indexname");
          return this;
        }


        public Alias build() {
          return new Alias(this);
        }

      }

      // The name of an alias for an index or attribute
      private final StringNode alias;
      // The index name that the alias should map to
      private final StringNode indexname;

      public Alias(Builder builder) {
        this(builder, true);
      }

      private Alias(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
          throw new IllegalArgumentException("The following builder parameters for " +
              "index-info.indexinfo[].alias[] must be initialized: " + builder.__uninitialized);

        alias = (builder.alias == null) ?
            new StringNode() : new StringNode(builder.alias);
        indexname = (builder.indexname == null) ?
            new StringNode() : new StringNode(builder.indexname);
      }

      /**
       * @return index-info.indexinfo[].alias[].alias
       */
      public String alias() {
        return alias.value();
      }

      /**
       * @return index-info.indexinfo[].alias[].indexname
       */
      public String indexname() {
        return indexname.value();
      }

      private ChangesRequiringRestart getChangesRequiringRestart(Alias newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart("alias");
        return changes;
      }

      private static InnerNodeVector<Alias> createVector(List<Builder> builders) {
          List<Alias> elems = new ArrayList<>();
          for (Builder b : builders) {
              elems.add(new Alias(b));
          }
          return new InnerNodeVector<Alias>(elems);
      }
    }
  }

}
