/* SemanticsParser.java */
/* Generated by: ParserGeneratorCC: Do not edit this line. SemanticsParser.java */
package com.yahoo.prelude.semantics.parser;

import com.yahoo.javacc.UnicodeUtilities;
import com.yahoo.language.process.StemMode;
import com.yahoo.language.Linguistics;
import com.yahoo.language.Language;
import com.yahoo.prelude.semantics.*;
import com.yahoo.prelude.semantics.rule.*;
import com.yahoo.prelude.semantics.engine.RuleBaseLinguistics;
import com.yahoo.prelude.query.TermType;

public class SemanticsParser implements SemanticsParserConstants {

    private RuleBaseLinguistics linguistics;

    public SemanticsParser(java.io.Reader stream, Linguistics linguistics) {
        this(stream);
        this.linguistics = new RuleBaseLinguistics(linguistics);
    }

/** Parses a search definition and returns the resulting object */
  final public RuleBase semanticRules(RuleBase rules,RuleImporter importer) throws ParseException {
    label_1:
    while (true) {
      switch (jj_nt.kind) {
      case NUMBER:
      case AUTOMATADIRECTIVE:
      case DEFAULTDIRECTIVE:
      case DOT:
      case ELLIPSIS:
      case EXCLAMATION:
      case INCLUDEDIRECTIVE:
      case LANGUAGEDIRECTIVE:
      case LEFTBRACE:
      case LEFTSQUAREBRACKET:
      case LITERAL:
      case NL:
      case QUOTE:
      case STEMMINGDIRECTIVE:
      case SUPERDIRECTIVE:
      case IDENTIFIER:{
        break;
        }
      default:
        jj_la1[0] = jj_gen;
        break label_1;
      }
      if (jj_2_1(2)) {
        jj_consume_token(NL);
      } else {
        switch (jj_nt.kind) {
        case AUTOMATADIRECTIVE:
        case DEFAULTDIRECTIVE:
        case INCLUDEDIRECTIVE:
        case LANGUAGEDIRECTIVE:
        case STEMMINGDIRECTIVE:{
          directive(rules,importer);
          break;
          }
        default:
          jj_la1[1] = jj_gen;
          if (jj_2_2(4)) {
            namedCondition(rules);
          } else {
            switch (jj_nt.kind) {
            case NUMBER:
            case DOT:
            case ELLIPSIS:
            case EXCLAMATION:
            case LEFTBRACE:
            case LEFTSQUAREBRACKET:
            case LITERAL:
            case QUOTE:
            case SUPERDIRECTIVE:
            case IDENTIFIER:{
              productionRule(rules);
              break;
              }
            default:
              jj_la1[2] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
          }
        }
      }
    }
{if ("" != null) return rules;}
    throw new IllegalStateException ("Missing return statement in function");
}

// ---------------------------------- Directive ---------------------------------------
  final public 
RuleBase directive(RuleBase rules, RuleImporter importer) throws ParseException {String name;
    switch (jj_nt.kind) {
    case INCLUDEDIRECTIVE:{
      includeDirective(rules, importer);
      break;
      }
    case DEFAULTDIRECTIVE:{
      defaultDirective(rules);
      break;
      }
    case AUTOMATADIRECTIVE:{
      automataDirective(rules, importer);
      break;
      }
    case STEMMINGDIRECTIVE:{
      stemmingDirective(rules);
      break;
      }
    case LANGUAGEDIRECTIVE:{
      languageDirective(rules);
      break;
      }
    default:
      jj_la1[3] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return rules;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public void includeDirective(RuleBase rules, RuleImporter importer) throws ParseException {String name;
    jj_consume_token(INCLUDEDIRECTIVE);
    jj_consume_token(LEFTBRACE);
    name = stringOrLiteral();
    jj_consume_token(RIGHTBRACE);
    switch (jj_nt.kind) {
    case SEMICOLON:{
      jj_consume_token(SEMICOLON);
      break;
      }
    default:
      jj_la1[4] = jj_gen;
      ;
    }
try {
            importer.include(name, rules);
        }
        catch (java.io.IOException e) {
            ParseException ep=new ParseException("Could not read included rule base '" + name + "'");
            ep.initCause(e);
            throw ep;
        }
}

  final public void automataDirective(RuleBase rules, RuleImporter importer) throws ParseException {String name;
    jj_consume_token(AUTOMATADIRECTIVE);
    jj_consume_token(LEFTBRACE);
    name = stringOrLiteral();
    jj_consume_token(RIGHTBRACE);
    switch (jj_nt.kind) {
    case SEMICOLON:{
      jj_consume_token(SEMICOLON);
      break;
      }
    default:
      jj_la1[5] = jj_gen;
      ;
    }
importer.setAutomata(rules, name);
}

  final public void defaultDirective(RuleBase rules) throws ParseException {
    jj_consume_token(DEFAULTDIRECTIVE);
    switch (jj_nt.kind) {
    case SEMICOLON:{
      jj_consume_token(SEMICOLON);
      break;
      }
    default:
      jj_la1[6] = jj_gen;
      ;
    }
rules.setDefault(true);
}

  final public void stemmingDirective(RuleBase rules) throws ParseException {String booleanString;
    jj_consume_token(STEMMINGDIRECTIVE);
    jj_consume_token(LEFTBRACE);
    booleanString = stringOrLiteral();
    jj_consume_token(RIGHTBRACE);
    switch (jj_nt.kind) {
    case SEMICOLON:{
      jj_consume_token(SEMICOLON);
      break;
      }
    default:
      jj_la1[7] = jj_gen;
      ;
    }
linguistics = linguistics.withStemMode(Boolean.parseBoolean(booleanString) ? StemMode.BEST : StemMode.NONE);
}

  final public void languageDirective(RuleBase rules) throws ParseException {String languageString;
    jj_consume_token(LANGUAGEDIRECTIVE);
    jj_consume_token(LEFTBRACE);
    languageString = stringOrLiteral();
    jj_consume_token(RIGHTBRACE);
    switch (jj_nt.kind) {
    case SEMICOLON:{
      jj_consume_token(SEMICOLON);
      break;
      }
    default:
      jj_la1[8] = jj_gen;
      ;
    }
linguistics = linguistics.withLanguage(Language.from(languageString));
}

// ---------------------------------- Production rules --------------------------------
  final public 
void productionRule(RuleBase rules) throws ParseException {ProductionRule rule;
    Condition condition;
    ProductionList production=null;
    condition = topLevelCondition();
    rule = productionRuleType();
    switch (jj_nt.kind) {
    case NUMBER:
    case DASH:
    case DOLLAR:
    case EQUALS:
    case LARGER:
    case LEFTSQUAREBRACKET:
    case PLUS:
    case QUESTION:
    case QUOTE:
    case SMALLER:
    case TILDE:
    case IDENTIFIER:{
      production = productionList();
      break;
      }
    default:
      jj_la1[9] = jj_gen;
      ;
    }
    jj_consume_token(SEMICOLON);
rule.setCondition(condition);
        if (production != null) rule.setProduction(production);
        rules.addRule(rule);
}

  final public ProductionRule productionRuleType() throws ParseException {
    switch (jj_nt.kind) {
    case REPLACE:{
      jj_consume_token(REPLACE);
{if ("" != null) return new ReplacingProductionRule();}
      break;
      }
    case PRODUCE:{
      jj_consume_token(PRODUCE);
{if ("" != null) return new AddingProductionRule();}
      break;
      }
    default:
      jj_la1[10] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new IllegalStateException ("Missing return statement in function");
}

  final public ProductionList productionList() throws ParseException {ProductionList productionList = new ProductionList();
    Production production;
    int weight=100;
    label_2:
    while (true) {
      production = production();
      switch (jj_nt.kind) {
      case EXCLAMATION:{
        jj_consume_token(EXCLAMATION);
        weight = number();
        break;
        }
      default:
        jj_la1[11] = jj_gen;
        ;
      }
production.setWeight(weight);
          productionList.addProduction(production);
          weight = 100;
      label_3:
      while (true) {
        switch (jj_nt.kind) {
        case NL:{
          break;
          }
        default:
          jj_la1[12] = jj_gen;
          break label_3;
        }
        jj_consume_token(NL);
      }
      switch (jj_nt.kind) {
      case NUMBER:
      case DASH:
      case DOLLAR:
      case EQUALS:
      case LARGER:
      case LEFTSQUAREBRACKET:
      case PLUS:
      case QUESTION:
      case QUOTE:
      case SMALLER:
      case TILDE:
      case IDENTIFIER:{
        break;
        }
      default:
        jj_la1[13] = jj_gen;
        break label_2;
      }
    }
{if ("" != null) return productionList;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Production production() throws ParseException {Production production;
    if (jj_2_3(2)) {
      production = namespaceProduction();
    } else {
      switch (jj_nt.kind) {
      case NUMBER:
      case DASH:
      case DOLLAR:
      case EQUALS:
      case LARGER:
      case LEFTSQUAREBRACKET:
      case PLUS:
      case QUESTION:
      case QUOTE:
      case SMALLER:
      case TILDE:
      case IDENTIFIER:{
        production = termProduction();
        break;
        }
      default:
        jj_la1[14] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
{if ("" != null) return production;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public TermProduction termProduction() throws ParseException {TermProduction termProduction;
    TermType termType;
    String label = null;
    termType = termType();
    if (jj_2_4(2)) {
      label = label();
    } else {
      ;
    }
    switch (jj_nt.kind) {
    case NUMBER:
    case LARGER:
    case LEFTSQUAREBRACKET:
    case SMALLER:
    case IDENTIFIER:{
      termProduction = nonphraseTermProduction();
      break;
      }
    case QUOTE:{
      termProduction = phraseProduction();
      break;
      }
    default:
      jj_la1[15] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
termProduction.setLabel(label);
        termProduction.setTermType(termType);
        {if ("" != null) return termProduction;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public TermProduction nonphraseTermProduction() throws ParseException {TermProduction termProduction;
    if (jj_2_5(2)) {
      termProduction = referenceTermProduction();
    } else {
      switch (jj_nt.kind) {
      case NUMBER:
      case LARGER:
      case SMALLER:
      case IDENTIFIER:{
        termProduction = literalTermProduction();
        break;
        }
      default:
        jj_la1[16] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
{if ("" != null) return termProduction;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public LiteralPhraseProduction phraseProduction() throws ParseException {LiteralPhraseProduction phraseProduction = new LiteralPhraseProduction();
    String term = null;
    jj_consume_token(QUOTE);
    label_4:
    while (true) {
      term = identifier();
phraseProduction.addTerm(term);
      switch (jj_nt.kind) {
      case NUMBER:
      case IDENTIFIER:{
        break;
        }
      default:
        jj_la1[17] = jj_gen;
        break label_4;
      }
    }
    jj_consume_token(QUOTE);
{if ("" != null) return phraseProduction;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public NamespaceProduction namespaceProduction() throws ParseException {String namespace;
    String key;
    String value = null;
    namespace = identifier();
    jj_consume_token(DOT);
    key = stringOrLiteral();
    jj_consume_token(EQUALS);
    value = identifierOrLiteral();
{if ("" != null) return new NamespaceProduction(namespace, key, value);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public ReferenceTermProduction referenceTermProduction() throws ParseException {String reference;
    boolean produceAll = false;
    String comparisonPrefix = "";
    switch (jj_nt.kind) {
    case LARGER:
    case SMALLER:{
      comparisonPrefix = comparisonPrefix();
      break;
      }
    default:
      jj_la1[18] = jj_gen;
      ;
    }
    jj_consume_token(LEFTSQUAREBRACKET);
    reference = referenceIdentifier();
    switch (jj_nt.kind) {
    case STAR:{
      jj_consume_token(STAR);
produceAll = true;
      break;
      }
    default:
      jj_la1[19] = jj_gen;
      ;
    }
    jj_consume_token(RIGHTSQUAREBRACKET);
{if ("" != null) return new ReferenceTermProduction(reference, produceAll);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public LiteralTermProduction literalTermProduction() throws ParseException {String literal;
    String comparisonPrefix = "";
    switch (jj_nt.kind) {
    case LARGER:
    case SMALLER:{
      comparisonPrefix = comparisonPrefix();
      break;
      }
    default:
      jj_la1[20] = jj_gen;
      ;
    }
    literal = identifier();
{if ("" != null) return new LiteralTermProduction(comparisonPrefix + literal);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public String comparisonPrefix() throws ParseException {
    switch (jj_nt.kind) {
    case SMALLER:{
      jj_consume_token(SMALLER);
{if ("" != null) return "<";}
      break;
      }
    case LARGER:{
      jj_consume_token(LARGER);
{if ("" != null) return ">";}
      break;
      }
    default:
      jj_la1[21] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new IllegalStateException ("Missing return statement in function");
}

  final public TermType termType() throws ParseException {
    switch (jj_nt.kind) {
    case QUESTION:{
      jj_consume_token(QUESTION);
{if ("" != null) return TermType.OR;}
      break;
      }
    case DOLLAR:{
      jj_consume_token(DOLLAR);
{if ("" != null) return TermType.RANK;}
      break;
      }
    case TILDE:{
      jj_consume_token(TILDE);
{if ("" != null) return TermType.WEAK_AND;}
      break;
      }
    case PLUS:{
      jj_consume_token(PLUS);
{if ("" != null) return TermType.AND;}
      break;
      }
    case DASH:{
      jj_consume_token(DASH);
{if ("" != null) return TermType.NOT;}
      break;
      }
    case EQUALS:{
      jj_consume_token(EQUALS);
{if ("" != null) return TermType.EQUIV;}
      break;
      }
    default:
      jj_la1[22] = jj_gen;
{if ("" != null) return TermType.DEFAULT;}
    }
    throw new IllegalStateException ("Missing return statement in function");
}

  final public String referenceIdentifier() throws ParseException {String reference;
    switch (jj_nt.kind) {
    case NUMBER:
    case IDENTIFIER:{
      reference = identifier();
{if ("" != null) return reference;}
      break;
      }
    case ELLIPSIS:{
      jj_consume_token(ELLIPSIS);
{if ("" != null) return "...";}
      break;
      }
    default:
      jj_la1[23] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new IllegalStateException ("Missing return statement in function");
}

// ---------------------------------- Conditions -------------------------------------
  final public 
void namedCondition(RuleBase rules) throws ParseException {String conditionName;
    Condition condition;
    jj_consume_token(LEFTSQUAREBRACKET);
    conditionName = identifier();
    jj_consume_token(RIGHTSQUAREBRACKET);
    jj_consume_token(CONDITION);
    condition = topLevelCondition();
    jj_consume_token(SEMICOLON);
rules.addCondition(new NamedCondition(conditionName, condition));
}

  final public Condition topLevelCondition() throws ParseException {Condition condition;
    boolean startAnchor = false;
    boolean endAnchor = false;
    switch (jj_nt.kind) {
    case DOT:{
      jj_consume_token(DOT);
startAnchor = true;
      break;
      }
    default:
      jj_la1[24] = jj_gen;
      ;
    }
    if (jj_2_6(3)) {
      condition = choiceCondition();
    } else if (jj_2_7(3)) {
      condition = sequenceCondition();
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    if (jj_2_8(2)) {
      jj_consume_token(DOT);
endAnchor = true;
    } else {
      ;
    }
condition.setAnchor(Condition.Anchor.create(startAnchor, endAnchor));
      {if ("" != null) return condition;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Condition condition() throws ParseException {Condition condition;
    if (jj_2_9(3)) {
      condition = choiceCondition();
    } else {
      switch (jj_nt.kind) {
      case NUMBER:
      case ELLIPSIS:
      case EXCLAMATION:
      case LEFTBRACE:
      case LEFTSQUAREBRACKET:
      case LITERAL:
      case QUOTE:
      case SUPERDIRECTIVE:
      case IDENTIFIER:{
        condition = terminalCondition();
        break;
        }
      default:
        jj_la1[25] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
{if ("" != null) return condition;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Condition terminalOrSequenceCondition() throws ParseException {Condition condition;
    if (jj_2_10(3)) {
      condition = sequenceCondition();
    } else {
      switch (jj_nt.kind) {
      case NUMBER:
      case ELLIPSIS:
      case EXCLAMATION:
      case LEFTBRACE:
      case LEFTSQUAREBRACKET:
      case LITERAL:
      case QUOTE:
      case SUPERDIRECTIVE:
      case IDENTIFIER:{
        condition = terminalCondition();
        break;
        }
      default:
        jj_la1[26] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
{if ("" != null) return condition;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Condition terminalCondition() throws ParseException {Condition condition;
    switch (jj_nt.kind) {
    case EXCLAMATION:{
      condition = notCondition();
      break;
      }
    case NUMBER:
    case ELLIPSIS:
    case LEFTBRACE:
    case LEFTSQUAREBRACKET:
    case LITERAL:
    case QUOTE:
    case SUPERDIRECTIVE:
    case IDENTIFIER:{
      condition = terminalOrComparisonCondition();
      break;
      }
    default:
      jj_la1[27] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return condition;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Condition terminalOrComparisonCondition() throws ParseException {Condition condition, rightCondition;
    String comparison;
    condition = reallyTerminalCondition();
    switch (jj_nt.kind) {
    case CONTAINS:
    case DIFFERENT:
    case EQUALS:
    case LARGER:
    case LARGEREQUALS:
    case SMALLER:
    case SMALLEREQUALS:{
      comparison = comparison();
      if (jj_2_11(2)) {
        rightCondition = nestedCondition();
      } else {
        switch (jj_nt.kind) {
        case NUMBER:
        case ELLIPSIS:
        case LEFTBRACE:
        case LEFTSQUAREBRACKET:
        case LITERAL:
        case QUOTE:
        case SUPERDIRECTIVE:
        case IDENTIFIER:{
          rightCondition = reallyTerminalCondition();
          break;
          }
        default:
          jj_la1[28] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
condition = new ComparisonCondition(condition, comparison, rightCondition);
      break;
      }
    default:
      jj_la1[29] = jj_gen;
      ;
    }
{if ("" != null) return condition;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Condition reallyTerminalCondition() throws ParseException {String label = null;
    String context = null;
    String nameSpace = null;
    Condition condition = null;
    if (jj_2_16(8)) {
      if (jj_2_12(2)) {
        context = context();
      } else {
        ;
      }
      nameSpace = nameSpace();
      if (jj_2_13(2)) {
        label = label();
      } else {
        ;
      }
      condition = terminalConditionBody();
    } else {
      switch (jj_nt.kind) {
      case NUMBER:
      case ELLIPSIS:
      case LEFTBRACE:
      case LEFTSQUAREBRACKET:
      case LITERAL:
      case QUOTE:
      case SUPERDIRECTIVE:
      case IDENTIFIER:{
        if (jj_2_14(2)) {
          context = context();
        } else {
          ;
        }
        if (jj_2_15(2)) {
          label = label();
        } else {
          ;
        }
        condition = terminalConditionBody();
        break;
        }
      default:
        jj_la1[30] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
if (context != null)
         condition.setContextName(context);
     condition.setLabel(label);
     condition.setNameSpace(nameSpace);
     {if ("" != null) return condition;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Condition terminalConditionBody() throws ParseException {Condition condition = null;
    if (jj_2_17(2)) {
      condition = conditionReference();
    } else {
      switch (jj_nt.kind) {
      case NUMBER:
      case IDENTIFIER:{
        condition = termCondition();
        break;
        }
      case LEFTBRACE:{
        condition = nestedCondition();
        break;
        }
      case ELLIPSIS:{
        condition = nonReferableEllipsisCondition();
        break;
        }
      case LEFTSQUAREBRACKET:{
        condition = referableEllipsisCondition();
        break;
        }
      case SUPERDIRECTIVE:{
        condition = superCondition();
        break;
        }
      case LITERAL:{
        condition = literalCondition();
        break;
        }
      case QUOTE:{
        condition = compositeItemCondition();
        break;
        }
      default:
        jj_la1[31] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
{if ("" != null) return condition;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Condition notCondition() throws ParseException {Condition condition;
    jj_consume_token(EXCLAMATION);
    condition = terminalOrComparisonCondition();
{if ("" != null) return new NotCondition(condition);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public ConditionReference conditionReference() throws ParseException {String conditionName;
    jj_consume_token(LEFTSQUAREBRACKET);
    conditionName = identifier();
    jj_consume_token(RIGHTSQUAREBRACKET);
{if ("" != null) return new ConditionReference(conditionName);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EllipsisCondition nonReferableEllipsisCondition() throws ParseException {
    jj_consume_token(ELLIPSIS);
{if ("" != null) return new EllipsisCondition(false);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EllipsisCondition referableEllipsisCondition() throws ParseException {
    jj_consume_token(LEFTSQUAREBRACKET);
    jj_consume_token(ELLIPSIS);
    jj_consume_token(RIGHTSQUAREBRACKET);
{if ("" != null) return new EllipsisCondition();}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Condition nestedCondition() throws ParseException {Condition condition;
    jj_consume_token(LEFTBRACE);
    condition = choiceCondition();
    jj_consume_token(RIGHTBRACE);
{if ("" != null) return condition;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Condition sequenceCondition() throws ParseException {SequenceCondition sequenceCondition = new SequenceCondition();
    Condition condition;
    condition = terminalCondition();
sequenceCondition.addCondition(condition);
    label_5:
    while (true) {
      if (jj_2_18(2)) {
      } else {
        break label_5;
      }
      condition = terminalCondition();
sequenceCondition.addCondition(condition);
    }
if (sequenceCondition.conditionSize() == 1)
          {if ("" != null) return sequenceCondition.removeCondition(0);}
      else
          {if ("" != null) return sequenceCondition;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Condition choiceCondition() throws ParseException {ChoiceCondition choiceCondition = new ChoiceCondition();
    Condition condition;
    condition = terminalOrSequenceCondition();
choiceCondition.addCondition(condition);
    label_6:
    while (true) {
      if (jj_2_19(3)) {
      } else {
        break label_6;
      }
      label_7:
      while (true) {
        switch (jj_nt.kind) {
        case NL:{
          break;
          }
        default:
          jj_la1[32] = jj_gen;
          break label_7;
        }
        jj_consume_token(NL);
      }
      jj_consume_token(COMMA);
      label_8:
      while (true) {
        switch (jj_nt.kind) {
        case NL:{
          break;
          }
        default:
          jj_la1[33] = jj_gen;
          break label_8;
        }
        jj_consume_token(NL);
      }
      condition = terminalOrSequenceCondition();
choiceCondition.addCondition(condition);
    }
if (choiceCondition.conditionSize() == 1)
          {if ("" != null) return choiceCondition.removeCondition(0);}
      else
          {if ("" != null) return choiceCondition;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public TermCondition termCondition() throws ParseException {String str;
    str = identifier();
{if ("" != null) return new TermCondition(str, linguistics);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public SuperCondition superCondition() throws ParseException {
    jj_consume_token(SUPERDIRECTIVE);
{if ("" != null) return new SuperCondition();}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public LiteralCondition literalCondition() throws ParseException {String str;
    str = literal();
{if ("" != null) return new LiteralCondition(str);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public CompositeItemCondition compositeItemCondition() throws ParseException {Condition condition;
    CompositeItemCondition compositeItemCondition = new CompositeItemCondition();
    jj_consume_token(QUOTE);
    condition = terminalConditionBody();
compositeItemCondition.addCondition(condition);
    jj_consume_token(QUOTE);
{if ("" != null) return compositeItemCondition;}
    throw new IllegalStateException ("Missing return statement in function");
}

// ---------------------------------- Primitives -------------------------------------
  final public 
String context() throws ParseException {String str;
    str = identifier();
    jj_consume_token(SLASH);
{if ("" != null) return str;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public String label() throws ParseException {String str;
    str = identifier();
    jj_consume_token(COLON);
{if ("" != null) return str;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public String nameSpace() throws ParseException {String str;
    str = identifier();
    jj_consume_token(DOT);
{if ("" != null) return str;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public String identifier() throws ParseException {
    switch (jj_nt.kind) {
    case IDENTIFIER:{
      jj_consume_token(IDENTIFIER);
      break;
      }
    case NUMBER:{
      jj_consume_token(NUMBER);
      break;
      }
    default:
      jj_la1[34] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return token.image;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public String stringOrLiteral() throws ParseException {String str;
    switch (jj_nt.kind) {
    case DASH:
    case DOT:
    case SLASH:
    case IDENTIFIER:{
      str = string();
      break;
      }
    case LITERAL:{
      str = literal();
      break;
      }
    default:
      jj_la1[35] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return str;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public String identifierOrLiteral() throws ParseException {String str;
    switch (jj_nt.kind) {
    case NUMBER:
    case IDENTIFIER:{
      str = identifier();
      break;
      }
    case LITERAL:{
      str = literal();
      break;
      }
    default:
      jj_la1[36] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return str;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public String comparison() throws ParseException {
    switch (jj_nt.kind) {
    case DIFFERENT:{
      jj_consume_token(DIFFERENT);
      break;
      }
    case CONTAINS:{
      jj_consume_token(CONTAINS);
      break;
      }
    case EQUALS:{
      jj_consume_token(EQUALS);
      break;
      }
    case LARGEREQUALS:{
      jj_consume_token(LARGEREQUALS);
      break;
      }
    case SMALLEREQUALS:{
      jj_consume_token(SMALLEREQUALS);
      break;
      }
    case LARGER:{
      jj_consume_token(LARGER);
      break;
      }
    case SMALLER:{
      jj_consume_token(SMALLER);
      break;
      }
    default:
      jj_la1[37] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return token.image;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public String string() throws ParseException {StringBuilder str = new StringBuilder();
    label_9:
    while (true) {
      switch (jj_nt.kind) {
      case SLASH:{
        jj_consume_token(SLASH);
        break;
        }
      case IDENTIFIER:{
        jj_consume_token(IDENTIFIER);
        break;
        }
      case DOT:{
        jj_consume_token(DOT);
        break;
        }
      case DASH:{
        jj_consume_token(DASH);
        break;
        }
      default:
        jj_la1[38] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
str.append(token.image);
      switch (jj_nt.kind) {
      case DASH:
      case DOT:
      case SLASH:
      case IDENTIFIER:{
        break;
        }
      default:
        jj_la1[39] = jj_gen;
        break label_9;
      }
    }
{if ("" != null) return str.toString();}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public String literal() throws ParseException {
    jj_consume_token(LITERAL);
{if ("" != null) return UnicodeUtilities.unquote(token.image);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public int number() throws ParseException {
    jj_consume_token(NUMBER);
{if ("" != null) return Integer.decode(token.image);}
    throw new IllegalStateException ("Missing return statement in function");
}

  private boolean jj_2_1(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_1()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  private boolean jj_2_2(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_2()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  private boolean jj_2_3(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_3()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(2, xla); }
  }

  private boolean jj_2_4(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_4()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(3, xla); }
  }

  private boolean jj_2_5(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_5()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(4, xla); }
  }

  private boolean jj_2_6(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_6()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(5, xla); }
  }

  private boolean jj_2_7(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_7()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(6, xla); }
  }

  private boolean jj_2_8(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_8()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(7, xla); }
  }

  private boolean jj_2_9(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_9()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(8, xla); }
  }

  private boolean jj_2_10(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_10()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(9, xla); }
  }

  private boolean jj_2_11(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_11()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(10, xla); }
  }

  private boolean jj_2_12(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_12()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(11, xla); }
  }

  private boolean jj_2_13(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_13()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(12, xla); }
  }

  private boolean jj_2_14(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_14()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(13, xla); }
  }

  private boolean jj_2_15(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_15()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(14, xla); }
  }

  private boolean jj_2_16(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_16()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(15, xla); }
  }

  private boolean jj_2_17(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_17()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(16, xla); }
  }

  private boolean jj_2_18(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_18()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(17, xla); }
  }

  private boolean jj_2_19(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_19()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(18, xla); }
  }

  private boolean jj_3_1()
 {
    if (jj_scan_token(NL)) return true;
    return false;
  }

  private boolean jj_3_2()
 {
    if (jj_3R_10()) return true;
    return false;
  }

  private boolean jj_3_3()
 {
    if (jj_3R_11()) return true;
    return false;
  }

  private boolean jj_3R_18()
 {
    if (jj_3R_23()) return true;
    if (jj_scan_token(DOT)) return true;
    return false;
  }

  private boolean jj_3R_20()
 {
    if (jj_scan_token(LEFTSQUAREBRACKET)) return true;
    if (jj_3R_23()) return true;
    if (jj_scan_token(RIGHTSQUAREBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_23()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(46)) {
    jj_scanpos = xsp;
    if (jj_scan_token(6)) return true;
    }
    return false;
  }

  private boolean jj_3_6()
 {
    if (jj_3R_14()) return true;
    return false;
  }

  private boolean jj_3R_54()
 {
    if (jj_3R_50()) return true;
    return false;
  }

  private boolean jj_3_4()
 {
    if (jj_3R_12()) return true;
    return false;
  }

  private boolean jj_3_7()
 {
    if (jj_3R_15()) return true;
    return false;
  }

  private boolean jj_3_8()
 {
    if (jj_scan_token(DOT)) return true;
    return false;
  }

  private boolean jj_3R_40()
 {
    if (jj_scan_token(ELLIPSIS)) return true;
    return false;
  }

  private boolean jj_3R_41()
 {
    if (jj_scan_token(LEFTSQUAREBRACKET)) return true;
    if (jj_scan_token(ELLIPSIS)) return true;
    if (jj_scan_token(RIGHTSQUAREBRACKET)) return true;
    return false;
  }

  private boolean jj_3_5()
 {
    if (jj_3R_13()) return true;
    return false;
  }

  private boolean jj_3_9()
 {
    if (jj_3R_14()) return true;
    return false;
  }

  private boolean jj_3R_16()
 {
    if (jj_scan_token(LEFTBRACE)) return true;
    if (jj_3R_14()) return true;
    if (jj_scan_token(RIGHTBRACE)) return true;
    return false;
  }

  private boolean jj_3R_53()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(17)) {
    jj_scanpos = xsp;
    if (jj_scan_token(14)) {
    jj_scanpos = xsp;
    if (jj_scan_token(21)) {
    jj_scanpos = xsp;
    if (jj_scan_token(26)) {
    jj_scanpos = xsp;
    if (jj_scan_token(41)) {
    jj_scanpos = xsp;
    if (jj_scan_token(25)) {
    jj_scanpos = xsp;
    if (jj_scan_token(40)) return true;
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_22()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_10()) {
    jj_scanpos = xsp;
    if (jj_3R_35()) return true;
    }
    return false;
  }

  private boolean jj_3_10()
 {
    if (jj_3R_15()) return true;
    return false;
  }

  private boolean jj_3R_15()
 {
    if (jj_3R_21()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_18()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_35()
 {
    if (jj_3R_21()) return true;
    return false;
  }

  private boolean jj_3_18()
 {
    if (jj_3R_21()) return true;
    return false;
  }

  private boolean jj_3R_21()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_33()) {
    jj_scanpos = xsp;
    if (jj_3R_34()) return true;
    }
    return false;
  }

  private boolean jj_3R_49()
 {
    if (jj_scan_token(LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_33()
 {
    if (jj_3R_45()) return true;
    return false;
  }

  private boolean jj_3R_11()
 {
    if (jj_3R_23()) return true;
    if (jj_scan_token(DOT)) return true;
    return false;
  }

  private boolean jj_3R_46()
 {
    if (jj_3R_50()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_51()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_14()
 {
    if (jj_3R_22()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_19()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_51()
 {
    if (jj_3R_53()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_11()) {
    jj_scanpos = xsp;
    if (jj_3R_54()) return true;
    }
    return false;
  }

  private boolean jj_3_19()
 {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(30)) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(COMMA)) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(30)) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_22()) return true;
    return false;
  }

  private boolean jj_3R_13()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_24()) jj_scanpos = xsp;
    if (jj_scan_token(LEFTSQUAREBRACKET)) return true;
    if (jj_3R_25()) return true;
    return false;
  }

  private boolean jj_3R_24()
 {
    if (jj_3R_36()) return true;
    return false;
  }

  private boolean jj_3R_39()
 {
    if (jj_3R_23()) return true;
    return false;
  }

  private boolean jj_3R_50()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_16()) {
    jj_scanpos = xsp;
    if (jj_3R_52()) return true;
    }
    return false;
  }

  private boolean jj_3_16()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_12()) jj_scanpos = xsp;
    if (jj_3R_18()) return true;
    xsp = jj_scanpos;
    if (jj_3_13()) jj_scanpos = xsp;
    if (jj_3R_19()) return true;
    return false;
  }

  private boolean jj_3R_34()
 {
    if (jj_3R_46()) return true;
    return false;
  }

  private boolean jj_3R_42()
 {
    if (jj_scan_token(SUPERDIRECTIVE)) return true;
    return false;
  }

  private boolean jj_3_12()
 {
    if (jj_3R_17()) return true;
    return false;
  }

  private boolean jj_3R_52()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_14()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_15()) jj_scanpos = xsp;
    if (jj_3R_19()) return true;
    return false;
  }

  private boolean jj_3_13()
 {
    if (jj_3R_12()) return true;
    return false;
  }

  private boolean jj_3_11()
 {
    if (jj_3R_16()) return true;
    return false;
  }

  private boolean jj_3R_36()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_47()) {
    jj_scanpos = xsp;
    if (jj_3R_48()) return true;
    }
    return false;
  }

  private boolean jj_3R_47()
 {
    if (jj_scan_token(SMALLER)) return true;
    return false;
  }

  private boolean jj_3R_48()
 {
    if (jj_scan_token(LARGER)) return true;
    return false;
  }

  private boolean jj_3_14()
 {
    if (jj_3R_17()) return true;
    return false;
  }

  private boolean jj_3R_43()
 {
    if (jj_3R_49()) return true;
    return false;
  }

  private boolean jj_3_15()
 {
    if (jj_3R_12()) return true;
    return false;
  }

  private boolean jj_3R_44()
 {
    if (jj_scan_token(QUOTE)) return true;
    if (jj_3R_19()) return true;
    if (jj_scan_token(QUOTE)) return true;
    return false;
  }

  private boolean jj_3R_19()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_17()) {
    jj_scanpos = xsp;
    if (jj_3R_26()) {
    jj_scanpos = xsp;
    if (jj_3R_27()) {
    jj_scanpos = xsp;
    if (jj_3R_28()) {
    jj_scanpos = xsp;
    if (jj_3R_29()) {
    jj_scanpos = xsp;
    if (jj_3R_30()) {
    jj_scanpos = xsp;
    if (jj_3R_31()) {
    jj_scanpos = xsp;
    if (jj_3R_32()) return true;
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3_17()
 {
    if (jj_3R_20()) return true;
    return false;
  }

  private boolean jj_3R_26()
 {
    if (jj_3R_39()) return true;
    return false;
  }

  private boolean jj_3R_27()
 {
    if (jj_3R_16()) return true;
    return false;
  }

  private boolean jj_3R_25()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_37()) {
    jj_scanpos = xsp;
    if (jj_3R_38()) return true;
    }
    return false;
  }

  private boolean jj_3R_28()
 {
    if (jj_3R_40()) return true;
    return false;
  }

  private boolean jj_3R_37()
 {
    if (jj_3R_23()) return true;
    return false;
  }

  private boolean jj_3R_29()
 {
    if (jj_3R_41()) return true;
    return false;
  }

  private boolean jj_3R_17()
 {
    if (jj_3R_23()) return true;
    if (jj_scan_token(SLASH)) return true;
    return false;
  }

  private boolean jj_3R_30()
 {
    if (jj_3R_42()) return true;
    return false;
  }

  private boolean jj_3R_38()
 {
    if (jj_scan_token(ELLIPSIS)) return true;
    return false;
  }

  private boolean jj_3R_31()
 {
    if (jj_3R_43()) return true;
    return false;
  }

  private boolean jj_3R_32()
 {
    if (jj_3R_44()) return true;
    return false;
  }

  private boolean jj_3R_12()
 {
    if (jj_3R_23()) return true;
    if (jj_scan_token(COLON)) return true;
    return false;
  }

  private boolean jj_3R_10()
 {
    if (jj_scan_token(LEFTSQUAREBRACKET)) return true;
    if (jj_3R_23()) return true;
    if (jj_scan_token(RIGHTSQUAREBRACKET)) return true;
    if (jj_scan_token(CONDITION)) return true;
    return false;
  }

  private boolean jj_3R_45()
 {
    if (jj_scan_token(EXCLAMATION)) return true;
    if (jj_3R_46()) return true;
    return false;
  }

  /** Generated Token Manager. */
  public SemanticsParserTokenManager token_source;
  SimpleCharStream jj_input_stream;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  private int jj_gen;
  final private int[] jj_la1 = new int[40];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static {
	   jj_la1_init_0();
	   jj_la1_init_1();
	}
	private static void jj_la1_init_0() {
	   jj_la1_0 = new int[] {0x79d90440,0x1810400,0x38580040,0x1810400,0x0,0x0,0x0,0x0,0x0,0x92248040,0x0,0x400000,0x40000000,0x92248040,0x92248040,0x12000040,0x2000040,0x40,0x2000000,0x0,0x2000000,0x2000000,0x80248000,0x100040,0x80000,0x38500040,0x38500040,0x38500040,0x38100040,0x6224000,0x38100040,0x38100040,0x40000000,0x40000000,0x40,0x20088000,0x20000040,0x6224000,0x88000,0x88000,};
	}
	private static void jj_la1_init_1() {
	   jj_la1_1 = new int[] {0x5804,0x800,0x5004,0x800,0x40,0x40,0x40,0x40,0x40,0x6106,0x9,0x0,0x0,0x6106,0x6106,0x4104,0x4100,0x4000,0x100,0x400,0x100,0x100,0x2002,0x4000,0x0,0x5004,0x5004,0x5004,0x5004,0x300,0x5004,0x5004,0x0,0x0,0x4000,0x4080,0x4000,0x300,0x4080,0x4080,};
	}
  private final JJCalls[] jj_2_rtns = new JJCalls[19];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  /**
   * Constructor with InputStream and supplied encoding
   * @param stream input stream
   * @param encoding charset to be used. May not be <code>null</code>.
   */
  public SemanticsParser(final java.io.InputStream stream, final String encoding) {
   try {
     jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
   } catch(final java.io.UnsupportedEncodingException e) {
     throw new IllegalStateException(e);
   }
	 token_source = new SemanticsParserTokenManager(jj_input_stream);
	 token = new Token();
   jj_nt = token_source.getNextToken();
   token.next = jj_nt;
	 jj_gen = 0;
	 for (int i = 0; i < 40; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /**
   * Reinitialise
   * @param stream input stream
   * @param encoding charset to be used. May not be <code>null</code>.
   */
  public void ReInit(final java.io.InputStream stream, final String encoding) {
	  try {
      jj_input_stream.reInit(stream, encoding, 1, 1);
    } catch(final java.io.UnsupportedEncodingException e) { 
      throw new IllegalStateException(e);
    }
	 token_source.ReInit(jj_input_stream);
	 token = new Token();
   jj_nt = token_source.getNextToken();
   token.next = jj_nt;
	 jj_gen = 0;
	 for (int i = 0; i < 40; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /**
   * Constructor with InputStream.
   * @param stream char stream
   */
  public SemanticsParser(final java.io.Reader stream) {
	 jj_input_stream = new SimpleCharStream(stream, 1, 1);
	 token_source = new SemanticsParserTokenManager(jj_input_stream);
	 token = new Token();
	 token.next = jj_nt = token_source.getNextToken();
	 jj_gen = 0;
   for (int i = 0; i < 40; i++)
     jj_la1[i] = -1;
   for (int i = 0; i < jj_2_rtns.length; i++)
     jj_2_rtns[i] = new JJCalls();
  }

  /**
   * Reinitialise
   * @param stream char stream
   */
  public void ReInit(final java.io.Reader stream) {
	if (jj_input_stream == null) {
	  jj_input_stream = new SimpleCharStream(stream, 1, 1);
	} else {
	  jj_input_stream.reInit(stream, 1, 1);
  }
	if (token_source == null) {
 token_source = new SemanticsParserTokenManager(jj_input_stream);
	}

	 token_source.ReInit(jj_input_stream);
	 token = new Token();
	 token.next = jj_nt = token_source.getNextToken();
	 jj_gen = 0;
   for (int i = 0; i < 40; i++)
     jj_la1[i] = -1;
   for (int i = 0; i < jj_2_rtns.length; i++)
     jj_2_rtns[i] = new JJCalls();
  }

  /**
   * Constructor with generated Token Manager.
   * @param tm Token manager to use
   */
  public SemanticsParser(final SemanticsParserTokenManager tm) {
	 token_source = tm;
	 token = new Token();
	 token.next = jj_nt = token_source.getNextToken();
	 jj_gen = 0;
	 for (int i = 0; i < 40; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /**
   * Reinitialise
   * @param tm Token manager to use
   */
  public void ReInit(final SemanticsParserTokenManager tm) {
	 token_source = tm;
	 token = new Token();
	 token.next = jj_nt = token_source.getNextToken();
	 jj_gen = 0;
	 for (int i = 0; i < 40; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  private Token jj_consume_token(final int kind) throws ParseException {
    final Token oldToken = token;
    token = jj_nt;
    if (token.next != null)
      jj_nt = jj_nt.next;
    else {
      jj_nt.next = token_source.getNextToken();
      jj_nt = jj_nt.next;
    }
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen)
              c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    jj_nt = token;
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  private static final class LookaheadSuccess extends IllegalStateException {}
  private final LookaheadSuccess jj_ls = new LookaheadSuccess();
  private boolean jj_scan_token(int kind) {
	 if (jj_scanpos == jj_lastpos) {
	   jj_la--;
	   if (jj_scanpos.next == null) {
		   jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
	   } else {
		   jj_lastpos = jj_scanpos = jj_scanpos.next;
	   }
	 } else {
	   jj_scanpos = jj_scanpos.next;
	 }
	 if (jj_rescan) {
	   int i = 0; Token tok = token;
	   while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
	   if (tok != null) jj_add_error_token(kind, i);
	 }
	 if (jj_scanpos.kind != kind) return true;
	 if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
	 return false;
  }


  /**
   * @return the next Token.
   */
  public final Token getNextToken() {
   token = jj_nt;
   if (token.next != null)
     jj_nt = jj_nt.next;
   else
     jj_nt = jj_nt.next = token_source.getNextToken();
	 jj_gen++;
	 return token;
  }

  /**
   * @param index index to be retrieved
   * @return the specific Token.
   */
  public final Token getToken(final int index) {
    Token t = token;
    for (int i = 0; i < index; i++) {
      if (t.next == null)
        t.next = token_source.getNextToken();
      t = t.next;
    }
    return t;
  }

  private java.util.List<int[]> jj_expentries = new java.util.ArrayList<int[]>();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
  if (pos >= 100) {
    return;
  }

  if (pos == jj_endpos + 1) {
    jj_lasttokens[jj_endpos++] = kind;
  } else if (jj_endpos != 0) {
    jj_expentry = new int[jj_endpos];

    for (int i = 0; i < jj_endpos; i++) {
      jj_expentry[i] = jj_lasttokens[i];
    }

    for (final int[] oldentry : jj_expentries) {
      if (oldentry.length == jj_expentry.length) {
        boolean isMatched = true;
        for (int i = 0; i < jj_expentry.length; i++) {
          if (oldentry[i] != jj_expentry[i]) {
            isMatched = false;
            break;
          }
        }
        if (isMatched) {
          jj_expentries.add(jj_expentry);
          break;
        }
      }
    }

    if (pos != 0) {
      jj_endpos = pos;
      jj_lasttokens[jj_endpos - 1] = kind;
    }
  }
}

  /**
   * Generate ParseException.
   * @return new Exception object. Never <code>null</code>
   */
  public ParseException generateParseException() {
    jj_expentries.clear();
    boolean[] la1tokens = new boolean[47];
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 40; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 47; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.add(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = jj_expentries.get(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  /**
   * @return Always <code>false</code>.
   */
  public final boolean trace_enabled() {
    return false;
  }

  /** Enable tracing. */
  public final void enable_tracing() {}

  /** Disable tracing. */
  public final void disable_tracing() {}

  private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 19; i++) {
      try {
        JJCalls p = jj_2_rtns[i];
        do {
          if (p.gen > jj_gen) {
            jj_la = p.arg;
            jj_scanpos = p.first;
            jj_lastpos = p.first;
            switch (i) {
              case 0: jj_3_1(); break;
              case 1: jj_3_2(); break;
              case 2: jj_3_3(); break;
              case 3: jj_3_4(); break;
              case 4: jj_3_5(); break;
              case 5: jj_3_6(); break;
              case 6: jj_3_7(); break;
              case 7: jj_3_8(); break;
              case 8: jj_3_9(); break;
              case 9: jj_3_10(); break;
              case 10: jj_3_11(); break;
              case 11: jj_3_12(); break;
              case 12: jj_3_13(); break;
              case 13: jj_3_14(); break;
              case 14: jj_3_15(); break;
              case 15: jj_3_16(); break;
              case 16: jj_3_17(); break;
              case 17: jj_3_18(); break;
              case 18: jj_3_19(); break;
            }
          }
          p = p.next;
        } while (p != null);
      } catch(LookaheadSuccess ls) { /* ignore */ }
    }
    jj_rescan = false;
  }

  private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) {
        p.next = new JJCalls();
        p = p.next;
        break;
      }
      p = p.next;
    }
    p.gen = jj_gen + xla - jj_la; 
    p.first = token;
    p.arg = xla;
  }

  static final class JJCalls {
	 int gen;
	 Token first;
	 int arg;
	 JJCalls next;
  }

}
