// ------------   D O   N O T   E D I T !   ------------
// This file is generated from a config definition file.

package com.yahoo.prelude;

import java.util.*;
import java.io.File;
import java.nio.file.Path;
import com.yahoo.config.*;

/**
 * This class represents the root node of emulation
 *
 * Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
 */
public final class EmulationConfig extends ConfigInstance {

  public final static String CONFIG_DEF_MD5 = "43e0cde08e44001d94f2b31c99eac00c";
  public final static String CONFIG_DEF_NAME = "emulation";
  public final static String CONFIG_DEF_NAMESPACE = "prelude";
  public final static String[] CONFIG_DEF_SCHEMA = {
    "namespace=prelude",
    "stringbackedstructs bool default=true",
    "stringbackedfeatures bool default=true"
  };

  public static String getDefMd5()       { return CONFIG_DEF_MD5; }
  public static String getDefName()      { return CONFIG_DEF_NAME; }
  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

  public interface Producer extends ConfigInstance.Producer {
    void getConfig(Builder builder);
  }

  public static final class Builder implements ConfigInstance.Builder {
    private Set<String> __uninitialized = new HashSet<String>();

    private Boolean stringbackedstructs = null;
    private Boolean stringbackedfeatures = null;

    public Builder() { }

    public Builder(EmulationConfig config) {
      stringbackedstructs(config.stringbackedstructs());
      stringbackedfeatures(config.stringbackedfeatures());
    }

    private Builder override(Builder __superior) {
      if (__superior.stringbackedstructs != null)
        stringbackedstructs(__superior.stringbackedstructs);
      if (__superior.stringbackedfeatures != null)
        stringbackedfeatures(__superior.stringbackedfeatures);
      return this;
    }

    public Builder stringbackedstructs(boolean __value) {
      stringbackedstructs = __value;
      return this;
    }

    private Builder stringbackedstructs(String __value) {
      return stringbackedstructs(Boolean.valueOf(__value));
    }

    public Builder stringbackedfeatures(boolean __value) {
      stringbackedfeatures = __value;
      return this;
    }

    private Builder stringbackedfeatures(String __value) {
      return stringbackedfeatures(Boolean.valueOf(__value));
    }

    private boolean _applyOnRestart = false;

    @java.lang.Override
    public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
      if (producer instanceof Producer) {
        ((Producer)producer).getConfig(this);
        return true;
      }
      return false;
    }

    @java.lang.Override
    public final String getDefMd5() { return CONFIG_DEF_MD5; }

    @java.lang.Override
    public final String getDefName() { return CONFIG_DEF_NAME; }

    @java.lang.Override
    public final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

    @java.lang.Override
    public final boolean getApplyOnRestart() { return _applyOnRestart; }

    @java.lang.Override
    public final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }

    public EmulationConfig build() {
      return new EmulationConfig(this);
    }

  }

  // Keep emulating old (4.2, 5.0, early 5.1) string type fields for structured data
  private final BooleanNode stringbackedstructs;
  // Keep emulating old (4.2, 5.0, early 5.1) string type fields for summaryfeatures / rankfeatures fields
  private final BooleanNode stringbackedfeatures;

  public EmulationConfig(Builder builder) {
    this(builder, true);
  }

  private EmulationConfig(Builder builder, boolean throwIfUninitialized) {
    if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
      throw new IllegalArgumentException("The following builder parameters for " +
          "emulation must be initialized: " + builder.__uninitialized);

    stringbackedstructs = (builder.stringbackedstructs == null) ?
        new BooleanNode(true) : new BooleanNode(builder.stringbackedstructs);
    stringbackedfeatures = (builder.stringbackedfeatures == null) ?
        new BooleanNode(true) : new BooleanNode(builder.stringbackedfeatures);
  }

  /**
   * @return emulation.stringbackedstructs
   */
  public boolean stringbackedstructs() {
    return stringbackedstructs.value();
  }

  /**
   * @return emulation.stringbackedfeatures
   */
  public boolean stringbackedfeatures() {
    return stringbackedfeatures.value();
  }

  private ChangesRequiringRestart getChangesRequiringRestart(EmulationConfig newConfig) {
    ChangesRequiringRestart changes = new ChangesRequiringRestart("emulation");
    return changes;
  }

  private static boolean containsFieldsFlaggedWithRestart() {
    return false;
  }


}
