/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.streamingvisitors;

import ai.vespa.searchlib.searchprotocol.protobuf.SearchProtocol;
import com.yahoo.document.select.parser.ParseException;
import com.yahoo.documentapi.AckToken;
import com.yahoo.documentapi.VisitorControlHandler;
import com.yahoo.documentapi.VisitorDataHandler;
import com.yahoo.documentapi.VisitorParameters;
import com.yahoo.documentapi.VisitorSession;
import com.yahoo.documentapi.messagebus.protocol.DocumentProtocol;
import com.yahoo.documentapi.messagebus.protocol.QueryResultMessage;
import com.yahoo.io.GrowableByteBuffer;
import com.yahoo.messagebus.Message;
import com.yahoo.messagebus.Trace;
import com.yahoo.messagebus.routing.Route;
import com.yahoo.prelude.fastsearch.PartialSummaryHandler;
import com.yahoo.prelude.fastsearch.TimeoutException;
import com.yahoo.processing.request.CompoundName;
import com.yahoo.search.Query;
import com.yahoo.search.dispatch.rpc.ProtobufSerialization;
import com.yahoo.search.grouping.vespa.GroupingExecutor;
import com.yahoo.search.query.Model;
import com.yahoo.search.query.Ranking;
import com.yahoo.searchlib.aggregation.Grouping;
import com.yahoo.vdslib.DocumentSummary;
import com.yahoo.vdslib.SearchResult;
import com.yahoo.vdslib.VisitorStatistics;
import com.yahoo.vespa.objects.BufferSerializer;
import com.yahoo.vespa.objects.Deserializer;
import com.yahoo.vespa.objects.Serializer;
import com.yahoo.vespa.streamingvisitors.ListMerger;
import com.yahoo.vespa.streamingvisitors.QueryEncoder;
import com.yahoo.vespa.streamingvisitors.StreamingBackend;
import com.yahoo.vespa.streamingvisitors.Visitor;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

class StreamingVisitor
extends VisitorDataHandler
implements Visitor {
    private static final CompoundName streamingUserid = CompoundName.from((String)"streaming.userid");
    private static final CompoundName streamingGroupname = CompoundName.from((String)"streaming.groupname");
    private static final CompoundName streamingSelection = CompoundName.from((String)"streaming.selection");
    private static final CompoundName streamingFromtimestamp = CompoundName.from((String)"streaming.fromtimestamp");
    private static final CompoundName streamingTotimestamp = CompoundName.from((String)"streaming.totimestamp");
    private static final CompoundName streamingPriority = CompoundName.from((String)"streaming.priority");
    private static final CompoundName streamingMaxbucketspervisitor = CompoundName.from((String)"streaming.maxbucketspervisitor");
    protected static final int MAX_BUCKETS_PER_VISITOR = 1024;
    private static final Logger log = Logger.getLogger(StreamingVisitor.class.getName());
    private final VisitorParameters params = new VisitorParameters("");
    private List<SearchResult.Hit> hits = new ArrayList<SearchResult.Hit>();
    private final Set<String> errors = new TreeSet<String>();
    private int totalHitCount = 0;
    private final Map<String, DocumentSummary.Summary> summaryMap = new HashMap<String, DocumentSummary.Summary>();
    private final Map<Integer, Grouping> groupingMap = new ConcurrentHashMap<Integer, Grouping>();
    private Query query = null;
    private final VisitorSessionFactory visitorSessionFactory;
    private final int traceLevelOverride;
    private Trace sessionTrace;

    public StreamingVisitor(Query query, Route route, VisitorSessionFactory visitorSessionFactory, Visitor.Context context) {
        this.query = query;
        this.visitorSessionFactory = visitorSessionFactory;
        this.traceLevelOverride = context.traceLevelOverride();
        this.setVisitorParameters(route, context);
    }

    private int inferSessionTraceLevel(Query query) {
        int implicitLevel = this.traceLevelOverride;
        if (log.isLoggable(Level.FINEST)) {
            implicitLevel = 9;
        } else if (log.isLoggable(Level.FINE)) {
            implicitLevel = 7;
        }
        return Math.max(query.getTrace().getLevel(), implicitLevel);
    }

    private static String createSelectionString(String documentType, String selection) {
        if (selection == null || selection.isEmpty()) {
            return documentType;
        }
        return documentType + " and ( " + selection + " )";
    }

    private String createQuerySelectionString() {
        String userId = this.query.properties().getString(streamingUserid);
        if (userId != null) {
            return "id.user==" + userId;
        }
        String groupId = this.query.properties().getString(streamingGroupname);
        if (groupId != null) {
            return "id.group==\"" + groupId + "\"";
        }
        return this.query.properties().getString(streamingSelection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setVisitorParameters(Route route, Visitor.Context context) {
        List<Grouping> groupingList;
        this.params.setDocumentSelection(StreamingVisitor.createSelectionString(context.schema(), this.createQuerySelectionString()));
        this.params.setTimeoutMs(this.query.getTimeout());
        this.params.setSessionTimeoutMs(this.query.getTimeout());
        this.params.setVisitorLibrary("searchvisitor");
        this.params.setLocalDataHandler((VisitorDataHandler)this);
        if (this.query.properties().getDouble(streamingFromtimestamp) != null) {
            this.params.setFromTimestamp(this.query.properties().getDouble(streamingFromtimestamp).longValue());
        }
        if (this.query.properties().getDouble(streamingTotimestamp) != null) {
            this.params.setToTimestamp(this.query.properties().getDouble(streamingTotimestamp).longValue());
        }
        this.params.setFieldSet("[all]");
        this.params.visitInconsistentBuckets(true);
        this.params.setPriority(DocumentProtocol.Priority.VERY_HIGH);
        if (this.query.properties().getString(streamingPriority) != null) {
            this.params.setPriority(DocumentProtocol.getPriorityByName((String)this.query.properties().getString(streamingPriority)));
        }
        this.params.setMaxPending(Integer.MAX_VALUE);
        this.params.setMaxBucketsPerVisitor(1024);
        this.params.setTraceLevel(this.inferSessionTraceLevel(this.query));
        String maxbuckets = this.query.properties().getString(streamingMaxbucketspervisitor);
        if (maxbuckets != null) {
            this.params.setMaxBucketsPerVisitor(Integer.parseInt(maxbuckets));
        }
        EncodedData ed = new EncodedData();
        boolean sendProtobuf = context.sendProtobufQuerytree();
        ProtobufSerialization.setProtobufAlsoSerialized(sendProtobuf);
        try {
            StreamingVisitor.encodeQueryData(this.query, 0, ed);
            this.params.setLibraryParameter("query", ed.getEncodedData());
            this.params.setLibraryParameter("querystackcount", String.valueOf(ed.getReturned()));
        }
        finally {
            ProtobufSerialization.setProtobufAlsoSerialized(false);
        }
        if (sendProtobuf) {
            SearchProtocol.QueryTree protobufTree = this.query.getModel().getQueryTree().toProtobufQueryTree();
            this.params.setLibraryParameter("querytree", protobufTree.toByteArray());
        }
        this.params.setLibraryParameter("searchcluster", context.searchCluster().getBytes(StandardCharsets.UTF_8));
        this.params.setLibraryParameter("schema", context.schema().getBytes(StandardCharsets.UTF_8));
        PartialSummaryHandler partialSummaryHandler = context.partialSummaryHandler();
        if (partialSummaryHandler != null) {
            this.params.setLibraryParameter("summaryclass", partialSummaryHandler.askForSummary());
            Set<String> summaryFields = partialSummaryHandler.askForFields();
            if (summaryFields != null) {
                this.params.setLibraryParameter("summary-fields", String.join((CharSequence)" ", summaryFields));
            }
        } else {
            boolean wantSomeFields;
            String wantedSummary = this.query.getPresentation().getSummary();
            Set<String> summaryFields = this.query.getPresentation().getSummaryFields();
            boolean bl = wantSomeFields = summaryFields != null && !summaryFields.isEmpty();
            if (wantedSummary == null || wantedSummary.equals("default")) {
                this.params.setLibraryParameter("summaryclass", "default");
                if (wantSomeFields) {
                    this.params.setLibraryParameter("summary-fields", String.join((CharSequence)" ", summaryFields));
                }
            } else {
                this.params.setLibraryParameter("summaryclass", wantedSummary);
            }
        }
        this.params.setLibraryParameter("summarycount", String.valueOf(this.query.getOffset() + this.query.getHits()));
        this.params.setLibraryParameter("rankprofile", this.query.getRanking().getProfile());
        this.params.setLibraryParameter("allowslimedocsums", "true");
        this.params.setLibraryParameter("queryflags", String.valueOf(StreamingVisitor.getQueryFlags(this.query)));
        ByteBuffer buf = ByteBuffer.allocate(1024);
        if (this.query.getRanking().getLocation() != null) {
            buf.clear();
            this.query.getRanking().getLocation().encode(buf);
            buf.flip();
            byte[] af = new byte[buf.remaining()];
            buf.get(af);
            this.params.setLibraryParameter("location", af);
        }
        if (QueryEncoder.hasEncodableProperties(this.query)) {
            StreamingVisitor.encodeQueryData(this.query, 1, ed);
            this.params.setLibraryParameter("rankproperties", ed.getEncodedData());
        }
        if (!(groupingList = GroupingExecutor.getGroupingList(this.query)).isEmpty()) {
            BufferSerializer gbuf = new BufferSerializer(new GrowableByteBuffer());
            gbuf.putInt(null, groupingList.size());
            for (Grouping g : groupingList) {
                g.serialize((Serializer)gbuf);
            }
            gbuf.flip();
            byte[] blob = gbuf.getBytes(null, gbuf.getBuf().limit());
            this.params.setLibraryParameter("aggregation", blob);
        }
        if (this.query.getRanking().getSorting() != null) {
            StreamingVisitor.encodeQueryData(this.query, 3, ed);
            this.params.setLibraryParameter("sort", ed.getEncodedData());
        }
        this.params.setRoute(route);
    }

    static int getQueryFlags(Query query) {
        int flags = 0;
        flags |= query.properties().getBoolean(Model.ESTIMATE) ? 128 : 0;
        flags |= query.getRanking().getFreshness() != null ? 8192 : 0;
        flags |= 0x8000;
        flags |= query.getNoCache() ? 65536 : 0;
        flags |= 0x20000;
        return flags |= query.properties().getBoolean(Ranking.RANKFEATURES, false) ? 262144 : 0;
    }

    private static void encodeQueryData(Query query, int code, EncodedData ed) {
        ByteBuffer buf = ByteBuffer.allocate(1024);
        while (true) {
            try {
                switch (code) {
                    case 0: {
                        ed.setReturned(query.getModel().getQueryTree().getRoot().encode(buf));
                        break;
                    }
                    case 1: {
                        ed.setReturned(QueryEncoder.encodeAsProperties(query, buf));
                        break;
                    }
                    case 2: {
                        throw new IllegalArgumentException("old aggregation no longer exists!");
                    }
                    case 3: {
                        if (query.getRanking().getSorting() != null) {
                            ed.setReturned(query.getRanking().getSorting().encode(buf));
                            break;
                        }
                        ed.setReturned(0);
                    }
                }
                buf.flip();
            }
            catch (BufferOverflowException e) {
                int size = buf.limit();
                buf = ByteBuffer.allocate(size * 2);
                continue;
            }
            break;
        }
        byte[] bb = new byte[buf.remaining()];
        buf.get(bb);
        ed.setEncodedData(bb);
    }

    @Override
    public void doSearch() throws InterruptedException, ParseException, TimeoutException {
        VisitorSession session = this.visitorSessionFactory.createVisitorSession(this.params);
        try {
            if (!session.waitUntilDone(this.query.getTimeout())) {
                log.log(Level.FINE, () -> "StreamingVisitor returned from waitUntilDone without being completed for " + String.valueOf(this.query) + " with selection " + this.params.getDocumentSelection());
                session.abort();
                throw new TimeoutException("Query timed out in " + StreamingBackend.class.getName());
            }
        }
        finally {
            session.destroy();
            this.sessionTrace = session.getTrace();
            log.log(Level.FINE, () -> this.sessionTrace.toString());
            this.query.trace(this.sessionTrace.toString(), false, 9);
        }
        if (this.params.getControlHandler().getResult().code != VisitorControlHandler.CompletionCode.SUCCESS) {
            throw new IllegalArgumentException("Query failed: " + String.valueOf(this.params.getControlHandler().getResult().code) + ": " + this.params.getControlHandler().getResult().message);
        }
        log.log(Level.FINE, () -> "StreamingVisitor completed successfully for " + String.valueOf(this.query) + " with selection " + this.params.getDocumentSelection());
    }

    @Override
    public VisitorStatistics getStatistics() {
        return this.params.getControlHandler().getVisitorStatistics();
    }

    public void onMessage(Message m, AckToken token) {
        if (!(m instanceof QueryResultMessage)) {
            throw new UnsupportedOperationException("Received unsupported message " + String.valueOf(m) + ". StreamingVisitor can only accept query result messages.");
        }
        QueryResultMessage qm = (QueryResultMessage)m;
        this.onQueryResult(qm.getResult(), qm.getSummary());
        this.ack(token);
    }

    @Override
    public Trace getTrace() {
        return this.sessionTrace;
    }

    public void onQueryResult(SearchResult sr, DocumentSummary summary) {
        this.handleSearchResult(sr);
        this.handleSummary(summary);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSearchResult(SearchResult result) {
        log.log(Level.FINE, () -> "Got SearchResult with " + result.getTotalHitCount() + " in total and " + result.getHitCount() + " hits in real for query with selection " + this.params.getDocumentSelection());
        ArrayList<SearchResult.Hit> newHits = new ArrayList<SearchResult.Hit>(result.getHitCount());
        for (int i = 0; i < result.getHitCount(); ++i) {
            newHits.add(result.getHit(i));
        }
        StreamingVisitor i = this;
        synchronized (i) {
            String[] newErrors;
            this.totalHitCount += result.getTotalHitCount();
            this.hits = ListMerger.mergeIntoArrayList(this.hits, newHits, this.query.getOffset() + this.query.getHits());
            for (String error : newErrors = result.getErrors()) {
                this.errors.add(error);
            }
        }
        Map newGroupingMap = result.getGroupingList();
        this.mergeGroupingMaps(newGroupingMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mergeGroupingMaps(Map<Integer, byte[]> newGroupingMap) {
        log.log(Level.FINEST, () -> "mergeGroupingMaps: newGroupingMap = " + String.valueOf(newGroupingMap));
        for (Integer key : newGroupingMap.keySet()) {
            byte[] value = newGroupingMap.get(key);
            log.log(Level.FINEST, () -> "Received group with key " + key + " and size " + value.length);
            Grouping newGrouping = new Grouping();
            BufferSerializer buf = new BufferSerializer(new GrowableByteBuffer(ByteBuffer.wrap(value)));
            newGrouping.deserialize((Deserializer)buf);
            if (buf.getBuf().hasRemaining()) {
                throw new IllegalArgumentException("Failed deserializing grouping. There is still data left. Position = " + buf.position() + ", limit = " + buf.getBuf().limit());
            }
            Map<Integer, Grouping> map = this.groupingMap;
            synchronized (map) {
                if (this.groupingMap.containsKey(key)) {
                    Grouping grouping = this.groupingMap.get(key);
                    grouping.merge(newGrouping);
                } else {
                    this.groupingMap.put(key, newGrouping);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSummary(DocumentSummary ds) {
        int summaryCount = ds.getSummaryCount();
        log.log(Level.FINE, () -> "Got DocumentSummary with " + summaryCount + " summaries for query with selection " + this.params.getDocumentSelection());
        Map<String, DocumentSummary.Summary> map = this.summaryMap;
        synchronized (map) {
            for (int i = 0; i < summaryCount; ++i) {
                DocumentSummary.Summary summary = ds.getSummary(i);
                this.summaryMap.put(summary.getDocId(), summary);
            }
        }
    }

    @Override
    public final List<SearchResult.Hit> getHits() {
        int fromIndex = Math.min(this.hits.size(), this.query.getOffset());
        int toIndex = Math.min(this.hits.size(), this.query.getOffset() + this.query.getHits());
        return this.hits.subList(fromIndex, toIndex);
    }

    @Override
    public final Map<String, DocumentSummary.Summary> getSummaryMap() {
        return this.summaryMap;
    }

    @Override
    public final int getTotalHitCount() {
        return this.totalHitCount;
    }

    @Override
    public final List<Grouping> getGroupings() {
        Collection<Grouping> groupings = this.groupingMap.values();
        for (Grouping g : groupings) {
            g.postMerge();
        }
        return new ArrayList<Grouping>(groupings);
    }

    @Override
    public Set<String> getErrors() {
        return Set.copyOf(this.errors);
    }

    public static interface VisitorSessionFactory {
        public VisitorSession createVisitorSession(VisitorParameters var1) throws ParseException;
    }

    private static class EncodedData {
        private Object returned;
        private byte[] encoded;

        private EncodedData() {
        }

        public void setReturned(Object o) {
            this.returned = o;
        }

        public Object getReturned() {
            return this.returned;
        }

        public void setEncodedData(byte[] data) {
            this.encoded = data;
        }

        public byte[] getEncodedData() {
            return this.encoded;
        }
    }
}

