/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.schema;

import com.yahoo.search.schema.DocumentSummary;
import com.yahoo.search.schema.Field;
import com.yahoo.search.schema.FieldInfo;
import com.yahoo.search.schema.FieldSet;
import com.yahoo.search.schema.RankProfile;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class Schema {
    private final String name;
    private final Map<String, Field> fields;
    private final Map<String, FieldSet> fieldSets;
    private final Map<String, RankProfile> rankProfiles;
    private final Map<String, DocumentSummary> documentSummaries;
    private final Map<String, Field> fieldsByAliases;

    private Schema(Builder builder) {
        this.name = builder.name;
        this.fields = Collections.unmodifiableMap(builder.fields);
        this.fieldSets = Collections.unmodifiableMap(builder.fieldSets);
        this.rankProfiles = Collections.unmodifiableMap(builder.rankProfiles);
        this.documentSummaries = Collections.unmodifiableMap(builder.documentSummaries);
        this.fieldSets.values().forEach(fieldSet -> fieldSet.setSchema(this));
        this.rankProfiles.values().forEach(rankProfile -> rankProfile.setSchema(this));
        this.fieldsByAliases = new HashMap<String, Field>();
        for (Field field : this.fields.values()) {
            this.fieldsByAliases.put(field.name(), field);
            field.aliases().forEach(alias -> this.fieldsByAliases.put((String)alias, field));
        }
    }

    public String name() {
        return this.name;
    }

    public Map<String, Field> fields() {
        return this.fields;
    }

    public Map<String, FieldSet> fieldSets() {
        return this.fieldSets;
    }

    public Map<String, RankProfile> rankProfiles() {
        return this.rankProfiles;
    }

    public Map<String, DocumentSummary> documentSummaries() {
        return this.documentSummaries;
    }

    public Optional<FieldInfo> fieldInfo(String fieldName) {
        Field field;
        if (fieldName.isEmpty()) {
            fieldName = "default";
        }
        if ((field = this.fieldsByAliases.get(fieldName)) != null) {
            return Optional.of(field);
        }
        return Optional.ofNullable((FieldInfo)this.fieldSets.get(fieldName));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Schema)) {
            return false;
        }
        Schema other = (Schema)o;
        if (!other.name.equals(this.name)) {
            return false;
        }
        if (!other.fields.equals(this.fields)) {
            return false;
        }
        if (!other.fieldSets.equals(this.fieldSets)) {
            return false;
        }
        if (!other.rankProfiles.equals(this.rankProfiles)) {
            return false;
        }
        return other.documentSummaries.equals(this.documentSummaries);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.rankProfiles, this.documentSummaries);
    }

    public String toString() {
        return "schema '" + this.name + "'";
    }

    public static class Builder {
        private final String name;
        private final Map<String, Field> fields = new LinkedHashMap<String, Field>();
        private final Map<String, FieldSet> fieldSets = new LinkedHashMap<String, FieldSet>();
        private final Map<String, RankProfile> rankProfiles = new LinkedHashMap<String, RankProfile>();
        private final Map<String, DocumentSummary> documentSummaries = new LinkedHashMap<String, DocumentSummary>();

        public Builder(String name) {
            this.name = Objects.requireNonNull(name);
        }

        public Builder add(Field field) {
            this.fields.put(field.name(), field);
            return this;
        }

        public Builder add(FieldSet fieldSet) {
            this.fieldSets.put(fieldSet.name(), fieldSet);
            return this;
        }

        public Builder add(RankProfile profile) {
            this.rankProfiles.put(profile.name(), profile);
            return this;
        }

        public Builder add(DocumentSummary documentSummary) {
            this.documentSummaries.put(documentSummary.name(), documentSummary);
            return this;
        }

        public Schema build() {
            return new Schema(this);
        }
    }
}

