/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.schema;

import com.yahoo.container.QrSearchersConfig;
import com.yahoo.search.config.SchemaInfoConfig;
import com.yahoo.search.schema.Cluster;
import com.yahoo.search.schema.DocumentSummary;
import com.yahoo.search.schema.Field;
import com.yahoo.search.schema.RankProfile;
import com.yahoo.search.schema.Schema;
import java.util.ArrayList;
import java.util.List;

class SchemaInfoConfigurer {
    SchemaInfoConfigurer() {
    }

    static List<Schema> toSchemas(SchemaInfoConfig schemaInfoConfig) {
        return schemaInfoConfig.schema().stream().map(SchemaInfoConfigurer::toSchema).toList();
    }

    static Schema toSchema(SchemaInfoConfig.Schema schemaInfoConfig) {
        Schema.Builder schemaBuilder = new Schema.Builder(schemaInfoConfig.name());
        for (SchemaInfoConfig.Schema.Field fieldConfig : schemaInfoConfig.field()) {
            Field.Builder fieldBuilder = new Field.Builder(fieldConfig.name(), fieldConfig.type());
            fieldBuilder.setAttribute(fieldConfig.attribute());
            fieldBuilder.setIndex(fieldConfig.index());
            fieldBuilder.setBitPacked(fieldConfig.index());
            for (String alias : fieldConfig.alias()) {
                fieldBuilder.addAlias(alias);
            }
            schemaBuilder.add(fieldBuilder.build());
        }
        for (SchemaInfoConfig.Schema.Rankprofile profileConfig : schemaInfoConfig.rankprofile()) {
            RankProfile.Builder profileBuilder = new RankProfile.Builder(profileConfig.name()).setHasSummaryFeatures(profileConfig.hasSummaryFeatures()).setHasRankFeatures(profileConfig.hasRankFeatures()).setUseSignificanceModel(profileConfig.significance().useModel());
            for (SchemaInfoConfig.Schema.Rankprofile.Input inputConfig : profileConfig.input()) {
                profileBuilder.addInput(inputConfig.name(), RankProfile.InputType.fromSpec(inputConfig.type()));
            }
            schemaBuilder.add(profileBuilder.build());
        }
        for (SchemaInfoConfig.Schema.Summaryclass summaryConfig : schemaInfoConfig.summaryclass()) {
            DocumentSummary.Builder summaryBuilder = new DocumentSummary.Builder(summaryConfig.name());
            for (SchemaInfoConfig.Schema.Summaryclass.Fields field : summaryConfig.fields()) {
                if (field.dynamic()) {
                    summaryBuilder.setDynamic(true);
                }
                summaryBuilder.add(new DocumentSummary.Field(field.name(), field.type()));
            }
            schemaBuilder.add(summaryBuilder.build());
        }
        return schemaBuilder.build();
    }

    static List<Cluster> toClusters(QrSearchersConfig config) {
        ArrayList<Cluster> clusters = new ArrayList<Cluster>();
        for (QrSearchersConfig.Searchcluster searchCluster : config.searchcluster()) {
            String clusterName = searchCluster.name();
            Cluster.Builder clusterInfo = new Cluster.Builder(clusterName);
            clusterInfo.setStreaming(searchCluster.indexingmode() == QrSearchersConfig.Searchcluster.Indexingmode.Enum.STREAMING);
            for (String schemaDef : searchCluster.searchdef()) {
                clusterInfo.addSchema(schemaDef);
            }
            clusters.add(clusterInfo.build());
        }
        return clusters;
    }
}

