/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.searchchain;

import com.yahoo.component.AbstractComponent;
import com.yahoo.component.ComponentId;
import com.yahoo.component.ComponentSpecification;
import com.yahoo.component.chain.Chain;
import com.yahoo.component.provider.ComponentRegistry;
import com.yahoo.processing.execution.chain.ChainRegistry;
import com.yahoo.search.Searcher;
import com.yahoo.search.searchchain.SearchChain;
import com.yahoo.search.searchchain.SearcherRegistry;

public class SearchChainRegistry
extends ChainRegistry<Searcher> {
    private final SearcherRegistry searcherRegistry;

    public void freeze() {
        super.freeze();
        this.getSearcherRegistry().freeze();
    }

    public SearchChainRegistry() {
        this.searcherRegistry = new SearcherRegistry();
        this.searcherRegistry.freeze();
    }

    public SearchChainRegistry(ComponentRegistry<? extends AbstractComponent> allComponentRegistry) {
        this.searcherRegistry = this.setupSearcherRegistry(allComponentRegistry);
    }

    public void register(Chain<Searcher> component) {
        super.register(component.getId(), component);
    }

    public Chain<Searcher> unregister(Chain<Searcher> component) {
        return (Chain)super.unregister(component.getId());
    }

    private SearcherRegistry setupSearcherRegistry(ComponentRegistry<? extends AbstractComponent> allComponents) {
        SearcherRegistry registry = new SearcherRegistry();
        for (AbstractComponent component : allComponents.allComponents()) {
            if (!(component instanceof Searcher)) continue;
            registry.register((Searcher)component);
        }
        registry.freeze();
        return registry;
    }

    public SearcherRegistry getSearcherRegistry() {
        return this.searcherRegistry;
    }

    public SearchChain getComponent(ComponentId id) {
        Chain chain = (Chain)super.getComponent(id);
        return this.asSearchChain((Chain<Searcher>)chain);
    }

    public SearchChain getComponent(ComponentSpecification specification) {
        return this.asSearchChain((Chain<Searcher>)((Chain)super.getComponent(specification)));
    }

    public final Chain<Searcher> getChain(String componentSpecification) {
        return (Chain)super.getComponent(new ComponentSpecification(componentSpecification));
    }

    public final Chain<Searcher> getChain(ComponentId id) {
        return (Chain)super.getComponent(id);
    }

    public SearchChain getComponent(String componentSpecification) {
        return this.getComponent(new ComponentSpecification(componentSpecification));
    }

    private SearchChain asSearchChain(Chain<Searcher> chain) {
        if (chain == null) {
            return null;
        }
        if (chain instanceof SearchChain) {
            return (SearchChain)chain;
        }
        return new SearchChain(chain);
    }
}

