/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.ranking;

import com.yahoo.search.ranking.Normalizer;

class LinearNormalizer
extends Normalizer {
    LinearNormalizer(int maxSize) {
        super(maxSize);
    }

    @Override
    void normalize() {
        double min = 3.4028234663852886E38;
        double max = -3.4028234663852886E38;
        for (int i = 0; i < this.size; ++i) {
            double val = this.data[i];
            if (!(val < 3.4028234663852886E38) || !(val > -3.4028234663852886E38)) continue;
            min = Math.min(min, this.data[i]);
            max = Math.max(max, this.data[i]);
        }
        double scale = 0.0;
        double midpoint = 0.0;
        if (max > min) {
            scale = 1.0 / (max - min);
            midpoint = (min + max) * 0.5;
        }
        for (int i = 0; i < this.size; ++i) {
            double old = this.data[i];
            this.data[i] = 0.5 + scale * (old - midpoint);
        }
    }

    @Override
    String normalizing() {
        return "linear";
    }
}

