/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.federation.sourceref;

import com.yahoo.component.ComponentSpecification;
import com.yahoo.processing.request.Properties;
import com.yahoo.search.federation.sourceref.ResolveResult;
import com.yahoo.search.federation.sourceref.SearchChainResolver;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SourceRefResolver {
    private final SearchChainResolver searchChainResolver;
    private final Map<String, List<String>> schema2Clusters;

    public SourceRefResolver(SearchChainResolver searchChainResolver, Map<String, List<String>> schema2Clusters) {
        this.searchChainResolver = searchChainResolver;
        this.schema2Clusters = schema2Clusters;
    }

    public List<ResolveResult> resolve(ComponentSpecification sourceRef, Properties sourceToProviderMap) {
        ResolveResult searchChainResolveResult = this.searchChainResolver.resolve(sourceRef, sourceToProviderMap);
        if (searchChainResolveResult.invocationSpec() == null) {
            return this.resolveClustersWithDocument(sourceRef, sourceToProviderMap);
        }
        return List.of(searchChainResolveResult);
    }

    private List<ResolveResult> resolveClustersWithDocument(ComponentSpecification sourceRef, Properties sourceToProviderMap) {
        if (this.hasOnlyName(sourceRef)) {
            ArrayList<ResolveResult> clusterSearchChains = new ArrayList<ResolveResult>();
            List clusters = this.schema2Clusters.getOrDefault(sourceRef.getName(), List.of());
            for (String cluster : clusters) {
                clusterSearchChains.add(this.resolveClusterSearchChain(cluster, sourceRef, sourceToProviderMap));
            }
            if (!clusterSearchChains.isEmpty()) {
                return clusterSearchChains;
            }
        }
        return List.of(new ResolveResult(SourceRefResolver.createForMissingSourceRef(sourceRef)));
    }

    static String createForMissingSourceRef(ComponentSpecification source) {
        return "Could not resolve source ref '" + String.valueOf(source) + "'.";
    }

    private ResolveResult resolveClusterSearchChain(String cluster, ComponentSpecification sourceRef, Properties sourceToProviderMap) {
        ResolveResult resolveResult = this.searchChainResolver.resolve(new ComponentSpecification(cluster), sourceToProviderMap);
        if (resolveResult.invocationSpec() == null) {
            return new ResolveResult("Failed to resolve cluster search chain '" + cluster + "' when using source ref '" + String.valueOf(sourceRef) + "' as a document name.");
        }
        return resolveResult;
    }

    private boolean hasOnlyName(ComponentSpecification sourceSpec) {
        return new ComponentSpecification(sourceSpec.getName()).equals((Object)sourceSpec);
    }
}

