/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.ranking;

import com.yahoo.component.annotation.Inject;
import com.yahoo.data.access.Inspector;
import com.yahoo.data.access.helpers.MatchFeatureData;
import com.yahoo.data.access.helpers.MatchFeatureFilter;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.query.Sorting;
import com.yahoo.search.ranking.Evaluator;
import com.yahoo.search.ranking.FunEvalSpec;
import com.yahoo.search.ranking.GlobalPhaseSetup;
import com.yahoo.search.ranking.HitRescorer;
import com.yahoo.search.ranking.NormalizerContext;
import com.yahoo.search.ranking.NormalizerSetup;
import com.yahoo.search.ranking.PreparedInput;
import com.yahoo.search.ranking.RankProfilesEvaluatorFactory;
import com.yahoo.search.ranking.ResultReranker;
import com.yahoo.search.result.ErrorMessage;
import com.yahoo.search.result.FeatureData;
import com.yahoo.search.result.Hit;
import com.yahoo.search.result.HitGroup;
import com.yahoo.tensor.Tensor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Logger;

public class GlobalPhaseRanker {
    private static final Logger logger = Logger.getLogger(GlobalPhaseRanker.class.getName());
    private final RankProfilesEvaluatorFactory factory;

    @Inject
    public GlobalPhaseRanker(RankProfilesEvaluatorFactory factory) {
        this.factory = factory;
        logger.fine(() -> "Using factory: " + String.valueOf(factory));
    }

    public int getRerankCount(Query query, String schema) {
        GlobalPhaseSetup setup = this.globalPhaseSetupFor(query, schema).orElse(null);
        return GlobalPhaseRanker.resolveRerankCount(setup, query);
    }

    public Optional<ErrorMessage> validateNoSorting(Query query, String schema) {
        GlobalPhaseSetup setup = this.globalPhaseSetupFor(query, schema).orElse(null);
        if (setup == null) {
            return Optional.empty();
        }
        Sorting sorting = query.getRanking().getSorting();
        if (sorting == null) {
            return Optional.empty();
        }
        if (sorting.fieldOrders() == null || sorting.fieldOrders().isEmpty()) {
            return Optional.of(ErrorMessage.createIllegalQuery("Invalid sorting for global phase"));
        }
        for (Sorting.FieldOrder fieldOrder : sorting.fieldOrders()) {
            if (fieldOrder.getSorter().getName().equals("[rank]") && fieldOrder.getSortOrder() == Sorting.Order.DESCENDING) continue;
            return Optional.of(ErrorMessage.createIllegalQuery("Sorting is not supported with global phase"));
        }
        return Optional.empty();
    }

    static void rerankHitsImpl(GlobalPhaseSetup setup, Query query, Result result) {
        FunEvalSpec mainSpec = setup.globalPhaseEvalSpec;
        Supplier<Evaluator> mainSrc = GlobalPhaseRanker.withQueryPrep(mainSpec.evalSource(), mainSpec.fromQuery(), setup.defaultValues, query);
        int rerankCount = GlobalPhaseRanker.resolveRerankCount(setup, query);
        double rankScoreDropLimit = GlobalPhaseRanker.resolveRankScoreDropLimit(setup, query);
        ArrayList<NormalizerContext> normalizers = new ArrayList<NormalizerContext>();
        for (NormalizerSetup nSetup : setup.normalizers) {
            FunEvalSpec normSpec = nSetup.inputEvalSpec();
            Supplier<Evaluator> normEvalSrc = GlobalPhaseRanker.withQueryPrep(normSpec.evalSource(), normSpec.fromQuery(), setup.defaultValues, query);
            normalizers.add(new NormalizerContext(nSetup.name(), nSetup.supplier().get(), normEvalSrc, normSpec.fromMF()));
        }
        HitRescorer rescorer = new HitRescorer(mainSrc, mainSpec.fromMF(), normalizers);
        ResultReranker reranker = new ResultReranker(rescorer, rerankCount);
        reranker.rerankHits(result);
        GlobalPhaseRanker.removeBelowRankScoreDropLimit(result, rankScoreDropLimit);
        GlobalPhaseRanker.hideImplicitMatchFeatures(result, setup.matchFeaturesToHide);
    }

    private static void removeBelowRankScoreDropLimit(Result result, double rankScoreDropLimit) {
        if (rankScoreDropLimit == -1.7976931348623157E308) {
            return;
        }
        List<Hit> toBeRemoved = result.hits().asList().stream().filter(hit -> hit.getRelevance().getScore() <= rankScoreDropLimit).toList();
        for (Hit hitToRemove : toBeRemoved) {
            result.hits().remove(hitToRemove.getId());
        }
        int removedCount = toBeRemoved.size();
        result.setTotalHitCount(result.getTotalHitCount() - (long)removedCount);
    }

    public void rerankHits(Query query, Result result, String schema) {
        Optional<GlobalPhaseSetup> setup = this.globalPhaseSetupFor(query, schema);
        if (setup.isPresent()) {
            GlobalPhaseRanker.rerankHitsImpl(setup.get(), query, result);
        }
    }

    static Supplier<Evaluator> withQueryPrep(Supplier<Evaluator> evalSource, List<String> queryFeatures, Map<String, Tensor> defaultValues, Query query) {
        List<PreparedInput> prepared = PreparedInput.findFromQuery(query, queryFeatures, defaultValues);
        Supplier<Evaluator> supplier = () -> {
            Evaluator evaluator = (Evaluator)evalSource.get();
            for (PreparedInput entry : prepared) {
                evaluator.bind(entry.name(), entry.value());
            }
            return evaluator;
        };
        return supplier;
    }

    private static void hideImplicitMatchFeatures(Result result, Collection<String> namesToHide) {
        if (namesToHide.isEmpty()) {
            return;
        }
        MatchFeatureFilter filter = new MatchFeatureFilter(namesToHide);
        Iterator<Hit> iterator = result.hits().deepIterator();
        while (iterator.hasNext()) {
            FeatureData matchFeatures;
            Inspector inspector;
            Object object;
            Hit hit = iterator.next();
            if (hit.isMeta() || hit instanceof HitGroup || !((object = hit.getField("matchfeatures")) instanceof FeatureData) || !((inspector = (matchFeatures = (FeatureData)object).inspect()) instanceof MatchFeatureData.HitValue)) continue;
            MatchFeatureData.HitValue hitValue = (MatchFeatureData.HitValue)inspector;
            MatchFeatureData.HitValue newValue = hitValue.subsetFilter((Function)filter);
            if (newValue.fieldCount() == 0) {
                hit.removeField("matchfeatures");
                continue;
            }
            hit.setField("matchfeatures", new FeatureData((Inspector)newValue));
        }
    }

    private Optional<GlobalPhaseSetup> globalPhaseSetupFor(Query query, String schema) {
        return this.factory.evaluatorForSchema(schema).flatMap(evaluator -> evaluator.getGlobalPhaseSetup(query.getRanking().getProfile()));
    }

    private static int resolveRerankCount(GlobalPhaseSetup setup, Query query) {
        if (setup == null) {
            return 0;
        }
        Integer override = query.getRanking().getGlobalPhase().getRerankCount();
        if (override != null) {
            return override;
        }
        return setup.rerankCount;
    }

    private static double resolveRankScoreDropLimit(GlobalPhaseSetup setup, Query query) {
        if (setup == null) {
            return -1.7976931348623157E308;
        }
        Double override = query.getRanking().getGlobalPhase().getRankScoreDropLimit();
        if (override != null) {
            return override;
        }
        return setup.rankScoreDropLimit;
    }
}

