/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.querytransform;

import com.yahoo.language.LinguisticsCase;
import com.yahoo.prelude.IndexFacts;
import com.yahoo.prelude.query.AndItem;
import com.yahoo.prelude.query.CompositeItem;
import com.yahoo.prelude.query.Highlight;
import com.yahoo.prelude.query.Item;
import com.yahoo.prelude.query.SameElementItem;
import com.yahoo.prelude.query.StringInItem;
import com.yahoo.prelude.query.WeightedSetItem;
import com.yahoo.prelude.query.WordAlternativesItem;
import com.yahoo.prelude.query.WordItem;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.Searcher;
import com.yahoo.search.querytransform.LowercasingConfig;
import com.yahoo.search.searchchain.Execution;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;

public abstract class LowercasingSearcher
extends Searcher {
    private final boolean transformWeightedSets;

    public LowercasingSearcher() {
        this(new LowercasingConfig(new LowercasingConfig.Builder()));
    }

    public LowercasingSearcher(LowercasingConfig cfg) {
        this.transformWeightedSets = cfg.transform_weighted_sets();
    }

    @Override
    public Result search(Query query, Execution execution) {
        IndexFacts.Session indexFacts = execution.context().getIndexFacts().newSession(query);
        this.traverse(query.getModel().getQueryTree(), indexFacts);
        this.traverseHighlight(query.getPresentation().getHighlight(), indexFacts);
        query.trace("Lowercasing", true, 2);
        return execution.search(query);
    }

    private void traverseHighlight(Highlight highlight, IndexFacts.Session indexFacts) {
        if (highlight == null) {
            return;
        }
        for (AndItem item : highlight.getHighlightItems().values()) {
            this.traverse(item, indexFacts);
        }
    }

    private void traverse(CompositeItem base, IndexFacts.Session indexFacts) {
        ListIterator<Item> i = base.getItemIterator();
        while (i.hasNext()) {
            Item next = (Item)i.next();
            if (next instanceof WordItem) {
                this.lowerCase((WordItem)next, indexFacts);
                continue;
            }
            if (next instanceof SameElementItem) {
                this.traverseSameElement((SameElementItem)next, indexFacts);
                continue;
            }
            if (next instanceof CompositeItem) {
                this.traverse((CompositeItem)next, indexFacts);
                continue;
            }
            if (next instanceof WeightedSetItem) {
                if (!this.transformWeightedSets) continue;
                this.lowerCase((WeightedSetItem)next, indexFacts);
                continue;
            }
            if (next instanceof WordAlternativesItem) {
                this.lowerCase((WordAlternativesItem)next, indexFacts);
                continue;
            }
            if (!(next instanceof StringInItem)) continue;
            this.lowerCase((StringInItem)next, indexFacts);
        }
    }

    private void traverseSameElement(SameElementItem base, IndexFacts.Session indexFacts) {
        ListIterator<Item> i = base.getItemIterator();
        while (i.hasNext()) {
            Item next = (Item)i.next();
            if (!(next instanceof WordItem)) continue;
            this.lowerCase(base.getFieldName(), (WordItem)next, indexFacts);
        }
    }

    private void lowerCase(WordItem word, IndexFacts.Session indexFacts) {
        if (this.shouldLowercase(word, indexFacts)) {
            word.setWord(LinguisticsCase.toLowerCase((String)word.getWord()));
            word.setLowercased(true);
        }
    }

    private void lowerCase(String commonPath, WordItem word, IndexFacts.Session indexFacts) {
        if (this.shouldLowercase(commonPath, word, indexFacts)) {
            word.setWord(LinguisticsCase.toLowerCase((String)word.getWord()));
            word.setLowercased(true);
        }
    }

    private boolean syntheticLowerCaseCheck(String indexName, IndexFacts.Session indexFacts, boolean isFromQuery) {
        WordItem w = new WordItem("not-used", indexName, isFromQuery);
        return this.shouldLowercase(w, indexFacts);
    }

    private void lowerCase(WeightedSetItem set, IndexFacts.Session indexFacts) {
        if (!this.syntheticLowerCaseCheck(set.getIndexName(), indexFacts, true)) {
            return;
        }
        ArrayList<WeightedSetToken> terms = new ArrayList<WeightedSetToken>(set.getNumTokens());
        Iterator<Map.Entry<Object, Integer>> i = set.getTokens();
        while (i.hasNext()) {
            String token;
            String originalToken;
            Map.Entry<Object, Integer> e = i.next();
            if (!(e.getKey() instanceof String) || (originalToken = (String)e.getKey()).equals(token = LinguisticsCase.toLowerCase((String)originalToken))) continue;
            terms.add(new WeightedSetToken(token, originalToken, e.getValue()));
        }
        for (WeightedSetToken t : terms) {
            set.removeToken(t.originalToken);
            set.addToken(t.token, t.weight);
        }
    }

    private void lowerCase(WordAlternativesItem alternatives, IndexFacts.Session indexFacts) {
        if (alternatives.isLowercased()) {
            return;
        }
        if (!this.syntheticLowerCaseCheck(alternatives.getIndexName(), indexFacts, alternatives.isFromQuery())) {
            return;
        }
        for (WordAlternativesItem.Alternative term : alternatives.getAlternatives()) {
            String lowerCased = LinguisticsCase.toLowerCase((String)term.word);
            alternatives.addTerm(lowerCased, term.exactness * 0.7);
        }
    }

    private void lowerCase(StringInItem set, IndexFacts.Session indexFacts) {
        if (!this.syntheticLowerCaseCheck(set.getIndexName(), indexFacts, true)) {
            return;
        }
        Collection<String> originalTokens = set.getTokens();
        for (String originalToken : originalTokens) {
            String token;
            if (originalToken.equals(token = LinguisticsCase.toLowerCase((String)originalToken))) continue;
            set.removeToken(originalToken);
            set.addToken(token);
        }
    }

    public abstract boolean shouldLowercase(WordItem var1, IndexFacts.Session var2);

    public abstract boolean shouldLowercase(String var1, WordItem var2, IndexFacts.Session var3);

    private static final class WeightedSetToken {
        final String token;
        final String originalToken;
        final int weight;

        WeightedSetToken(String token, String originalToken, int weight) {
            this.token = token;
            this.originalToken = originalToken;
            this.weight = weight;
        }
    }
}

