/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.schema;

import com.yahoo.search.schema.Field;
import com.yahoo.search.schema.FieldInfo;
import com.yahoo.search.schema.Schema;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class FieldSet
implements FieldInfo {
    private final String name;
    private final Set<String> fieldNames;
    private Schema schema = null;

    private FieldSet(Builder builder) {
        this.name = builder.name;
        this.fieldNames = Set.copyOf(builder.fieldNames);
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Field.Type type() {
        if (this.schema == null || this.fieldNames.isEmpty()) {
            return null;
        }
        return this.randomFieldInThis().type();
    }

    @Override
    public boolean isAttribute() {
        if (this.schema == null || this.fieldNames.isEmpty()) {
            return false;
        }
        return this.randomFieldInThis().isAttribute();
    }

    @Override
    public boolean isIndex() {
        if (this.schema == null || this.fieldNames.isEmpty()) {
            return false;
        }
        return this.randomFieldInThis().isIndex();
    }

    void setSchema(Schema schema) {
        if (this.schema != null) {
            throw new IllegalStateException("Cannot add field set '" + this.name + "' to schema '" + schema.name() + "' as it is already added to schema '" + this.schema.name() + "'");
        }
        this.schema = schema;
    }

    private Field randomFieldInThis() {
        return this.schema.fields().get(this.fieldNames.iterator().next());
    }

    public Set<String> fieldNames() {
        return this.fieldNames;
    }

    public boolean equals(Object o) {
        if (!(o instanceof FieldSet)) {
            return false;
        }
        FieldSet other = (FieldSet)o;
        if (!this.name.equals(other.name)) {
            return false;
        }
        return this.fieldNames.equals(other.fieldNames);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.fieldNames);
    }

    public String toString() {
        return "field set '" + this.name + "'";
    }

    public static class Builder {
        private final String name;
        private final Set<String> fieldNames = new HashSet<String>();

        public Builder(String name) {
            this.name = name;
        }

        public Builder addField(String fieldName) {
            this.fieldNames.add(fieldName);
            return this;
        }

        public FieldSet build() {
            return new FieldSet(this);
        }
    }
}

