/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.grouping.vespa;

import com.yahoo.search.grouping.vespa.EncodableContinuation;
import com.yahoo.search.grouping.vespa.IntegerDecoder;
import com.yahoo.search.grouping.vespa.IntegerEncoder;
import com.yahoo.search.grouping.vespa.ResultId;

class OffsetContinuation
extends EncodableContinuation {
    public static final int FLAG_UNSTABLE = 1;
    private final ResultId resultId;
    private final int tag;
    private final int offset;
    private final int flags;

    public OffsetContinuation(ResultId resultId, int tag, int offset, int flags) {
        resultId.getClass();
        this.resultId = resultId;
        this.tag = tag;
        this.offset = offset;
        this.flags = flags;
    }

    @Override
    public OffsetContinuation copy() {
        return this;
    }

    public ResultId getResultId() {
        return this.resultId;
    }

    public int getTag() {
        return this.tag;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getFlags() {
        return this.flags;
    }

    public boolean testFlag(int flag) {
        return (this.flags & flag) != 0;
    }

    public int hashCode() {
        return this.resultId.hashCode() + this.offset + this.flags;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof OffsetContinuation)) {
            return false;
        }
        OffsetContinuation rhs = (OffsetContinuation)obj;
        if (!this.resultId.equals(rhs.resultId)) {
            return false;
        }
        if (this.tag != rhs.tag) {
            return false;
        }
        if (this.offset != rhs.offset) {
            return false;
        }
        return this.flags == rhs.flags;
    }

    @Override
    public void encode(IntegerEncoder out) {
        this.resultId.encode(out);
        out.append(this.tag);
        out.append(this.offset);
        out.append(this.flags);
    }

    public static OffsetContinuation decode(IntegerDecoder in) {
        ResultId resultId = ResultId.decode(in);
        int tag = in.next();
        int offset = in.next();
        int flags = in.next();
        return new OffsetContinuation(resultId, tag, offset, flags);
    }
}

