/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.query;

import com.yahoo.compress.IntegerCompressor;
import com.yahoo.prelude.query.Item;
import com.yahoo.prelude.query.NonReducibleCompositeItem;
import com.yahoo.prelude.query.SegmentItem;
import com.yahoo.prelude.query.textualrepresentation.Discloser;
import java.nio.ByteBuffer;
import java.util.Objects;

public final class WeakAndItem
extends NonReducibleCompositeItem {
    public static final int defaultN = 100;
    private int n;
    private String index;

    public WeakAndItem() {
        this(-1);
    }

    public WeakAndItem(int N) {
        this("", N);
    }

    public WeakAndItem(String index, int n) {
        this.n = n;
        this.index = index == null ? "" : index;
    }

    @Override
    public Item.ItemType getItemType() {
        return Item.ItemType.WEAK_AND;
    }

    @Override
    public String getName() {
        return "WEAKAND";
    }

    @Override
    public void setIndexName(String index) {
        String toSet = index == null ? "" : index;
        super.setIndexName(toSet);
        this.index = toSet;
    }

    public String getIndexName() {
        return this.index;
    }

    @Override
    protected void appendHeadingString(StringBuilder buffer) {
        buffer.append(this.getName());
        buffer.append("(");
        buffer.append(this.getN());
        buffer.append(") ");
    }

    public int getN() {
        return this.nIsExplicit() ? this.n : 100;
    }

    public boolean nIsExplicit() {
        return this.n > 0;
    }

    public void setN(int N) {
        this.n = N;
    }

    @Override
    protected void encodeThis(ByteBuffer buffer) {
        super.encodeThis(buffer);
        IntegerCompressor.putCompressedPositiveNumber((int)this.getN(), (ByteBuffer)buffer);
        WeakAndItem.putString(this.index, buffer);
    }

    private WeakAndItem foldSegments() {
        WeakAndItem result = new WeakAndItem(this.index, this.n);
        for (Item child : this.items()) {
            SegmentItem segment;
            if (child instanceof SegmentItem && (segment = (SegmentItem)child).shouldFoldIntoWand()) {
                for (Item subItem : segment.items()) {
                    result.addItem(subItem);
                }
                continue;
            }
            result.addItem(child);
        }
        return result;
    }

    private boolean needsFolding() {
        for (Item subItem : this.items()) {
            SegmentItem segment;
            if (!(subItem instanceof SegmentItem) || !(segment = (SegmentItem)subItem).shouldFoldIntoWand()) continue;
            return true;
        }
        return false;
    }

    @Override
    public int encode(ByteBuffer buffer) {
        if (this.needsFolding()) {
            return this.foldSegments().encode(buffer);
        }
        return super.encode(buffer);
    }

    @Override
    public void disclose(Discloser discloser) {
        super.disclose(discloser);
        discloser.addProperty("N", this.getN());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.n, this.index);
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        WeakAndItem other = (WeakAndItem)object;
        if (this.n != other.n) {
            return false;
        }
        return Objects.equals(this.index, other.index);
    }
}

