/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.query;

import com.yahoo.prelude.query.BlockItem;
import com.yahoo.prelude.query.IndexedItem;
import com.yahoo.prelude.query.Item;
import com.yahoo.prelude.query.PhraseSegmentItem;
import com.yahoo.prelude.query.SegmentItem;
import com.yahoo.prelude.query.TermItem;
import java.util.ListIterator;

public class AndSegmentItem
extends SegmentItem
implements BlockItem {
    public AndSegmentItem(String rawWord, boolean isFromQuery, boolean stemmed) {
        super(rawWord, rawWord, isFromQuery, stemmed, null);
    }

    public AndSegmentItem(String rawWord, String current, boolean isFromQuery, boolean stemmed) {
        super(rawWord, current, isFromQuery, stemmed, null);
    }

    public AndSegmentItem(PhraseSegmentItem item) {
        super(item.getRawWord(), item.stringValue(), item.isFromQuery(), item.isStemmed(), null);
        this.shouldFoldIntoWand(item.shouldFoldIntoWand());
        int weight = item.getWeight();
        if (item.getItemCount() > 0) {
            ListIterator<Item> i = item.getItemIterator();
            while (i.hasNext()) {
                TermItem word = (TermItem)i.next();
                word.setWeight(weight);
                this.addItem(word);
            }
        }
    }

    @Override
    public Item.ItemType getItemType() {
        return Item.ItemType.AND;
    }

    @Override
    public String getName() {
        return "SAND";
    }

    @Override
    public String getIndexName() {
        if (this.getItemCount() == 0) {
            return "";
        }
        return ((IndexedItem)((Object)this.getItem(0))).getIndexName();
    }

    @Override
    public void setWeight(int w) {
        ListIterator<Item> i = this.getItemIterator();
        while (i.hasNext()) {
            ((Item)i.next()).setWeight(w);
        }
    }
}

