/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.grouping.vespa;

import com.yahoo.prelude.fastsearch.DocsumDefinitionSet;
import com.yahoo.prelude.fastsearch.FastHit;
import com.yahoo.prelude.fastsearch.GroupingListHit;
import com.yahoo.search.Searcher;
import com.yahoo.search.grouping.vespa.ResultBuilder;
import com.yahoo.search.result.Relevance;
import com.yahoo.searchlib.aggregation.FS4Hit;
import com.yahoo.searchlib.aggregation.Hit;
import com.yahoo.searchlib.aggregation.VdsHit;

class HitConverter
implements ResultBuilder.HitConverter {
    private final Searcher searcher;

    public HitConverter(Searcher searcher) {
        this.searcher = searcher;
    }

    @Override
    public com.yahoo.search.result.Hit toSearchHit(String summaryClass, Hit hit) {
        if (hit instanceof FS4Hit) {
            return this.convertFs4Hit(summaryClass, (FS4Hit)hit);
        }
        if (hit instanceof VdsHit) {
            return this.convertVdsHit(summaryClass, (VdsHit)hit);
        }
        throw new UnsupportedOperationException("Hit type '" + hit.getClass().getName() + "' not supported.");
    }

    private com.yahoo.search.result.Hit convertFs4Hit(String summaryClass, FS4Hit groupHit) {
        FastHit hit = new FastHit(groupHit.getGlobalId().getRawId(), new Relevance(groupHit.getRank()), groupHit.getPath(), groupHit.getDistributionKey());
        hit.setFillable();
        hit.setSearcherSpecificMetaData(this.searcher, summaryClass);
        GroupingListHit hitContext = (GroupingListHit)groupHit.getContext();
        if (hitContext == null) {
            throw new NullPointerException("Hit has no context.");
        }
        hit.setSource(hitContext.getSource());
        hit.setQuery(hitContext.getQuery());
        return hit;
    }

    private com.yahoo.search.result.Hit convertVdsHit(String summaryClass, VdsHit grpHit) {
        FastHit hit = new FastHit();
        hit.setRelevance(grpHit.getRank());
        if (grpHit.getSummary().getData().length > 0) {
            GroupingListHit hitContext = (GroupingListHit)grpHit.getContext();
            if (hitContext == null) {
                throw new NullPointerException("Hit has no context.");
            }
            DocsumDefinitionSet defs = hitContext.getDocsumDefinitionSet();
            defs.lazyDecode(summaryClass, grpHit.getSummary().getData(), hit);
            hit.setField("sddocname", hitContext.getSchema().name());
            hit.setFilled(summaryClass);
            hit.setQuery(hitContext.getQuery());
        }
        return hit;
    }
}

