/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.query;

import com.yahoo.api.annotations.Beta;
import com.yahoo.prelude.Freshness;
import com.yahoo.prelude.Location;
import com.yahoo.processing.request.CompoundName;
import com.yahoo.search.Query;
import com.yahoo.search.query.QueryHelper;
import com.yahoo.search.query.Sorting;
import com.yahoo.search.query.profile.types.FieldDescription;
import com.yahoo.search.query.profile.types.FieldType;
import com.yahoo.search.query.profile.types.QueryProfileFieldType;
import com.yahoo.search.query.profile.types.QueryProfileType;
import com.yahoo.search.query.ranking.Diversity;
import com.yahoo.search.query.ranking.GlobalPhase;
import com.yahoo.search.query.ranking.MatchPhase;
import com.yahoo.search.query.ranking.Matching;
import com.yahoo.search.query.ranking.RankFeatures;
import com.yahoo.search.query.ranking.RankProperties;
import com.yahoo.search.query.ranking.SecondPhase;
import com.yahoo.search.query.ranking.Significance;
import com.yahoo.search.query.ranking.SoftTimeout;
import com.yahoo.search.result.ErrorMessage;
import java.util.Objects;

public class Ranking
implements Cloneable {
    public static final CompoundName RANKFEATURES = CompoundName.from((String)"rankfeatures");
    private static final QueryProfileType argumentType = new QueryProfileType("ranking");
    private static final CompoundName argumentTypeName;
    public static final String RANKING = "ranking";
    public static final String LOCATION = "location";
    public static final String PROFILE = "profile";
    public static final String SORTING = "sorting";
    public static final String LIST_FEATURES = "listFeatures";
    public static final String FRESHNESS = "freshness";
    public static final String QUERYCACHE = "queryCache";
    public static final String RERANKCOUNT = "rerankCount";
    public static final String KEEPRANKCOUNT = "keepRankCount";
    public static final String RANKSCOREDROPLIMIT = "rankScoreDropLimit";
    public static final String MATCH_PHASE = "matchPhase";
    public static final String SECOND_PHASE = "secondPhase";
    public static final String GLOBAL_PHASE = "globalPhase";
    public static final String DIVERSITY = "diversity";
    public static final String SIGNIFICANCE = "significance";
    public static final String SOFTTIMEOUT = "softtimeout";
    public static final String MATCHING = "matching";
    public static final String FEATURES = "features";
    public static final String PROPERTIES = "properties";
    private Query parent;
    private Location location = null;
    private String profile = null;
    private Sorting sorting = null;
    private boolean listFeatures = false;
    private Freshness freshness;
    private boolean queryCache = false;
    private Integer rerankCount = null;
    private Integer keepRankCount = null;
    private Double rankScoreDropLimit = null;
    private RankProperties rankProperties = new RankProperties();
    private RankFeatures rankFeatures;
    private MatchPhase matchPhase = new MatchPhase();
    private SecondPhase secondPhase = new SecondPhase();
    private GlobalPhase globalPhase = new GlobalPhase();
    private Matching matching = new Matching();
    private SoftTimeout softTimeout = new SoftTimeout();
    private Significance significance = new Significance();

    public static QueryProfileType getArgumentType() {
        return argumentType;
    }

    public Ranking(Query parent) {
        this.parent = parent;
        this.rankFeatures = new RankFeatures(this);
    }

    public boolean hasRankProfile() {
        return this.profile != null;
    }

    public Freshness getFreshness() {
        return this.freshness;
    }

    public void setFreshness(String dateTime) {
        try {
            Freshness freshness = new Freshness(dateTime);
            this.setFreshness(freshness);
        }
        catch (NumberFormatException e) {
            this.parent.errors().add(ErrorMessage.createInvalidQueryParameter("Datetime reference could not be converted from '" + dateTime + "' to long"));
        }
    }

    public void setFreshness(Freshness freshness) {
        this.freshness = freshness;
    }

    public void setQueryCache(boolean queryCache) {
        this.queryCache = queryCache;
    }

    public boolean getQueryCache() {
        return this.queryCache;
    }

    public void setRerankCount(int rerankCount) {
        this.rerankCount = rerankCount;
    }

    public Integer getRerankCount() {
        return this.rerankCount;
    }

    public void setKeepRankCount(int keepRankCount) {
        this.keepRankCount = keepRankCount;
    }

    public Integer getKeepRankCount() {
        return this.keepRankCount;
    }

    public void setRankScoreDropLimit(double rankScoreDropLimit) {
        this.rankScoreDropLimit = rankScoreDropLimit;
    }

    public Double getRankScoreDropLimit() {
        return this.rankScoreDropLimit;
    }

    public Location getLocation() {
        return this.location;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    public void setLocation(String str) {
        this.location = new Location(str);
    }

    public String getProfile() {
        return this.profile == null ? "default" : this.profile;
    }

    public void setProfile(String profile) {
        if (profile == null) {
            throw new NullPointerException("The ranking profile cannot be set to null");
        }
        this.profile = profile;
    }

    public RankFeatures getFeatures() {
        return this.rankFeatures;
    }

    public RankProperties getProperties() {
        return this.rankProperties;
    }

    public void setListFeatures(boolean listFeatures) {
        this.listFeatures = listFeatures;
    }

    public boolean getListFeatures() {
        return this.listFeatures;
    }

    public MatchPhase getMatchPhase() {
        return this.matchPhase;
    }

    public SecondPhase getSecondPhase() {
        return this.secondPhase;
    }

    public GlobalPhase getGlobalPhase() {
        return this.globalPhase;
    }

    public Matching getMatching() {
        return this.matching;
    }

    public SoftTimeout getSoftTimeout() {
        return this.softTimeout;
    }

    @Beta
    public Significance getSignificance() {
        return this.significance;
    }

    public Sorting getSorting() {
        return this.sorting;
    }

    public void setSorting(Sorting sorting) {
        this.sorting = sorting == null || sorting.fieldOrders().isEmpty() ? null : sorting;
    }

    public void setSorting(String sortingString) {
        if (sortingString == null) {
            this.setSorting((Sorting)null);
        } else {
            this.setSorting(new Sorting(sortingString, this.parent));
        }
    }

    public static Ranking getFrom(Query q) {
        return (Ranking)q.properties().get(argumentTypeName);
    }

    public void prepare() {
        this.rankFeatures.prepare(this.rankProperties);
        this.matchPhase.prepare(this.rankProperties);
        this.secondPhase.prepare(this.rankProperties);
        this.matching.prepare(this.rankProperties);
        this.softTimeout.prepare(this.rankProperties);
        this.prepareNow(this.freshness);
        if (this.rerankCount != null) {
            this.rankProperties.put("vespa.hitcollector.heapsize", this.rerankCount);
        }
        if (this.keepRankCount != null) {
            this.rankProperties.put("vespa.hitcollector.arraysize", this.keepRankCount);
        }
        if (this.rankScoreDropLimit != null) {
            this.rankProperties.put("vespa.hitcollector.rankscoredroplimit", this.rankScoreDropLimit);
        }
    }

    private void prepareNow(Freshness freshness) {
        if (freshness == null) {
            return;
        }
        if (this.rankProperties.get("vespa.now") == null || this.rankProperties.get("vespa.now").isEmpty()) {
            this.rankProperties.put("vespa.now", "" + freshness.getRefTime());
        }
    }

    private void setParent(Query parent) {
        this.parent = Objects.requireNonNull(parent, "A ranking objects parent cannot be null");
    }

    public Query getParent() {
        return this.parent;
    }

    public Ranking clone() {
        try {
            Ranking clone = (Ranking)super.clone();
            if (this.sorting != null) {
                clone.sorting = this.sorting.clone();
            }
            clone.rankProperties = this.rankProperties.clone();
            clone.rankFeatures = this.rankFeatures.cloneFor(clone);
            clone.matchPhase = this.matchPhase.clone();
            clone.globalPhase = this.globalPhase.clone();
            clone.matching = this.matching.clone();
            clone.softTimeout = this.softTimeout.clone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Someone inserted a noncloneable superclass", e);
        }
    }

    public Ranking cloneFor(Query parent) {
        Ranking ranking = this.clone();
        ranking.setParent(parent);
        return ranking;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Ranking)) {
            return false;
        }
        Ranking other = (Ranking)o;
        if (!QueryHelper.equals(this.rankProperties, other.rankProperties)) {
            return false;
        }
        if (!QueryHelper.equals(this.rankFeatures, other.rankFeatures)) {
            return false;
        }
        if (!QueryHelper.equals(this.freshness, other.freshness)) {
            return false;
        }
        if (!QueryHelper.equals(this.sorting, other.sorting)) {
            return false;
        }
        if (!QueryHelper.equals(this.location, other.location)) {
            return false;
        }
        if (!QueryHelper.equals(this.profile, other.profile)) {
            return false;
        }
        return QueryHelper.equals(this.globalPhase, other.globalPhase);
    }

    public int hashCode() {
        return Objects.hash(this.rankFeatures, this.rankProperties, this.matchPhase, this.globalPhase, this.softTimeout, this.matching, this.sorting, this.location, this.profile);
    }

    static {
        argumentType.setStrict(true);
        argumentType.setBuiltin(true);
        argumentType.addField(new FieldDescription(PROFILE, "string", RANKING));
        argumentType.addField(new FieldDescription(LOCATION, "string", LOCATION));
        argumentType.addField(new FieldDescription(SORTING, "string", "sorting sortspec"));
        argumentType.addField(new FieldDescription(LIST_FEATURES, "string", RANKFEATURES.toString()));
        argumentType.addField(new FieldDescription(FRESHNESS, "string", "datetime"));
        argumentType.addField(new FieldDescription(QUERYCACHE, "boolean"));
        argumentType.addField(new FieldDescription(RERANKCOUNT, "integer"));
        argumentType.addField(new FieldDescription(KEEPRANKCOUNT, "integer"));
        argumentType.addField(new FieldDescription(RANKSCOREDROPLIMIT, "double"));
        argumentType.addField(new FieldDescription(GLOBAL_PHASE, new QueryProfileFieldType(GlobalPhase.getArgumentType())));
        argumentType.addField(new FieldDescription(MATCH_PHASE, (FieldType)new QueryProfileFieldType(MatchPhase.getArgumentType()), MATCH_PHASE));
        argumentType.addField(new FieldDescription(SECOND_PHASE, new QueryProfileFieldType(SecondPhase.getArgumentType())));
        argumentType.addField(new FieldDescription(DIVERSITY, new QueryProfileFieldType(Diversity.getArgumentType())));
        argumentType.addField(new FieldDescription(SOFTTIMEOUT, new QueryProfileFieldType(SoftTimeout.getArgumentType())));
        argumentType.addField(new FieldDescription(MATCHING, new QueryProfileFieldType(Matching.getArgumentType())));
        argumentType.addField(new FieldDescription(SIGNIFICANCE, new QueryProfileFieldType(Significance.getArgumentType())));
        argumentType.addField(new FieldDescription(FEATURES, "query-profile", "rankfeature input"));
        argumentType.addField(new FieldDescription(PROPERTIES, "query-profile", "rankproperty"));
        argumentType.freeze();
        argumentTypeName = CompoundName.from((String)argumentType.getId().getName());
    }
}

