/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.searchers;

import com.yahoo.component.chain.dependencies.After;
import com.yahoo.component.chain.dependencies.Before;
import com.yahoo.prelude.query.HasIndexItem;
import com.yahoo.prelude.query.Item;
import com.yahoo.prelude.query.PrefixItem;
import com.yahoo.prelude.query.ToolBox;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.Searcher;
import com.yahoo.search.result.ErrorMessage;
import com.yahoo.search.schema.Field;
import com.yahoo.search.schema.FieldInfo;
import com.yahoo.search.schema.SchemaInfo;
import com.yahoo.search.searchchain.Execution;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

@After(value={"SelectParameterParsing"})
@Before(value={"backend"})
public class QueryValidator
extends Searcher {
    @Override
    public Result search(Query query, Execution execution) {
        SchemaInfo.Session session = execution.context().schemaInfo().newSession(query);
        ToolBox.visit(new TermSearchValidator(session), query.getModel().getQueryTree().getRoot());
        PrefixSearchValidator prefixValidator = new PrefixSearchValidator(session);
        ToolBox.visit(prefixValidator, query.getModel().getQueryTree().getRoot());
        Result result = execution.search(query);
        prefixValidator.errors.forEach(error -> result.hits().addError((ErrorMessage)((Object)error)));
        return result;
    }

    private static class TermSearchValidator
    extends TermValidator {
        public TermSearchValidator(SchemaInfo.Session schema) {
            super(schema);
        }

        @Override
        public boolean visit(Item item) {
            if (item instanceof HasIndexItem) {
                HasIndexItem indexItem = (HasIndexItem)((Object)item);
                Optional<FieldInfo> field = this.schema.fieldInfo(indexItem.getIndexName());
                if (field.isEmpty()) {
                    return true;
                }
                if (field.get().type().kind() == Field.Type.Kind.TENSOR) {
                    throw new IllegalArgumentException("Cannot search for terms in '" + indexItem.getIndexName() + "': It is a tensor field");
                }
            }
            return true;
        }
    }

    private static class PrefixSearchValidator
    extends TermValidator {
        final List<ErrorMessage> errors = new ArrayList<ErrorMessage>();

        public PrefixSearchValidator(SchemaInfo.Session schema) {
            super(schema);
        }

        @Override
        public boolean visit(Item item) {
            if (this.schema.isStreaming()) {
                return true;
            }
            if (item instanceof PrefixItem) {
                PrefixItem prefixItem = (PrefixItem)item;
                Optional<FieldInfo> field = this.schema.fieldInfo(prefixItem.getIndexName());
                if (field.isEmpty()) {
                    return true;
                }
                if (!field.get().isAttribute()) {
                    this.errors.add(ErrorMessage.createIllegalQuery("'" + prefixItem.getIndexName() + "' is not an attribute field: Prefix matching is not supported"));
                }
                if (field.get().isIndex()) {
                    this.errors.add(ErrorMessage.createIllegalQuery("'" + prefixItem.getIndexName() + "' is an index field: Prefix matching is not supported even when it is also an attribute"));
                }
            }
            return true;
        }
    }

    private static abstract class TermValidator
    extends ToolBox.QueryVisitor {
        final SchemaInfo.Session schema;

        public TermValidator(SchemaInfo.Session schema) {
            this.schema = schema;
        }
    }
}

