/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.result;

import com.yahoo.collections.ArraySet;
import com.yahoo.component.provider.ListenableFreezableClass;
import com.yahoo.net.URI;
import com.yahoo.prelude.hitfield.HitField;
import com.yahoo.processing.Request;
import com.yahoo.processing.response.Data;
import com.yahoo.search.Query;
import com.yahoo.search.Searcher;
import com.yahoo.search.result.FeatureData;
import com.yahoo.search.result.HitGroup;
import com.yahoo.search.result.Relevance;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.BiConsumer;

public class Hit
extends ListenableFreezableClass
implements Data,
Comparable<Hit>,
Cloneable {
    private static final String DOCUMENT_ID = "documentid";
    private Map<String, Object> fields = null;
    private Map<String, Object> unmodifiableFieldMap = null;
    private Map<Searcher, Object> searcherSpecificMetaData;
    private URI id;
    private Set<String> types = null;
    private Relevance relevance;
    private boolean cached = false;
    private Set<String> filled = null;
    private Set<String> unmodifiableFilled = null;
    private String source = null;
    private int addNumber = -1;
    private Query query;
    private boolean meta = false;
    private boolean auxiliary = false;
    public static final String RANKFEATURES_FIELD = "rankfeatures";
    public static final String SDDOCNAME_FIELD = "sddocname";

    protected Hit() {
    }

    protected Hit(Relevance relevance) {
        this.relevance = relevance;
    }

    public Hit(String id) {
        this(id, 1.0);
    }

    public Hit(String id, Query query) {
        this(id, 1.0, query);
    }

    public Hit(String id, double relevance) {
        this(id, new Relevance(relevance));
    }

    public Hit(String id, double relevance, Query query) {
        this(id, new Relevance(relevance), query);
    }

    public Hit(String id, Relevance relevance) {
        this(id, relevance, (String)null);
    }

    public Hit(String id, Relevance relevance, Query query) {
        this(id, relevance, null, query);
    }

    public Hit(String id, double relevance, String source) {
        this(id, new Relevance(relevance), source, null);
    }

    public Hit(String id, double relevance, String source, Query query) {
        this(id, new Relevance(relevance), source);
    }

    public Hit(String id, Relevance relevance, String source) {
        this(id, relevance, source, null);
    }

    public Hit(String id, Relevance relevance, String source, Query query) {
        this.id = new URI(id);
        this.relevance = relevance;
        this.source = source;
        this.query = query;
    }

    public void setId(String id) {
        if (this.id != null) {
            throw new IllegalStateException("Attempt to change id of " + this + " to " + id);
        }
        if (id == null) {
            throw new NullPointerException("Attempt to assign id of " + this + " to null");
        }
        this.assignId(new URI(id));
    }

    public void setId(URI id) {
        if (this.id != null) {
            throw new IllegalStateException("Attempt to change id of " + this + " to " + id);
        }
        this.assignId(id);
    }

    protected final void assignId(URI id) {
        if (id == null) {
            throw new NullPointerException("Attempt to assign id of " + this + " to null");
        }
        this.id = id;
    }

    public URI getId() {
        return this.id;
    }

    public String getDisplayId() {
        String id = null;
        Object idField = this.getField(DOCUMENT_ID);
        if (idField != null) {
            id = idField.toString();
        }
        if (id == null) {
            id = this.getId() == null ? null : this.getId().toString();
        }
        return id;
    }

    public void setRelevance(Relevance relevance) {
        this.relevance = Objects.requireNonNull(relevance);
    }

    public void setRelevance(double relevance) {
        this.setRelevance(new Relevance(relevance));
    }

    public Relevance getRelevance() {
        return this.relevance;
    }

    public void setCached(boolean cached) {
        this.cached = cached;
    }

    public boolean isCached() {
        return this.cached;
    }

    public void setFillable() {
        if (this.filled == null) {
            this.filled = Collections.emptySet();
            this.unmodifiableFilled = this.filled;
        }
    }

    public void setFilled(String summaryClass) {
        if (this.filled == null || this.filled.isEmpty()) {
            this.filled = Collections.singleton(summaryClass);
            this.unmodifiableFilled = this.filled;
        } else if (this.filled.size() == 1) {
            this.filled = new HashSet<String>(this.filled);
            this.unmodifiableFilled = Collections.unmodifiableSet(this.filled);
            this.filled.add(summaryClass);
        } else {
            this.filled.add(summaryClass);
        }
    }

    public boolean isFillable() {
        return this.filled != null;
    }

    public Set<String> getFilled() {
        return this.unmodifiableFilled;
    }

    public boolean isFilled(String summaryClass) {
        return this.filled == null || this.filled.contains(summaryClass);
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getSource() {
        return this.source;
    }

    public void forEachField(BiConsumer<String, Object> consumer) {
        if (this.fields == null) {
            return;
        }
        this.fields.forEach(consumer);
    }

    public void forEachFieldAsRaw(RawUtf8Consumer consumer) {
        if (this.fields == null) {
            return;
        }
        this.fields.forEach(consumer);
    }

    public Map<String, Object> fields() {
        return this.getUnmodifiableFieldMap();
    }

    public Iterator<Map.Entry<String, Object>> fieldIterator() {
        return this.getFieldMap().entrySet().iterator();
    }

    public Set<String> fieldKeys() {
        return this.getFieldMap().keySet();
    }

    public void reserve(int minSize) {
        this.getFieldMap(minSize);
    }

    public Object setField(String key, Object value) {
        return this.getFieldMap().put(key, value);
    }

    public Object getField(String value) {
        return this.fields != null ? this.fields.get(value) : null;
    }

    public void clearFields() {
        this.getFieldMap().clear();
    }

    public Object removeField(String field) {
        return this.getFieldMap().remove(field);
    }

    protected boolean hasField(String name) {
        return this.fields != null && this.fields.containsKey(name);
    }

    protected boolean hasFields() {
        return this.fields != null && !this.fields.isEmpty();
    }

    private Map<String, Object> getFieldMap() {
        return this.getFieldMap(2);
    }

    private Map<String, Object> getFieldMap(int minSize) {
        if (this.fields == null) {
            this.fields = new LinkedHashMap<String, Object>(2 * minSize);
        }
        return this.fields;
    }

    private Map<String, Object> getUnmodifiableFieldMap() {
        if (this.unmodifiableFieldMap == null) {
            if (this.fields == null) {
                return Map.of();
            }
            this.unmodifiableFieldMap = Collections.unmodifiableMap(this.fields);
        }
        return this.unmodifiableFieldMap;
    }

    public HitField buildHitField(String key, boolean forceNoPreTokenize) {
        Object o = this.getField(key);
        if (o == null) {
            return null;
        }
        if (o instanceof HitField) {
            return (HitField)o;
        }
        HitField h = forceNoPreTokenize ? new HitField(key, o.toString(), false) : new HitField(key, o.toString());
        h.setOriginal(o);
        this.getFieldMap().put(key, h);
        return h;
    }

    public Set<String> types() {
        if (this.types == null) {
            this.types = new ArraySet(1);
        }
        return this.types;
    }

    int getAddNumber() {
        return this.addNumber;
    }

    void setAddNumber(int addNumber) {
        this.addNumber = addNumber;
    }

    public boolean isMeta() {
        return this.meta;
    }

    public void setMeta(boolean meta) {
        this.meta = meta;
    }

    public boolean isAuxiliary() {
        return this.isMeta() || this.auxiliary;
    }

    public void setAuxiliary(boolean auxiliary) {
        this.auxiliary = auxiliary;
    }

    public Query getQuery() {
        return this.query;
    }

    public Request request() {
        return this.query;
    }

    public final void setQuery(Query query) {
        if (this.query == null || this instanceof HitGroup) {
            this.query = query;
        }
    }

    public FeatureData features() {
        return FeatureData.empty();
    }

    public void setSearcherSpecificMetaData(Searcher searcher, Object data) {
        if (this.searcherSpecificMetaData == null) {
            if (data != null) {
                this.searcherSpecificMetaData = Map.of(searcher, data);
            }
        } else if (this.searcherSpecificMetaData.size() == 1) {
            if (this.searcherSpecificMetaData.containsKey((Object)searcher)) {
                this.searcherSpecificMetaData = data != null ? Map.of(searcher, data) : null;
            } else {
                this.searcherSpecificMetaData = new TreeMap<Searcher, Object>(this.searcherSpecificMetaData);
                this.searcherSpecificMetaData.put(searcher, data);
            }
        } else {
            this.searcherSpecificMetaData.put(searcher, data);
        }
    }

    public Object getSearcherSpecificMetaData(Searcher searcher) {
        return this.searcherSpecificMetaData != null ? this.searcherSpecificMetaData.get((Object)searcher) : null;
    }

    final void setFilledInternal(Set<String> filled) {
        this.filled = filled;
        this.unmodifiableFilled = filled != null ? Collections.unmodifiableSet(filled) : null;
    }

    final Set<String> getFilledInternal() {
        return this.filled;
    }

    protected void close() {
        this.query = null;
        this.fields = null;
        this.unmodifiableFieldMap = null;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Hit)) {
            return false;
        }
        return this.getId().equals((Object)((Hit)other).getId());
    }

    public int hashCode() {
        if (this.getId() == null) {
            throw new IllegalStateException("Id has not been set.");
        }
        return this.getId().hashCode();
    }

    @Override
    public int compareTo(Hit other) {
        int result = other.getRelevance().compareTo(this.getRelevance());
        if (result != 0) {
            return result;
        }
        result = this.getAddNumber() - other.getAddNumber();
        if (result != 0) {
            return result;
        }
        if (this.getId() == null && other.getId() == null) {
            return 0;
        }
        if (other.getId() == null) {
            return -1;
        }
        if (this.getId() == null) {
            return 1;
        }
        return this.getId().compareTo(other.getId());
    }

    public Hit clone() {
        Hit hit = (Hit)super.clone();
        hit.fields = this.fields != null ? new LinkedHashMap<String, Object>(this.fields) : null;
        hit.unmodifiableFieldMap = null;
        if (this.types != null) {
            hit.types = new LinkedHashSet<String>(this.types);
        }
        if (this.filled != null) {
            hit.setFilledInternal(new HashSet<String>(this.filled));
        }
        return hit;
    }

    public String toString() {
        return "hit " + this.getId() + " (relevance " + this.getRelevance() + ")";
    }

    public static interface RawUtf8Consumer
    extends BiConsumer<String, Object> {
        public void accept(String var1, byte[] var2, int var3, int var4);
    }
}

